
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHYTTC580;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.NICE_PINK;

/**
 *
 * @author virieux
 */
public class HYTTC580Panel extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger FCSLOG = Logger.getLogger(HYTTC580Panel.class.getName());
    private final String deviceName;
    private final String publishedDataKey;

    //general informations panel
    private final CanOpenDevicePanel generalInfoPanel;

    private final JLabel pdo1Label = new JLabel();
    private final JLabel pdo1HexLabel = new JLabel();
    private final JLabel pdo1BinLabel = new JLabel();
    private final JLabel pdo2Label = new JLabel();
    private final JLabel pdo2HexLabel = new JLabel();
    private final JLabel pdo2BinLabel = new JLabel();
    private final JLabel pdo4Label = new JLabel();
    private final JLabel pdo4HexLabel = new JLabel();
    private final JLabel pdo4BinLabel = new JLabel();
    /**
     * A Runnable to initialize this Panel from data coming from the Configuration system.
     */
    private class GuiInitialization implements Runnable {

        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            //General Informations Panel
            generalInfoPanel.initializeGui(configInfo);
        }
    }

    /**
     * A Runnable class to update this panel from data published on the STATUS bus
     * by the hyttc580 device (carousel sensors).
     */
    private class UpdateDevice implements Runnable {

        private StatusDataPublishedByHYTTC580 s;

        public UpdateDevice(StatusDataPublishedByHYTTC580 status) {
            this.s = status;
        }

        @Override
        public void run() {
            FCSLOG.fine(() -> "Updating HYTTC580Panel from StatusDataPublishedByHYTTC580 for deviceName = "
                    + deviceName);
            //General Informations Panel
            generalInfoPanel.updateCanOpenDevice(publishedDataKey, (StatusDataPublishedByHardware) s);

            pdo1Label.setText(Long.toString(s.getPdo1()));
            pdo1HexLabel.setText("0x" + Long.toHexString(s.getPdo1()));
            pdo1BinLabel.setText(Long.toBinaryString(s.getPdo1()));
            pdo2Label.setText(Long.toString(s.getPdo2()));
            pdo2HexLabel.setText("0x" + Long.toHexString(s.getPdo2()));
            pdo2BinLabel.setText(Long.toBinaryString(s.getPdo2()));
            pdo4Label.setText(Long.toString(s.getPdo4()));
            pdo4HexLabel.setText("0x" + Long.toHexString(s.getPdo4()));
            pdo4BinLabel.setText(Long.toBinaryString(s.getPdo4()));        }
    }

    public HYTTC580Panel(String hyttc580Name) {
        this.deviceName = hyttc580Name;
        this.generalInfoPanel = new CanOpenDevicePanel(hyttc580Name);
        int ind = deviceName.lastIndexOf("/");
        publishedDataKey = ind >=0 ? deviceName.substring(ind+1) : deviceName;
        initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new HYTTC580Panel.GuiInitialization(configInfo));
    }

    public void updateDevice(String name, StatusDataPublishedByHYTTC580 status) {
        if (publishedDataKey.equals(name)) {
            SwingUtilities.invokeLater(new UpdateDevice(status));
        }
    }

    private void initComponents() {
        setDefaultValues();
        /**
         ******************************************************************************
         ** PDO Panel
         * *****************************************************************************
         */
        JPanel pdoPanel = new JPanel();
        pdoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(NICE_PINK),
                "PDO"));
        pdoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;

        /* 1st column*/
        gbc3.anchor = GridBagConstraints.LINE_START;
        pdoPanel.add(new JLabel("pdo1:"), gbc3);
        gbc3.gridy++;
        pdoPanel.add(new JLabel("pdo1 (hexa):"), gbc3);
        gbc3.gridy++;
        pdoPanel.add(new JLabel("pdo1 (binaire):"), gbc3);
        gbc3.gridy++;
        pdoPanel.add(new JLabel("pdo2:"), gbc3);
        gbc3.gridy++;
        pdoPanel.add(new JLabel("pdo2 (hexa):"), gbc3);
        gbc3.gridy++;
        pdoPanel.add(new JLabel("pdo2 (binaire):"), gbc3);
        gbc3.gridy++;
        pdoPanel.add(new JLabel("pdo4:"), gbc3);
        gbc3.gridy++;
        pdoPanel.add(new JLabel("pdo4 (hexa):"), gbc3);
        gbc3.gridy++;
        pdoPanel.add(new JLabel("pdo4 (binaire):"), gbc3);

        /* 2nd column*/
        gbc3.anchor = GridBagConstraints.LINE_END;
        gbc3.gridx++;
        gbc3.gridy = 0;
        pdoPanel.add(pdo1Label, gbc3);
        gbc3.gridy++;
        pdoPanel.add(pdo1HexLabel, gbc3);
        gbc3.gridy++;
        pdoPanel.add(pdo1BinLabel, gbc3);
        gbc3.gridy++;
        pdoPanel.add(pdo2Label, gbc3);
        gbc3.gridy++;
        pdoPanel.add(pdo2HexLabel, gbc3);
        gbc3.gridy++;
        pdoPanel.add(pdo2BinLabel, gbc3);
        gbc3.gridy++;
        pdoPanel.add(pdo4Label, gbc3);
        gbc3.gridy++;
        pdoPanel.add(pdo4HexLabel, gbc3);
        gbc3.gridy++;
        pdoPanel.add(pdo4BinLabel, gbc3);
        /**
         ******************************************************************************
         ** end of PDO Panel
         * *****************************************************************************
         */

        /**
         ******************************************************************************
         ** Whole Panel
         * *****************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createLineBorder(Color.GREEN));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.NORTHWEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(generalInfoPanel, gbc);

        gbc.gridy++;
        add(pdoPanel, gbc);

        /**
         ******************************************************************************
         ** end of Whole Panel
         * *****************************************************************************
         */
    }

    private void setDefaultValues() {
        pdo1Label.setText("0");
        pdo1HexLabel.setText("0x0");
        pdo1BinLabel.setText("0");
        pdo2Label.setText("0");
        pdo2HexLabel.setText("0x0");
        pdo2BinLabel.setText("0");
        pdo4Label.setText("0");
        pdo4HexLabel.setText("0x0");
        pdo4BinLabel.setText("0");
    }

    public void resetPanel() {
        setDefaultValues();
        generalInfoPanel.resetPanel();
    }

    @Override
    public String toString() {
        int ind = deviceName.lastIndexOf("/");
        return ind >=0 ? deviceName.substring(ind+1) : deviceName;
    }

    public static void main(String[] argv) {

        HYTTC580Panel p = new HYTTC580Panel("hyttc580");

        JFrame frame = new JFrame("HYTTC580");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }



}
