
package org.lsst.ccs.subsystems.fcs.loader.ui;

import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_CARRIER_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_CLAMP_NAME;
import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

import java.util.logging.Logger;

/**
 *
 * @author virieux
 */
public interface InterfaceLoaderGUI extends InterfaceGeneralGUI {
    Logger FCSLOG = Logger.getLogger(InterfaceLoaderGUI.class.getName());
    long getLoGoToHandoffTimeout();

    long getLoGoToStorageTimeout();

    long getLoGoToEngagedTimeout();

    long getOpenHooksTimeout();

    long getCloseHooksTimeout();

    long getClampHooksTimeout();

    long getConnectLoaderTimeout();

    long getDisconnectLoaderTimeout();

    void setLoGoToHandoffTimeout(int aInt);

    void setLoGoToStorageTimeout(int aInt);

    void setLoGoToEngagedTimeout(int toInt);

    void setClampHooksTimeout(long clampHooksTimeout);

    void setCloseHooksTimeout(long closeHooksTimeout);

    void setOpenHooksTimeout(long openHooksTimeout);

    void setConnectLoaderTimeout(long connectLoaderTimeout);

    void setDisconnectLoaderTimeout(long disconnectLoaderTimeout);

    default void loLoadFilter() {
        FCSLOG.finer(()-> "GUI: Loading filter in camera with a timeout of " + getLoGoToHandoffTimeout());
        sendCommand("loadFilter", getLoGoToHandoffTimeout());
    }

    default void loUnloadFilter() {
        FCSLOG.finer(() -> "GUI: Unloading filter in camera with a timeout of " + getLoGoToHandoffTimeout());
        sendCommand("unloadFilter", getLoGoToHandoffTimeout());
    }

    default void connectLoaderStandalone(String loaderIdentifier) {
        FCSLOG.fine(() -> "GUI: Connecting loader CANbus with a timeout of " + getConnectLoaderTimeout());
        sendCommand("connectLoaderStandaloneCANbus " + loaderIdentifier, getConnectLoaderTimeout());
    }

    default void disconnectLoaderStandalone() {
        FCSLOG.fine(() -> "GUI: Disconnecting loader CANbus with a timeout of " + getDisconnectLoaderTimeout());
        sendCommand("disconnectLoaderStandaloneCANbus", getDisconnectLoaderTimeout());
    }

    default void loLoadFilterIntoBenchOrStorageBox() {
        FCSLOG.fine(() -> "GUI: Loading filter in storage box with a timeout of " + getLoGoToHandoffTimeout());
        sendCommand("loadFilterIntoBenchOrStorageBox", getLoGoToHandoffTimeout());
    }

    default void loUnloadFilterFromBenchOrStorageBox() {
        FCSLOG.fine(() -> "GUI: Unloading filter from storage box with a timeout of " + getLoGoToHandoffTimeout());
        sendCommand("unloadFilterFromBenchOrStorageBox", getLoGoToHandoffTimeout());
    }

    default void loMoveFilterStoH() {
        FCSLOG.fine(() -> "GUI: Move Filter to Handoff with a timeout of " + getLoGoToHandoffTimeout());
        sendCommand("moveFilterToHandoff", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loMoveFilterHtoS() {
        FCSLOG.fine(() -> "GUI: Move Filter to Storage with a timeout of " + getLoGoToHandoffTimeout());
        sendCommand("moveFilterToStorage", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loMoveEmptyToHandClose() {
        FCSLOG.fine(() -> "GUI: Move Empty to Handoff and Close with a timeout of " + getLoGoToHandoffTimeout());
        sendCommand("moveEmptyToHandoffAndClose", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loOpenClampAndMoveEmptyToS() {
        FCSLOG.fine(() -> "GUI: Open clamp and move Empty to Storage with a timeout of " + getLoGoToHandoffTimeout());
        sendCommand("openClampAndMoveEmptyToStorage", getLoGoToHandoffTimeout(), LOADER_NAME);
    }

    default void loGoToHandOff() {
        FCSLOG.fine(() -> "GUI: Carrier going to Handoff Position with a timeout of " + getLoGoToHandoffTimeout());
        sendCommand("goToHandOff", getLoGoToHandoffTimeout(), LOADER_CARRIER_NAME);
    }

    default void loGoToEngaged() {
        FCSLOG.fine(() -> "GUI: Carrier going to Engaged Position with a timeout of " + getLoGoToEngagedTimeout());
        sendCommand("goToEngaged", getLoGoToEngagedTimeout(), LOADER_CARRIER_NAME);
    }

    default void loGoToStorage() {
        FCSLOG.fine(() -> "GUI: Carrier going to Storage Position with a timeout of " + getLoGoToStorageTimeout());
        sendCommand("goToStorage", getLoGoToStorageTimeout(), LOADER_CARRIER_NAME);
    }

    default void loUpdateCarrierPosition() {
        FCSLOG.fine(() -> "GUI: Updating carrier position with a timeout of " + READ_CONTROLLER_TIMEOUT);
        sendCommand("updatePosition", READ_CONTROLLER_TIMEOUT, LOADER_CARRIER_NAME);
    }

    /* clamp commands */
    default void loClampHooks() {
        FCSLOG.fine(() -> "GUI: Clamping Hooks with a timeout of " +  getClampHooksTimeout());
        sendCommand("clamp", getClampHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void loCloseHooks() {
        FCSLOG.fine(() -> "GUI: Closing Hooks with a timeout of " + getCloseHooksTimeout());
        sendCommand("close", getCloseHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void loUnclampHooks() {
        FCSLOG.fine(() -> "GUI: Unclamping Hooks with a timeout of " + getClampHooksTimeout());
        sendCommand("unclamp", getClampHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void loOpenHooks() {
        FCSLOG.fine(() -> "GUI: Opening Hooks with a timeout of " + getOpenHooksTimeout());
        sendCommand("open", getOpenHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void loClampHoming() {
        FCSLOG.fine(() -> "GUI: Clamp homing with a timeout of "  + getOpenHooksTimeout());
        sendCommand("homing", getOpenHooksTimeout(), LOADER_CLAMP_NAME);
    }

    default void setLoSlowMode() {
        FCSLOG.fine(() -> "GUI: Loader Carrier entering slow mode with a timeout of " + READ_CONTROLLER_TIMEOUT);
        sendCommand("setSlowMode", READ_CONTROLLER_TIMEOUT, LOADER_CARRIER_NAME);
    }

    default void setLoFastMode() {
        FCSLOG.fine(() -> "GUI: Loader Carrier entering fast mode with a timeout of " + READ_CONTROLLER_TIMEOUT);
        sendCommand("setFastMode", READ_CONTROLLER_TIMEOUT, LOADER_CARRIER_NAME);
    }
}
