/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.HorizontalLine;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalLine;

public class Tools {
    private static final Logger FCSLOG = Logger.getLogger(Tools.class.getName());
    public static final Color greenColor = new Color(0, 165, 0);
    public static final Color NICE_PINK = new Color(255, 0, 255);
    public static final Color OVERVIEWBORDER_COLOR = Color.WHITE;
    private static final Color CONFIG_COLOR = new Color(17, 102, 117);
    public static final String fcsFontInString = "Lucida Grande";
    public static final Font BIG_FONT = new Font("Lucida Grande", 1, 14);
    public static final Font HUGE_FONT = new Font("Lucida Grande", 1, 20);
    public static final Font VERY_BIG_FONT = new Font("Tahoma", 1, 18);
    public static final Font defaultFont = UIManager.getDefaults().getFont("Label.font");
    public static final Insets insets_std = new Insets(4, 4, 4, 4);
    public static final Insets insets_big = new Insets(14, 4, 6, 4);
    public static final Insets insets_small = new Insets(1, 1, 1, 1);
    public static final String ZERO_VALUE = "0.0";
    public static final String UNKNOWN_VALUE = "999.99";
    public static final String UNKNOWN_STATE = "UNKNOWN STATE";
    public static final String UNKNOWN_ERROR = "UNKNOWN ERROR";
    public static final String NONE = "None";
    public static final String TIRETS = "--";
    public static final int SP_V_LINE_HEIGHT = 75;
    public static final int SP_V_LINE_STARTINGY = 22;
    public static final Dimension preferedPanelSize = new Dimension(1200, 600);
    public static final String AP1_EXP = "<HTML><b>AP1</b>: autochanger at STANDBY position</HTML>";
    public static final String AP2_EXP = "<HTML><b>AP2</b>: autochanger at HANDOFF position</HTML>";
    public static final String AP3_EXP = "<HTML><b>AP3</b>: autochanger at ONLINE position</HTML>";
    public static final String AF0_EXP = "<HTML><b>AF0</b>: autochanger latches opened</HTML>";
    public static final String AF1_EXP = "<HTML><b>AF1</b>: filter engaged on autochanger</HTML>";
    public static final String AF3_EXP = "<HTML><b>AF3</b>: filter engaged and latches closed on autochanger  &nbsp</HTML>";
    public static final String CS_EXP = "<HTML><b>CS</b>: carousel stopped at STANDBY position</HTML>";
    public static final String CFC_EXP = "<HTML><b>CFC</b>: filter LOCKED on carousel</HTML>";
    public static final String CF0_EXP = "<HTML><b>CF0</b>: no filter on carousel at STANDBY</HTML>";
    public static final String CF1_EXP = "<HTML><b>CF1</b>: filter on carousel at STANDBY</HTML>";
    public static final String NO_LOCKOUT = "<B>NOT</B><BR>Lock Out Bay L</BR>";

    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.LOCKABLE.toString())) {
            return greenColor;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE.toString())) {
            return Color.orange;
        }
        if (filterPresenceStatus.equals(FcsEnumerations.FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        }
        FCSLOG.severe("Unknown Filter Presence Status " + filterPresenceStatus);
        return Color.gray;
    }

    public static int toInt(Map<String, String> config, String parameterName) {
        if (config.containsKey(parameterName)) {
            return Integer.parseInt(config.get(parameterName));
        }
        FCSLOG.severe("no such parameter in ConfigurationInfo:" + parameterName);
        return 0;
    }

    public static void resetTable(JTable table) {
        FCSLOG.fine(() -> " resetting table " + table.getName());
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        tableModel.getDataVector().removeAllElements();
        tableModel.fireTableDataChanged();
    }

    public static String getShortComponentName(String fullPathName) {
        int ind = fullPathName.lastIndexOf("/");
        return ind >= 0 ? fullPathName.substring(ind + 1) : fullPathName;
    }

    public static JPanel createPanelWithComponent(String componentName, JComponent component, boolean drawHLineBefore, boolean drawHLineAfter) {
        int length = 30;
        return Tools.createPanelWithComponent(componentName, component, drawHLineBefore, drawHLineAfter, length);
    }

    public static JPanel createPanelWithComponent(String componentName, JComponent component, boolean drawHLineBefore, boolean drawHLineAfter, int length) {
        int hlStartingY = component instanceof DigitalSwitch ? 10 : (component instanceof DiamondSwitch ? 25 : 5);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        if (drawHLineBefore) {
            ++gbcp.gridy;
            panel.add((Component)new HorizontalLine(length, hlStartingY), gbcp);
            ++gbcp.gridx;
        }
        gbcp.gridy = 0;
        panel.add((Component)new JLabel("<HTML><CENTER>" + componentName + "</CENTER></HTML>"), gbcp);
        ++gbcp.gridy;
        panel.add((Component)component, gbcp);
        if (drawHLineAfter) {
            ++gbcp.gridx;
            panel.add((Component)new HorizontalLine(length, hlStartingY), gbcp);
        }
        return panel;
    }

    public static void addToHorizontalLine(JPanel panel, GridBagConstraints gbcl, String componentName, JComponent component, boolean drawLine) {
        int hlStartingY = 15;
        panel.add((Component)new JLabel("<HTML><CENTER>" + componentName + "</CENTER></HTML>"), gbcl);
        ++gbcl.gridy;
        panel.add((Component)component, gbcl);
        if (drawLine) {
            ++gbcl.gridx;
            panel.add((Component)new HorizontalLine(hlStartingY), gbcl);
        }
        --gbcl.gridy;
        if (drawLine) {
            ++gbcl.gridx;
        }
    }

    public static JPanel create_subPanelWith2Switch(String name1, JComponent switch1, String name2, JComponent switch2) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.anchor = 10;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        gbcp.gridx = 1;
        gbcp.gridheight = 1;
        panel.add((Component)Tools.createPanelWithComponent(name1, switch1, true, true), gbcp);
        ++gbcp.gridx;
        ++gbcp.gridy;
        gbcp.gridx = 1;
        panel.add((Component)Tools.createPanelWithComponent(name2, switch2, true, true), gbcp);
        gbcp.gridy = 0;
        gbcp.gridx = 5;
        gbcp.gridheight = 2;
        panel.add((Component)new VerticalLine(75, 22), gbcp);
        return panel;
    }

    public static TitledBorder getConfigurationTitle() {
        return BorderFactory.createTitledBorder(BorderFactory.createLineBorder(CONFIG_COLOR, 2), "Configuration", 5, 5, defaultFont.deriveFont(2), CONFIG_COLOR);
    }

    public static String formatButtonLabelWhenLinkedWithATooltip(String label) {
        return String.format("<html><u>%s</u>%s<html>", label.substring(0, 2), label.substring(2));
    }

    public static String formatTooltipText(String command, String text) {
        Object res = String.format("<html>Command: <b>%s</b>", command);
        res = text.isEmpty() ? (String)res + "<html>" : (String)res + String.format("<br>%s</html>", text);
        return res;
    }

    public static TitledBorder getGeneralPanelTitle(String title) {
        return BorderFactory.createTitledBorder(BorderFactory.createLineBorder(OVERVIEWBORDER_COLOR, 2), title, 3, 2);
    }

    public static Component getPlaceHolder(String type) {
        switch (type) {
            case "autochanger": {
                return new JLabel("ONLINE clamps state:");
            }
            case "autochanger_status": {
                return new JLabel("No filter:");
            }
            case "carousel": {
                return new JLabel("CS (stopped at standby");
            }
            case "carousel_status": {
                return new JLabel("short");
            }
            case "loader": {
                return new JLabel("Carrier position:");
            }
            case "switch": {
                return new DigitalSwitch("fake", "fake");
            }
        }
        return new JLabel("generic)");
    }

    public static Component getPanelPlaceHolder(String type) {
        JPanel pane = new JPanel();
        switch (type) {
            case "autochanger_pane": 
            case "loader_pane": {
                pane.add(new JLabel("--ac-----------------------------"));
                break;
            }
            case "carousel_pane": {
                pane.add(new JLabel("--ca------------------------------------------"));
                break;
            }
            default: {
                pane.add(new JLabel("generic"));
            }
        }
        return pane;
    }
}

