/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.dataforth;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20AnalogOut;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;

public class Maq20AnalogControl
implements HasLifecycle,
Maq20Device.Maq20Control {
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected Maq20Device maqDevc;
    protected Integer modIndex;
    protected String[] ranges;
    private static final Logger LOG = Logger.getLogger(Maq20AnalogControl.class.getName());
    private Maq20Device.ModuleData modData;
    private Integer[] rangeValues;

    public void init() {
        if (this.modIndex == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "modIndex", "not specified");
        }
        this.modData = this.maqDevc.getModuleData(this.modIndex);
        if (this.modData == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "modIndex (" + this.modIndex + ")", "specifies non-existent module");
        }
        Maq20Device.ModuleDef modDef = this.modData.modDef;
        if (modDef.opType != 1) {
            ErrorUtils.reportConfigError(LOG, this.path, "modIndex (" + this.modIndex + ")", "specifies non-analog output module");
        }
        if (this.ranges != null && this.ranges.length > modDef.numChan) {
            ErrorUtils.reportConfigError(LOG, this.path, "ranges", "has more than " + modDef.numChan + " elements");
        }
        this.rangeValues = new Integer[modDef.numChan];
        if (this.ranges != null) {
            for (int chan = 0; chan < this.ranges.length; ++chan) {
                String range = this.ranges[chan];
                if (range == null || range.trim().isEmpty()) continue;
                Integer rangeValue = modDef.rangeMap.get(range);
                if (rangeValue == null) {
                    ErrorUtils.reportConfigError(LOG, this.path, "range " + range, "not valid for " + modDef.type + " module");
                }
                this.rangeValues[chan] = rangeValue;
            }
        }
    }

    @Override
    public void initialize() throws DriverException {
        Maq20AnalogOut anaOut = this.getAnaOut();
        for (int chan = 0; chan < this.modData.modDef.numChan; ++chan) {
            if (this.rangeValues[chan] == null) continue;
            anaOut.setRange(chan, this.rangeValues[chan].intValue());
        }
    }

    @Override
    public void close() {
    }

    public void writeValue(int chan, double value) throws DriverException {
        this.getAnaOut().writeValue(chan, value);
    }

    public double readValue(int chan) throws DriverException {
        return this.getAnaOut().readValue(chan);
    }

    public int getModIndex() {
        return this.modIndex == null ? -1 : this.modIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    private Maq20AnalogOut getAnaOut() throws DriverException {
        if (this.modData.maqAnaOut == null) {
            throw new DriverException("Connection not open");
        }
        return this.modData.maqAnaOut;
    }
}

