
package org.lsst.ccs.subsystems.fcs.ui;

import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import java.awt.CardLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import static org.lsst.ccs.subsystems.fcs.carousel.ui.PLCCarouselPanel.CF0;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.PLCCarouselPanel.CF0B;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.PLCCarouselPanel.CF1;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.PLCCarouselPanel.CF1B;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.PLCCarouselPanel.CS;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.PLCCarouselPanel.CSB;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FixedSizePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalTextComponent;

/**
 * A panel to display carousel signals : CFC, CS, CF0, CF1
 *
 * @author virieux
 */
public class CarouselStatusPanel extends JPanel {

    public static final String title = "Carousel Protection Status";
    private static final long serialVersionUID = 1L;

    public static final String CFC = "caCFC";
    public static final String CFCB = "caCFCb";

    private final DigitalSwitch carousel_CFC_Switch = new DigitalSwitch(CFC, CFCB); // Carousel_CFC
    private final DigitalSwitch carousel_CS_Switch = new DigitalSwitch(CS, CSB); // Carousel_CS
    private final DigitalSwitch carousel_CF0_Switch = new DigitalSwitch(CF0, CF0B); // Carousel_CF0
    private final DigitalSwitch carousel_CF1_Switch = new DigitalSwitch(CF1, CF1B); // Carousel_CF1

    private final DigitalSwitch[] digitalList = new DigitalSwitch[]{
        carousel_CFC_Switch, carousel_CS_Switch, carousel_CF0_Switch, carousel_CF1_Switch,
    };

    public CarouselStatusPanel() {
        initComponents();
    }

    /**
     * To update this panel from a map of sensors : name, value.
     */
    private class UpdateFromSensorList implements Runnable {

        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            for (DigitalSwitch ds: digitalList) {
                ds.updateColorComplementary(sensorMap);
            }
        }
    }



    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        // composition:
        // - GlobalPanel with a CardLayout
        // - visible card is for the display
        // - invisible card sets the dimensions
        JPanel statusPane = new JPanel();
        statusPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Carousel"), 2), "httc580"));
        statusPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.WEST;
        statusPane.add(new JLabel("CFC (filter clamped)"), gbc);
        gbc.gridy++;
        statusPane.add(new JLabel("CS (stopped at standby)"), gbc);
        gbc.gridy++;
        statusPane.add(new JLabel("CF0 (no filter)"), gbc);
        gbc.gridy++;
        statusPane.add(new JLabel("CF1 (filter on socket)"), gbc);
        gbc.gridy++;
        statusPane.add(new FixedSizePanel(Tools.getPlaceHolder("carousel")), gbc);
        gbc.gridy++;
        statusPane.add(new FixedSizePanel(Tools.getPlaceHolder("carousel")), gbc);

        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.EAST;
        statusPane.add(carousel_CFC_Switch, gbc); // CFC
        gbc.gridy++;
        statusPane.add(carousel_CS_Switch, gbc);
        gbc.gridy++;
        statusPane.add(carousel_CF0_Switch, gbc);
        gbc.gridy++;
        statusPane.add(carousel_CF1_Switch, gbc);
        gbc.gridy++;
        //statusPane.add(new FixedSizePanel(Tools.getPlaceHolder("carousel_status"), Tools.getPlaceHolder("switch"), true), gbc);
        statusPane.add(new FixedSizePanel(new DigitalSwitch("fake", "fake")), gbc);
        gbc.gridy++;
        //statusPane.add(new FixedSizePanel(Tools.getPlaceHolder("carousel_status"), Tools.getPlaceHolder("switch"), true), gbc);
        statusPane.add(new FixedSizePanel(new DigitalSwitch("fake", "fake")), gbc);

        JPanel carouselStatusPane = new JPanel();
        carouselStatusPane.setLayout(new BoxLayout(carouselStatusPane, BoxLayout.X_AXIS));
        carouselStatusPane.add(new VerticalTextComponent("Carousel"));
        carouselStatusPane.add(statusPane);

        setLayout(new CardLayout());
        add(carouselStatusPane);
        add(Tools.getPanelPlaceHolder("carousel_pane"));
        setDefaultValues();
    }

    /**
     * set default values for components color and labels.
     */
    protected void setDefaultValues() {
        for (DigitalSwitch ds: digitalList) {
            ds.setColor(Color.GRAY);
        }
    }

    @Override
    public String toString() {
        return title;
    }

    public static void main(String[] argv) {
        CarouselStatusPanel d = new CarouselStatusPanel();
        JFrame frame = new JFrame("Carousel Status Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
