
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByOnlineProximityProbe;

import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.ALM;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.ALMB;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.CF0;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.CF0B;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.CF1;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.CF1B;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.CFC;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.CFCB;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.CS;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.CSB;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.ENG;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.ENGB;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.LOCK;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.LOCKB;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.LPS;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.LPSB;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.LRH;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.LRHB;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.RELAYCLAMPS;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.RELAYLATCHES;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.RELAYRAIL1;
import static org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel.RELAYRAIL2;
import org.lsst.ccs.subsystems.fcs.ui.commons.DiamondSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.UNKNOWN_STATE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.ZERO_VALUE;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_small;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;


/**
 *
 * @author virieux
 */
public class AutochangerGeneralViewPanel extends JPanel {
    private static final long serialVersionUID = -713173978095339372L;

    public static final String INCLINOMETERXMINUS = "inclinometerXminus";
    public static final String INCLINOMETERXPLUS = "inclinometerXplus";

    private InterfaceAutochangerGUI subs;

    //LoaderConnectedPanel
    private final JPanel loaderStatusPanel = new JPanel();
    private final DigitalSwitch loader_LPS_Switch = new DigitalSwitch(LPS, LPSB);
    private final DigitalSwitch loader_LRH_Switch = new DigitalSwitch(LRH, LRHB);
    private final DigitalSwitch carousel_CFC_Switch = new DigitalSwitch(CFC, CFCB); //Carousel_CFC
    private final DigitalSwitch carousel_CS_Switch = new DigitalSwitch(CS, CSB); //Carousel_CS
    private final DigitalSwitch carousel_CF0_Switch = new DigitalSwitch(CF0, CF0B); //Carousel_CF0
    private final DigitalSwitch carousel_CF1_Switch = new DigitalSwitch(CF1, CF1B); //Carousel_CF1

    //LoaderPresence and lockOut
    private final JPanel lockOutPanel = new JPanel();
    private final DigitalSwitch loaderPresenceSwitch = new DigitalSwitch(ALM, ALMB);
    private final DigitalSwitch noLockoutSwitch = new DigitalSwitch(LOCKB, LOCK);
    private final DigitalSwitch engineeringSwitch = new DigitalSwitch(ENG, ENGB);

    //Local Protection Module
    private final JPanel lpmStatusPanel = new JPanel();
    private final DiamondSwitch enableRailLinMasterSwitch = new DiamondSwitch(RELAYRAIL1);
    private final DiamondSwitch enableRailLinFollowerSwitch = new DiamondSwitch(RELAYRAIL2);
    private final DiamondSwitch enableClampsSwitch = new DiamondSwitch(RELAYCLAMPS);
    private final DiamondSwitch enableLatchesSwitch = new DiamondSwitch(RELAYLATCHES);

    private final JPanel latchesStatePanel = new JPanel();
    private final JPanel clampsStatePanel = new JPanel();
    private final FilterPanel filterPanel = new FilterPanel();
    private final JPanel inclinometersPanel = new JPanel();
    private final JPanel carouselStatusPanel = new JPanel();

    private JPanel trucksStatePanel;
    private final DigitalSwitch standbyDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch onlineDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();

    private final JPanel proximityPanel = new JPanel();
    private final JLabel proximityVoltageLabel = new JLabel();
    private final JLabel proximityDistanceLabel = new JLabel();

    private final DiamondSwitch[] diamondSwitchesGreenGray = new DiamondSwitch[]{
        enableRailLinMasterSwitch, enableRailLinFollowerSwitch, enableClampsSwitch, enableLatchesSwitch,
    };

    private final DigitalSwitch[] digitalList = new DigitalSwitch[]{
        loader_LPS_Switch, loader_LRH_Switch,
        carousel_CFC_Switch, carousel_CS_Switch, carousel_CF0_Switch, carousel_CF1_Switch,
        loaderPresenceSwitch, noLockoutSwitch, engineeringSwitch
    };


    private final JLabel standbyjLabel = new JLabel("STANDBY");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("HAND-OFF");
    private final JLabel onlinejLabel = new JLabel("ONLINE");
    private final JLabel inErrorjLabel = new JLabel("IN ERROR");
    private final JButton moveAndClampButton = new JButton("moveAndClampFilterOnline");
    private final JButton moveToApproachStandbyButton = new JButton("moveToApproachStandby");
    private final JButton unclampAndMoveFilterToHandoffButton = new JButton("unclampAndMoveFilterToHandoff");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToOnlineButton = new JButton("goToOnline");

    /* Clamps Panel*/
    private final JLabel clampsStateLabel = new JLabel();

    /* Latches Panel*/
    private final JLabel latchesStateLabel = new JLabel();
    private final JButton closeLatchesButton = new JButton("Close Latches");
    private final JButton openLatchesButton = new JButton("Open Latches");

    /* Trucks Panel*/
    private final JLabel trucksPositionLabel = new JLabel();

    /* Inclinometer Panel*/
    private final JLabel inclXminusLabel = new JLabel();
    private final JLabel inclXplusLabel = new JLabel();
    private final DecimalFormat formatter = new DecimalFormat("00.00");

    /* Control Panel*/
    private final JPanel clampsPanel = new JPanel();
    private final JButton closeClampsButton = new JButton("Close Clamps");
    private final JButton openClampsButton = new JButton("Open Clamps");


    /**
     * To update this panel from a map of sensors : name, value.
     */
    private class UpdateFromSensorList implements Runnable {

        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            for (DiamondSwitch ds : diamondSwitchesGreenGray) {
                ds.updateColorGreenGray(sensorMap);
            }

            for (DigitalSwitch ds: digitalList) {
                ds.updateColorComplementary(sensorMap);
            }

            if (sensorMap.containsKey(INCLINOMETERXMINUS)) {
                inclXminusLabel.setText(formatter.format((double) sensorMap.get(INCLINOMETERXMINUS)));
            }
            if (sensorMap.containsKey(INCLINOMETERXPLUS)) {
                inclXplusLabel.setText(formatter.format((double) sensorMap.get(INCLINOMETERXPLUS)));
            }
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger trucks.
     */
    private class UpdateTwoTrucks implements Runnable {

        private StatusDataPublishedByAutochangerTwoTrucks s;

        public UpdateTwoTrucks(StatusDataPublishedByAutochangerTwoTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            trucksPositionLabel.setText(String.valueOf(s.getDriverPosition()));
            handoffDigitalSwitch.setColor(s.isAtHandoff() ? greenColor : Color.gray);

            onlineDigitalSwitch.setColor(s.isAtOnline() ? greenColor : Color.gray);

            standbyDigitalSwitch.setColor(s.isAtStandby() ? greenColor : Color.gray);

            //ERROR Digital Switch is red as soon as there is an error
            //on the carrier position sensors.
            inErrorDigitalSwitch.setColor(s.isInError() ? Color.RED : greenColor);
            inErrorjLabel.setText(s.isInError() ? "IN ERROR" : "NO ERROR");

            inTravelDigitalSwitch.setColor((!s.isAtHandoff()
                    && !s.isAtOnline() && !s.isAtStandby()) ? Color.YELLOW : Color.gray);
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger latches.
     */
    class UpdateLatches implements Runnable {

        private StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            latchesStateLabel.setText(s.getLockStatus().toString());
            latchesStateLabel.setForeground(s.getLockStatus().getColor());
            filterPanel.setIsFilterInHouse(
                s.getFilterPresenceStatus().equals(FcsEnumerations.FilterPresenceStatus.ENGAGED),
                s.getFilterName(), s.getFilterId()
            );
            if (s.getFilterPresenceStatus().equals(FcsEnumerations.FilterPresenceStatus.UNKNOWN)) {
                filterPanel.setColor(Color.YELLOW);
            }
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger ONLINE clamps.
     */
    class UpdateClamps implements Runnable {

        private StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            clampsStateLabel.setText(s.getLockStatus().toString());
            clampsStateLabel.setForeground(s.getLockStatus().getColor());
        }
    }

    /**
     * A Runnable to initialize this Panel from status data published on the STATUS bus
     * by autochanger trucks.
     */
    private class UpdateProximityProbe implements Runnable {

        private StatusDataPublishedByOnlineProximityProbe s;

        public UpdateProximityProbe(StatusDataPublishedByOnlineProximityProbe status) {
            this.s = status;
        }

        @Override
        public void run() {
            proximityVoltageLabel.setText(formatter.format((double) s.getProximityVoltage()));
            proximityDistanceLabel.setText(Integer.toString(s.getProximityDistance()));
        }
    }



    public AutochangerGeneralViewPanel() {
        initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    void initializeGui(ConfigurationInfo configInfo) {
    }

    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    void updateTwoTrucks(StatusDataPublishedByAutochangerTwoTrucks s) {
        SwingUtilities.invokeLater(new UpdateTwoTrucks(s));
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateClamps(s));
    }

    void updateProximityProbe(StatusDataPublishedByOnlineProximityProbe s) {
        SwingUtilities.invokeLater(new UpdateProximityProbe(s));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {

        /**
         ******************************************************************************
         ** Buttons initialization
         * *****************************************************************************
         */

        closeClampsButton.addActionListener((ActionEvent evt) -> {
            closeButtonActionPerformed(evt);
        });

        openClampsButton.addActionListener((ActionEvent evt) -> {
            openClampsButtonActionPerformed(evt);
        });

        closeLatchesButton.addActionListener((ActionEvent evt) -> {
            closeLatchesButtonActionPerformed(evt);
        });


        openLatchesButton.addActionListener((ActionEvent evt) -> {
            openLatchesButtonActionPerformed(evt);
        });

        goToHandoffButton.addActionListener(this::goToHandoffActionPerformed);

        goToOnlineButton.addActionListener(this::goToOnlineActionPerformed);

        moveToApproachStandbyButton.addActionListener(this::moveToApproachStandbyActionPerformed);

        moveAndClampButton.addActionListener(this::moveAndClampFilterOnlineActionPerformed);

        unclampAndMoveFilterToHandoffButton.addActionListener(this::unclampAndMoveFilterToHandoffActionPerformed);

        /**
         ******************************************************************************
         ** end of Buttons initialization
         * *****************************************************************************
         */

        //LoaderStatusPanel
        loaderStatusPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, WIDTH + 5));
        loaderStatusPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.WEST;
        gbc0.insets = insets_std;
        loaderStatusPanel.add(new JLabel("Loader_LPS (loader at Storage)"), gbc0);
        gbc0.gridy++;
        loaderStatusPanel.add(new JLabel("Loader_LRH (loader holds filter)"), gbc0);
        gbc0.gridy = 0;
        gbc0.gridx = 1;
        gbc0.anchor = GridBagConstraints.EAST;
        loaderStatusPanel.add(loader_LPS_Switch, gbc0);
        gbc0.gridy++;
        loaderStatusPanel.add(loader_LRH_Switch, gbc0);

        //LockOut Panel
        lockOutPanel.setBorder(BorderFactory.createLineBorder(Color.YELLOW, WIDTH + 5));
        lockOutPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.insets = insets_std;
        gbc0.anchor = GridBagConstraints.WEST;
        lockOutPanel.add(new JLabel("Loader Presence"), gbc0);
        gbc0.gridy++;
        lockOutPanel.add(new JLabel("NOT Lock Out Bay L"), gbc0);
        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.EAST;
        lockOutPanel.add(loaderPresenceSwitch, gbc0);
        gbc0.gridy++;
        lockOutPanel.add(noLockoutSwitch, gbc0);

        //CarouselHoldingFilterPanel
        carouselStatusPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA,WIDTH + 5));
        carouselStatusPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.insets = insets_std;
        gbc0.anchor = GridBagConstraints.WEST;
        carouselStatusPanel.add(new JLabel("Carousel_CFC (filter clamped)"), gbc0);
        gbc0.gridy++;
        carouselStatusPanel.add(new JLabel("Carousel_CS (socket stop at Standby)"), gbc0);
        gbc0.gridy++;
        carouselStatusPanel.add(new JLabel("Carousel_CF0 (no filter)"), gbc0);
        gbc0.gridy++;
        carouselStatusPanel.add(new JLabel("Carousel_CF1 (filter on socket)"), gbc0);

        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.EAST;
        carouselStatusPanel.add(carousel_CFC_Switch, gbc0); //CFC
        gbc0.gridy++;
        carouselStatusPanel.add(carousel_CS_Switch, gbc0);
        gbc0.gridy++;
        carouselStatusPanel.add(carousel_CF0_Switch, gbc0);
        gbc0.gridy++;
        carouselStatusPanel.add(carousel_CF1_Switch, gbc0);

        //Local Protection Module Panel
        Border border = BorderFactory.createLineBorder(Color.BLUE,WIDTH + 5);
        lpmStatusPanel.setBorder(BorderFactory.createTitledBorder(border, "Local Protection Module"));
        lpmStatusPanel.setLayout(new GridBagLayout());
        gbc0 = new GridBagConstraints();
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.insets = insets_big;
        gbc0.anchor = GridBagConstraints.WEST;
        lpmStatusPanel.add(new JLabel("Enable Rail Linear1"), gbc0);
        gbc0.gridy++;
        lpmStatusPanel.add(new JLabel("Enable Rail Linear2"), gbc0);


        gbc0.gridx = 1;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.EAST;
        lpmStatusPanel.add(enableRailLinMasterSwitch, gbc0);
        gbc0.gridy++;
        lpmStatusPanel.add(enableRailLinFollowerSwitch, gbc0);


        gbc0.gridx = 2;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.WEST;
        lpmStatusPanel.add(new JLabel("Enable Clamps"), gbc0);
        gbc0.gridy++;
        lpmStatusPanel.add(new JLabel("Enable Latches"), gbc0);

        gbc0.gridx = 3;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.EAST;
        lpmStatusPanel.add(enableClampsSwitch, gbc0);
        gbc0.gridy++;
        lpmStatusPanel.add(enableLatchesSwitch, gbc0);

        gbc0.gridy++;
        gbc0.gridx = 0;
        lpmStatusPanel.add(new JLabel("Engineering Key"), gbc0);
        gbc0.gridx++;
        lpmStatusPanel.add(engineeringSwitch, gbc0);

        //latches state Panel
        latchesStatePanel.setBorder(BorderFactory.createTitledBorder("Latches"));
        latchesStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = GridBagConstraints.HORIZONTAL;
        latchesStatePanel.add(latchesStateLabel, gbc1);
        gbc1.gridy++;
        latchesStatePanel.add(closeLatchesButton, gbc1);
        gbc1.gridy++;
        latchesStatePanel.add(openLatchesButton, gbc1);

        //inclinometers Panel
        inclinometersPanel.setLayout(new GridBagLayout());
        inclinometersPanel.setBorder(BorderFactory.createTitledBorder("Inclinometers"));
        gbc0 = new GridBagConstraints();
        gbc0.insets = insets_small;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.WEST;
        inclinometersPanel.add(new JLabel("InclinometerXminus"), gbc0);
        gbc0.gridy++;
        gbc0.insets = insets_small;
        inclinometersPanel.add(this.inclXminusLabel, gbc0);
        gbc0.gridy = 0;
        gbc0.gridx++;
        gbc0.insets = new Insets(1,48,1,1);
        gbc0.anchor = GridBagConstraints.EAST;
        inclinometersPanel.add(new JLabel("InclinometerXplus"), gbc0);
        gbc0.gridy++;
        inclinometersPanel.add(this.inclXplusLabel, gbc0);

        //proximitySensorPanel
        proximityPanel.setLayout(new GridBagLayout());
        proximityPanel.setBorder(BorderFactory.createTitledBorder("ProximitySensorDevice"));
        gbc0 = new GridBagConstraints();
        gbc0.insets = insets_small;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.LINE_START;
//        gbc0.gridwidth = 2;
//        proximityPanel.add(new JLabel("<HTML><b>Values below make sense only when trucks are at ONLINE with a filter</HTML>"), gbc0);
//        gbc0.gridwidth = 1;
//        gbc0.gridy++;
        proximityPanel.add(new JLabel("Voltage read on device (V): "), gbc0);
        gbc0.gridy++;
        proximityPanel.add(new JLabel("Distance (micron): "), gbc0);
        //second column
        gbc0.gridx++;
        gbc0.gridy = 0;
        gbc0.anchor = GridBagConstraints.LINE_END;
        proximityPanel.add(proximityVoltageLabel, gbc0);
        gbc0.gridy++;
        proximityPanel.add(proximityDistanceLabel, gbc0);

        //filter panel
        filterPanel.setSize(120);

        //trucks Panel
        trucksStatePanel = new JPanel();
        trucksStatePanel.setBorder(BorderFactory.createTitledBorder("Trucks State"));
        trucksStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_big;

        gbc2.gridx = 0;
        gbc2.gridy = 0;
        trucksStatePanel.add(new JLabel("Trucks position:"), gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(trucksPositionLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(inErrorDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(inErrorjLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(inTravelDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(inTraveljLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(standbyDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(standbyjLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(handoffDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(handoffjLabel, gbc2);

        gbc2.gridx++;
        gbc2.gridy = 0;
        trucksStatePanel.add(onlineDigitalSwitch, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(onlinejLabel, gbc2);

        gbc2.gridx = 1;
        gbc2.insets = insets_small;
        gbc2.gridwidth = 5;
        gbc2.fill = GridBagConstraints.HORIZONTAL;
        gbc2.gridy++;
        trucksStatePanel.add(moveAndClampButton, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(goToOnlineButton, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(goToHandoffButton, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(moveToApproachStandbyButton, gbc2);
        gbc2.gridy++;
        trucksStatePanel.add(unclampAndMoveFilterToHandoffButton, gbc2);
        //clamps state Panel
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        clampsStatePanel.add(new JLabel("LockStatus:"), gbc3);
        gbc3.gridx++;
        clampsStatePanel.add(clampsStateLabel, gbc3);

        /**
         ******************************************************************************
         ** Clamps Panel
         * *****************************************************************************
         */
        clampsPanel.setLayout(new GridBagLayout());
        clampsPanel.setBorder(BorderFactory.createTitledBorder("ONLINE clamps"));
        gbc3 = new GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_small;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        clampsPanel.add(clampsStatePanel, gbc3);
        gbc3.gridy++;
        clampsPanel.add(closeClampsButton, gbc3);
        gbc3.gridy++;
        clampsPanel.add(openClampsButton, gbc3);
        /**
         ******************************************************************************
         ** End of Control Panel
         * *****************************************************************************
         */

        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();
        setBorder(Tools.getGeneralPanelTitle("Autochanger Overview"));
        setLayout(new GridBagLayout());
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(new JLabel("<HTML><b>Signals displayed on this panel are read <BR>on acSensorsGateway (Autochanger PLC)</BR></b></HTML>"));
        gbc.gridy++;
        add(carouselStatusPanel, gbc);
        gbc.gridx++;
        gbc.gridwidth = 2;
        gbc.anchor = GridBagConstraints.EAST;
        add(loaderStatusPanel, gbc);

        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 4;
        add(lpmStatusPanel, gbc);
        gbc.gridx++;
        gbc.gridwidth = 2;
        gbc.anchor = GridBagConstraints.CENTER;
        add(lockOutPanel, gbc);


        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        add(inclinometersPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 1;

        add(latchesStatePanel, gbc);
        gbc.gridx++;
        add(filterPanel, gbc);
        gbc.gridx++;
        add(clampsPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 4;
        add(proximityPanel, gbc);
        gbc.gridwidth = 1;

        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.anchor = GridBagConstraints.BASELINE_LEADING;
        add(trucksStatePanel, gbc);
        setDefaultValues();
    }

    /**
     * set default values for components color and labels.
     */
    private void setDefaultValues() {
        //Inclinometers Panel
        inclXminusLabel.setText(ZERO_VALUE);
        inclXplusLabel.setText(ZERO_VALUE);
        //Proximity Panel
        proximityVoltageLabel.setText(ZERO_VALUE);
        proximityDistanceLabel.setText(ZERO_VALUE);
        //LoaderConnectedPanel
        loader_LPS_Switch.setColor(Color.GRAY);
        loader_LRH_Switch.setColor(Color.GRAY);
        carousel_CFC_Switch.setColor(Color.GRAY);//CFC
        carousel_CS_Switch.setColor(Color.GRAY);
        carousel_CF0_Switch.setColor(Color.GRAY);
        carousel_CF1_Switch.setColor(Color.GRAY);
        //LPM status Panel
        enableRailLinMasterSwitch.setColor(Color.GRAY);
        enableRailLinFollowerSwitch.setColor(Color.GRAY);
        enableClampsSwitch.setColor(Color.GRAY);
        enableLatchesSwitch.setColor(Color.GRAY);
        engineeringSwitch.setColor(Color.GRAY);
        //lockOut and loaderPresence sensors
        loaderPresenceSwitch.setColor(Color.GRAY);
        noLockoutSwitch.setColor(Color.GRAY);

        //filter panel
        filterPanel.setIsFilterInHouse(false, "NONE", 0);
        filterPanel.setColor(Color.gray);
         //trucks Panel
        standbyDigitalSwitch.setColor(Color.gray);
        inTravelDigitalSwitch.setColor(Color.gray);
        handoffDigitalSwitch.setColor(Color.gray);
        onlineDigitalSwitch.setColor(Color.gray);
        inErrorDigitalSwitch.setColor(Color.gray);
        trucksPositionLabel.setText(ZERO_VALUE);

        clampsStateLabel.setText(UNKNOWN_STATE);
        latchesStateLabel.setText(UNKNOWN_STATE);

    }

    /**
     * Reset Panels to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        return "Overview";
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        subs.closeOnlineClamps();
    }

    private void openClampsButtonActionPerformed(ActionEvent evt) {
        subs.openOnlineClamps();
    }

    private void closeLatchesButtonActionPerformed(ActionEvent evt) {
        subs.closeLatches();
    }


    private void openLatchesButtonActionPerformed(ActionEvent evt) {
        subs.openLatches();
    }

    private void goToHandoffActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acGoToHandOff();
    }

    private void goToOnlineActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acGoToOnline();
    }

    private void moveToApproachStandbyActionPerformed(java.awt.event.ActionEvent evt) {
        subs.acMoveToApproachStandby();
    }

    private void moveAndClampFilterOnlineActionPerformed(ActionEvent evt) {
        subs.acMoveAndClampFilterOnline();
    }

    private void unclampAndMoveFilterToHandoffActionPerformed(ActionEvent evt) {
        subs.acUnclampAndMoveFilterToHandoff();
    }

    public static void main(String[] argv) {

        AutochangerGeneralViewPanel d = new AutochangerGeneralViewPanel();
        JFrame frame = new JFrame("Autochanger GeneralView Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

}
