/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FixedSizePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalTextComponent;

public class AutochangerStatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final DigitalSwitch ap1Switch = new DigitalSwitch("OUT_AP1", "OUT_AP1_C");
    private final DigitalSwitch ap2Switch = new DigitalSwitch("OUT_AP2", "OUT_AP2_C");
    private final DigitalSwitch ap3Switch = new DigitalSwitch("OUT_AP3", "OUT_AP3_C");
    private final DigitalSwitch af0Switch = new DigitalSwitch("OUT_AF0", "OUT_AF0_C");
    private final DigitalSwitch af1Switch = new DigitalSwitch("OUT_AF1", "OUT_AF1_C");
    private final DigitalSwitch af3Switch = new DigitalSwitch("OUT_AF3", "OUT_AF3_C");
    private final DigitalSwitch[] digitalList = new DigitalSwitch[]{this.ap1Switch, this.ap2Switch, this.ap3Switch, this.af0Switch, this.af1Switch, this.af3Switch};

    public AutochangerStatusPanel() {
        this.initComponents();
    }

    public void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    private void initComponents() {
        JPanel statusPane = new JPanel();
        statusPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(VerticalTextComponent.getSubsystemColor("Autochanger"), 2), "PlutoGateway"));
        statusPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = Tools.insets_std;
        statusPane.add((Component)new JLabel("AP1 (at standby)"), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new JLabel("AP2 (at handoff)"), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new JLabel("AP3 (at online)"), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new JLabel("AF0 (latches opened)"), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new JLabel("AF1 (filter detected)"), gbc);
        ++gbc.gridy;
        statusPane.add((Component)new FixedSizePanel((Component)new JLabel("AF3 (filter locked)"), Tools.getPlaceHolder("autochanger"), false), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        statusPane.add((Component)this.ap1Switch, gbc);
        ++gbc.gridy;
        statusPane.add((Component)this.ap2Switch, gbc);
        ++gbc.gridy;
        statusPane.add((Component)this.ap3Switch, gbc);
        ++gbc.gridy;
        statusPane.add((Component)this.af0Switch, gbc);
        ++gbc.gridy;
        statusPane.add((Component)this.af1Switch, gbc);
        ++gbc.gridy;
        statusPane.add((Component)this.af3Switch, gbc);
        JPanel acStatusPane = new JPanel();
        acStatusPane.setLayout(new BoxLayout(acStatusPane, 0));
        acStatusPane.add(new VerticalTextComponent("Autochanger"));
        acStatusPane.add(statusPane);
        this.setLayout(new CardLayout());
        this.add(acStatusPane);
        this.add(Tools.getPanelPlaceHolder("autochanger_pane"));
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
        for (DigitalSwitch ds : this.digitalList) {
            ds.setColor(Color.gray);
        }
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "Autochanger Protection Status";
    }

    public static void main(String[] args) {
        AutochangerStatusPanel d = new AutochangerStatusPanel();
        JFrame frame = new JFrame("AutochangerProtectionStatusPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateFromSensorList
    implements Runnable {
        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            for (DigitalSwitch ds : AutochangerStatusPanel.this.digitalList) {
                ds.updateColorComplementary(this.sensorMap);
            }
        }
    }
}

