/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.IAnnotation;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.test.AidaTestCase;
import junit.framework.Assert;

public class TestAnnotation
extends AidaTestCase {
    private int numberOfItems = 4;
    private String[] keys = new String[]{"key0", "key1", "key2", "key3"};
    private String[] keys4 = new String[]{"KEY0", "KEY1", "KEY2", "KEY3"};
    private String[] keys5 = new String[]{"Key0", "kEy1", "keY2", "KeY3"};
    private String[] vals = new String[]{"val0", "val1", "val2", "val3"};
    private boolean[] sticky = new boolean[]{true, true, false, false};

    public TestAnnotation(String testName) {
        super(testName);
    }

    public void testAnnotation() {
        int i;
        IAnalysisFactory af = IAnalysisFactory.create();
        IHistogramFactory histogramFactory = null;
        histogramFactory = af.createHistogramFactory(af.createTreeFactory().create());
        IHistogram1D h1 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IHistogram1D h2 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IHistogram1D h3 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IHistogram1D h4 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IHistogram1D h5 = histogramFactory.createHistogram1D("hist", 10, -1.0, 1.0);
        IAnnotation an1 = h1.annotation();
        IAnnotation an2 = h2.annotation();
        IAnnotation an3 = h3.annotation();
        IAnnotation an4 = h4.annotation();
        IAnnotation an5 = h5.annotation();
        int numberOfDefaultKeys = an1.size();
        Assert.assertTrue((numberOfDefaultKeys >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((an1.value("Title") != null ? 1 : 0) != 0);
        String[] defaultKeys = new String[numberOfDefaultKeys];
        for (i = 0; i < this.numberOfItems; ++i) {
            an1.addItem(this.keys[i], this.vals[i], this.sticky[i]);
            an4.addItem(this.keys4[i], this.vals[i], this.sticky[i]);
            an5.addItem(this.keys5[i], this.vals[i], this.sticky[i]);
            if (!this.sticky[i]) {
                an2.addItem(this.keys[i], this.vals[i]);
                an3.addItem(this.keys[i], this.vals[i]);
                continue;
            }
            an2.addItem(this.keys[i], this.vals[i], this.sticky[i]);
        }
        Assert.assertEquals((int)an1.size(), (int)(this.numberOfItems + numberOfDefaultKeys));
        for (i = 0; i < this.numberOfItems; ++i) {
            Assert.assertEquals((String)an1.key(i + numberOfDefaultKeys), (String)this.keys[i]);
            Assert.assertEquals((String)an1.value(i + numberOfDefaultKeys), (String)this.vals[i]);
            Assert.assertEquals((String)an1.value(i + numberOfDefaultKeys), (String)an1.value(this.keys[i]));
        }
        for (i = 0; i < this.numberOfItems; ++i) {
            Assert.assertEquals((String)an4.value(i + numberOfDefaultKeys), (String)this.vals[i]);
            Assert.assertEquals((String)an4.value(i + numberOfDefaultKeys), (String)an4.value(this.keys[i]));
            Assert.assertEquals((String)an5.value(i + numberOfDefaultKeys), (String)this.vals[i]);
            Assert.assertEquals((String)an5.value(i + numberOfDefaultKeys), (String)an5.value(this.keys[i]));
        }
        an3.reset();
        for (i = 0; i < this.numberOfItems; ++i) {
            an3.addItem(this.keys[i], this.vals[i], this.sticky[i]);
        }
        AidaTestCase.assertEquals(an1, an2);
        AidaTestCase.assertEquals(an1, an3);
    }
}

