package org.lsst.ccs.subsystems.fcs.loader.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;

import javax.swing.*;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.LOADER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;

/**
 *
 * @author F. Virieux
 */
public class LoaderGUI extends GeneralGUI implements InterfaceLoaderGUI {
    private static final long serialVersionUID = 5516615814565445162L;

    //actions timeout
    protected long updateCarrierPositionTimeout;
    protected long openHooksTimeout;
    protected long closeHooksTimeout;
    protected long clampHooksTimeout;
    protected long homingHooksTimeout;
    protected long goToHandoffTimeout;
    protected long goToEngagedTimeout;
    protected long goToStorageTimeout;
    protected long quickStopTimeout;

    /**
     *
     * @param name
     * @param role
     * @param agentMessagingLayer
     */
    public LoaderGUI(String name, String role, AgentMessagingLayer agentMessagingLayer) {
        super(name, role, agentMessagingLayer);
        LoaderGatherPanel loaderGatherPanel = new LoaderGatherPanel(this, LOADER_TCPPROXY_NAME);
        LoaderBottomPanel loaderBottomPanel = new LoaderBottomPanel(loaderGatherPanel, "LOADER");
        this.generalPanel = new GeneralPanel(this,loaderBottomPanel);
        pane = new JScrollPane(generalPanel);
        /* Initialization of loader timeout */
        openHooksTimeout = 0;
        closeHooksTimeout = 0;
        clampHooksTimeout = 0;
        homingHooksTimeout = 0;
        goToHandoffTimeout = 0;
        goToStorageTimeout = 0;
        abortTimeout = 1000;
        quickStopTimeout = 1000;
        updateStateWithSensorsTimeout = 1000;
        updateCarrierPositionTimeout = 1000;
    }

    @Override
    public void setLoGoToHandoffTimeout(int aInt) {
        this.goToHandoffTimeout = aInt;
    }

    @Override
    public void setLoGoToStorageTimeout(int aInt) {
        this.goToStorageTimeout = aInt;
    }

    @Override
    public void setLoGoToEngagedTimeout(int goToEngagedTimeout) {
        this.goToEngagedTimeout = goToEngagedTimeout;
    }

    @Override
    public void setOpenHooksTimeout(long openHooksTimeout) {
        this.openHooksTimeout = openHooksTimeout;
    }

    @Override
    public void setCloseHooksTimeout(long closeHooksTimeout) {
        this.closeHooksTimeout = closeHooksTimeout;
    }

    @Override
    public void setClampHooksTimeout(long clampHooksTimeout) {
        this.clampHooksTimeout = clampHooksTimeout;
    }

    @Override
    public long getLoGoToHandoffTimeout() {
        return goToHandoffTimeout;
    }

    @Override
    public long getLoGoToStorageTimeout() {
        return goToStorageTimeout;
    }

    @Override
    public long getLoGoToEngagedTimeout() {
        return goToEngagedTimeout;
    }

    @Override
    public long getOpenHooksTimeout() {
        return openHooksTimeout;
    }

    @Override
    public long getCloseHooksTimeout() {
        return closeHooksTimeout;
    }

    @Override
    public long getClampHooksTimeout() {
        return clampHooksTimeout;
    }


    @Override
    public JComponent getGuiLayout() {
        return pane;
    }

    @Override
    public String getName() {
        return "LoaderGUIModule";
    }

    /**
     * Standalone case /
     *
     **
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Agent agent = new Agent("LoaderGUIModule", AgentInfo.AgentType.CONSOLE);
        LoaderGUI t = new LoaderGUI(agent.getName(), "loader-standalone", agent.getMessagingAccess());
        agent.startAgent();
        t.initGui();

        JFrame frame = new JFrame("Loader View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }


}
