/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.awt.Color;
import java.io.Serializable;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.services.DataProviderDictionaryService;

public class FcsEnumerations {
    public static final Color greenColor = new Color(0, 165, 0);
    public static final Color darkGreen = new Color(0, 100, 0);
    public static final Color chocolate = new Color(210, 105, 30);
    public static final Color royalblue = new Color(65, 105, 225);
    public static final Color lightblue = new Color(173, 216, 230);
    public static final Color magenta2 = new Color(238, 0, 238);
    public static final Color orange1 = new Color(255, 165, 0);
    public static final String FCS_NAME_FOR_MCM = "FILTER";
    public static final String AC_PLUTOGATEWAY_NAME = "acSensorsGateway";

    @Deprecated
    public static enum TelescopeMountRotatorState {
        LOCKED,
        UNLOCKED,
        UNKNOWN,
        PROTOTYPE;

    }

    public static enum FcsAlert {
        UNSYNC_BOOT("A boot message has been received for a device."),
        EMCY("Received an EMERGENCY message from a device."),
        IN_FAULT("Controller in fault."),
        CAN_BUS_TIMEOUT("Timeout expired while waiting to response from CANbus"),
        CAN_BUS_READING_ERROR("Error in reading on CANbus"),
        CAN_BUS_NOT_INITIALIZED("Could not init canInterface. POWER FAILURE ? Is Clean 24V up ? Check power, reboot pc104 and then restart fcs."),
        HARDWARE_MISSING("HARDWARE NOT DETECTED - POWER FAILURE ?"),
        HARDWARE_ERROR("HARDWARE ERROR"),
        CA_LOCKING_ISSUE("CAROUSEL LOCKING ISSUE"),
        CA_LOCKING_RECOVERY_SUCCESS("CAROUSEL LOCKING RECOVERY SUCCESSFUL"),
        CA_LOCKING_RECOVERY_FAILURE("CAROUSEL LOCKING RECOVERY FAILED"),
        CA_UNLOCKING_RECOVERY_SUCCESS("CAROUSEL UNLOCKING RECOVERY SUCCESSFUL"),
        CA_UNLOCKING_RECOVERY_FAILURE("CAROUSEL UNLOCKING RECOVERY FAILED"),
        CA_ROTATION_RECOVERY("CAROUSEL ROTATION RECOVERY NEEDED"),
        CA_ROTATION_RECOVERY_SUCCESS("CAROUSEL ROTATION RECOVERY SUCCESSFUL"),
        CA_ROTATION_RECOVERY_FAILURE("CAROUSEL ROTATION RECOVERY FAILED"),
        AC_ONLINE_CLAMPS_CLOSED_AT_STARTUP("Autochanger Online Clamps CLOSED at startup"),
        AC_ONLINE_CLAMPS_STAY_ENABLED("Autochanger Online Clamps are still ENABLED after locking"),
        BAD_SERIAL_NB("Serial number read in CPU different from serial number in configuration"),
        PARAMETER_ERROR("ERROR in CPU controller for a parameter"),
        SDO_ERROR("Error in a request to a CANopen device"),
        AC_SENSOR_ERROR("Autochanger sensors are in error"),
        CA_SENSOR_ERROR("Carousel sensors are in error"),
        LO_SENSOR_ERROR("Loader sensors are in error"),
        AC_TRUCKS_ERROR("Autochanger trucks ERROR"),
        UPDATE_ERROR("ERROR in updateStateWithSensors");

        private final String longDescription;

        private FcsAlert(String longDescription) {
            this.longDescription = longDescription;
        }

        public String getLongDescription() {
            return this.longDescription;
        }

        public Alert getAlert() {
            return this.getAlert(null);
        }

        public Alert getAlert(String prefix) {
            Object alertId = this.name();
            if (prefix != null && !prefix.isEmpty()) {
                alertId = prefix + "/" + (String)alertId;
            }
            return new Alert((String)alertId, this.getLongDescription());
        }
    }

    public static enum HoldingBrakesState {
        TRUE,
        FALSE;

    }

    public static enum CarouselPowerMode {
        GO_TO_SLEEP,
        WAKE_UP,
        STAY_UP;

    }

    @Deprecated
    public static enum CarouselPowerState {
        LOW_POWER,
        REGULAR;

    }

    @Deprecated
    public static enum FilterReadinessState {
        NOT_READY,
        READY;

    }

    @Deprecated
    public static enum AutochangerTrucksState {
        STANDBY,
        HANDOFF,
        ONLINE,
        IN_TRAVEL;

    }

    @Deprecated
    public static enum AutochangerInclinationState {
        STRAIGHT,
        TILTED;

    }

    @Deprecated
    public static enum McmFilterState {
        UNLOADING,
        LOADING,
        ROTATING,
        UNLOADED,
        LOADED,
        NOFILTER,
        UNKNOWN;

    }

    @Deprecated
    public static enum FilterState {
        MOVING_TRUCKS_TO_STANDBY,
        MOVING_TRUCKS_TO_ONLINE,
        MOVING_TRUCKS_TO_HANDOFF,
        TRUCKS_STOPPED,
        MOVING_TRUCKS,
        ROTATING,
        CAROUSEL_STOPPED,
        WAITING_FOR_HARDWARE_BOOTING,
        CAN_DEVICES_BOOTING,
        READY,
        OFF_LINE,
        ONLINE_NONE,
        ONLINE_U,
        ONLINE_G,
        ONLINE_R,
        ONLINE_I,
        ONLINE_Z,
        ONLINE_Y,
        ONLINE_PH,
        ONLINE_EF,
        ONLINE_A,
        ONLINE_DU1,
        ONLINE_DU2,
        ONLINE_DR1,
        ONLINE_DZ1,
        ONLINE_DZ2,
        ONLINE_DA1,
        ONLINE_DA2,
        ONLINE_TU,
        ONLINE_TY,
        ONLINE_OA,
        ONLINE_OB,
        ONLINE_OC,
        ONLINE_F15,
        ONLINE_F17,
        ONLINE_F29,
        ONLINE_F3,
        ONLINE_F34,
        ONLINE_F46,
        ONLINE_F48,
        ONLINE_F60;

    }

    public static interface CounterPath {
        default public String name() {
            return "This is a placeholder. enum's name() function will override it.";
        }

        default public String getCounterPath() {
            return this.getCounterPath(null);
        }

        default public String getCounterPath(String subpath) {
            return this.getPath("counters", subpath);
        }

        default public String getDurationPath() {
            return this.getDurationPath(null);
        }

        default public String getDurationPath(String subpath) {
            return this.getPath("duration", subpath);
        }

        default public String getPath(String pathType, String subpath) {
            if (subpath == null) {
                return String.format("%s/%s", pathType, this.name());
            }
            return String.format("%s/%s/%s", pathType, subpath, this.name());
        }

        default public void registerDurationPerElement(DataProviderDictionaryService dpds, String subpath) {
            this.registerDuration(dpds, subpath);
        }

        default public void registerDurationTopLevel(DataProviderDictionaryService dpds) {
            this.registerDuration(dpds, null);
        }

        default public void registerDuration(DataProviderDictionaryService dpds, String subpath) {
            String path = this.getDurationPath(subpath);
            dpds.registerData(new KeyValueData(path, (Serializable)Long.valueOf(0L)));
            DataProviderInfo info = dpds.getDataProviderDictionary().getDataProviderInfoForPath(path);
            info.addAttribute(DataProviderInfo.Attribute.UNITS, "millisecond");
            info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, "Duration of the action " + this.name());
            info.addAttribute(DataProviderInfo.Attribute.TYPE, "long");
        }

        default public void publishDurationPerElement(Subsystem subs, long duration, String subpath) {
            this.publishDuration(subs, duration, subpath);
        }

        default public void publishDurationTopLevel(Subsystem subs, long duration) {
            this.publishDuration(subs, duration, null);
        }

        default public void publishDuration(Subsystem subs, long duration, String subpath) {
            subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.getDurationPath(subpath), (Serializable)Long.valueOf(duration)));
        }
    }

    public static enum GeneralAction implements CounterPath
    {
        SET_FILTER,
        SET_FILTER_AT_HANDOFF_FOR_LOADER,
        STORE_FILTER_ON_CAROUSEL,
        SET_NO_FILTER,
        DISENGAGE_FILTER_FROM_CAROUSEL,
        LOAD_FILTER,
        UNLOAD_FILTER,
        CONNECT_LOADER,
        DISCONNECT_LOADER,
        MOVE_AND_CLAMP_FILTER_ONLINE,
        GRAB_FILTER_AT_STANDBY,
        ROTATE_SOCKET_TO_STANDBY,
        RECOVERY_ROTATION_STRAIGHT,
        RECOVERY_ROTATION_FORWARD,
        RECOVERY_ROTATION_BACKWARD,
        RECOVERY_CLAMP_XMINUS,
        RECOVERY_UNCLAMP;

    }

    public static enum MobileItemAction implements CounterPath
    {
        UNLOCK("UNLOCKING CLAMP", "IS UNLOCKED", "COULD NOT UNLOCK CLAMP"),
        RELEASE("RELEASING CLAMP", "IS RELEASED", "COULD NOT RELEASE CLAMP"),
        UNLOCK_CLAMPS("UNLOCKING CLAMPS", "CLAMPS ARE UNLOCKED", "COULD NOT UNLOCK CLAMPS"),
        RELEASE_CLAMPS("RELEASING CLAMPS", "CLAMPS ARE RELEASED", "COULD NOT RELEASE CLAMPS"),
        ROTATE_CAROUSEL_TO_RELATIVE_POSITION("ROTATING CAROUSEL", "CAROUSEL ROTATION IS COMPLETED", "COULD NOT ROTATE CAROUSEL"),
        ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION("ROTATING CAROUSEL", "CAROUSEL ROTATION IS COMPLETED", "COULD NOT ROTATE CAROUSEL"),
        OPEN("OPENING LATCH", "IS OPENED", "COULD NOT OPEN LATCH"),
        CLOSE("CLOSING LATCH", "IS CLOSED", "COULD NOT CLOSE LATCH"),
        CLOSE_ONLINECLAMP_MODE_CURRENT("CLOSING ONLINECLAMP", "IS CLOSED", "COULD NOT CLOSE ONLINECLAMP"),
        CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION("CLOSING ONLINECLAMP", "IS CLOSED", "COULD NOT CLOSE ONLINECLAMP"),
        LOCK_ONLINECLAMP("LOCKING ONLINECLAMP", "IS LOCKED", "COULD NOT LOCK ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_CURRENT("OPENING ONLINECLAMP CURRENT MODE", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        OPEN_HOMING_ONLINECLAMP("OPEN HOMING ONLINE CLAMPS", "IS OPENED AND HOMING DONE", "COULD NOT OPEN AND DO HOMING"),
        OPEN_HALFWAY_RELATIVE_POSITION("OPEN HALFWAY RELATIVE POSITION", "IS HALFWAY BETWEEN OPEN AND CLOSE", "COULD NOT MOVE IN RELATIVE POSITION"),
        REOPEN_ONLINECLAMP_MODE_CURRENT("OPENING ONLINECLAMP CURRENT MODE", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_PROFILE_POSITION("OPENING ONLINECLAMP", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_PROFILE_NOBRAKE("OPENING ONLINE CLAMP WITHOUT BRAKE", "IS OPENED", "COULD NOT OPEN ONLINE CLAMP"),
        UNLOCK_ONLINECLAMP("UNLOCKING ONLINECLAMP", "IS UNLOCKED", "COULD NOT UNLOCK ONLINECLAMP"),
        MOVE_TO_ABSOLUTE_POSITION("MOVING TO ABSOLUTE POSITION", "ABSOLUTE POSITION REACHED", "COULD NOT MOVE TO ABSOLUTE POSITION"),
        ALIGN_FOLLOWER("ALIGNING FOLLOWER TRUCK", "FOLLOWER TRUCK ALIGNED", "COULD NOT ALIGN FOLLOWER TRUCK"),
        MOVE_DRIVER_TRUCK_ALONE("MOVING DRIVER TRUCK ALONE", "DRIVER TRUCK MOVED ALONE", "COULD NOT MOVE DRIVER TRUCK ALONE"),
        MOVE_FOLLOWER_TRUCK_ALONE("MOVING FOLLOWER TRUCK ALONE", "FOLLOWER TRUCK MOVED ALONE", "COULD NOT MOVE FOLLOWER TRUCK ALONE"),
        UNCLAMP_LOADER_HOOKS("LOADER CLAMP UNCLAMPING", "HOOKS ARE UNCLAMPED", "COULD NOT UNCLAMP"),
        OPEN_HOMING_LOADER_HOOKS("OPENING LOADER HOOKS", "LOADER HOOKS ARE OPEN", "COULD NOT OPEN LOADER HOOKS"),
        CLOSE_LOADER_HOOKS("CLOSING LOADER HOOKS", "LOADER HOOKS ARE CLOSED", "COULD NOT CLOSE LOADER HOOKS"),
        CLAMP_LOADER_HOOKS("CLAMPING LOADER HOOKS", "LOADER HOOKS ARE CLAMPED", "COULD NOT CLAMP LOADER HOOKS"),
        MOVE_LOADERCARRIER_TO_STORAGE("MOVING LOADER CARRIER TO STORAGE", "LOADER CARRIER IS AT STORAGE POSITION", "COULD NOT MOVE LOADER CARRIER TO STORAGE POSITION"),
        MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION("MOVING LOADER CARRIER TO ABSOLUTE POSITION", "LOADER CARRIER IS AT REQUIRED POSITION", "COULD NOT MOVE LOADER CARRIER TO REQUIRED POSITION"),
        MOVE_LOADERCARRIER_TO_HANDOFF("MOVING LOADER CARRIER TO HANDOFF", "LOADER CARRIER IS AT HANDOFF POSITION", "COULD NOT MOVE LOADER CARRIER TO HANDOFF POSITION"),
        MOVE_LOADERCARRIER_TO_ENGAGED("MOVING LOADER CARRIER TO ENGAGED", "LOADER CARRIER IS AT ENGAGED POSITION", "COULD NOT MOVE LOADER CARRIER TO ENGAGED POSITION");

        private final String shortDescription;
        private final String doneActionMsg;
        private final String failureMsg;

        private MobileItemAction(String aString, String aDoneString, String aFailureMsg) {
            this.shortDescription = aString;
            this.doneActionMsg = aDoneString;
            this.failureMsg = aFailureMsg;
        }

        public String toString() {
            return this.shortDescription;
        }

        public String doneString() {
            return this.doneActionMsg;
        }

        public String getFailureMsg() {
            return this.failureMsg;
        }
    }

    public static enum IOModuleStatus implements ColoredObject
    {
        UNKNOWN_STATUS(0, Color.RED),
        IS_SOCKET_AT_STANDBY(1, greenColor),
        IS_READY_NOT_IN_POSITION(2, Color.BLUE),
        ERROR_READING_POSITION(3, Color.red),
        SAFE_STATE(4, Color.RED),
        BOOTING(5, orange1),
        NOT_POWERED_ON(6, Color.RED),
        NOT_WORKING_FOR_OTHER_REASON(7, chocolate);

        @SkipEncoding
        private final int status;
        @SkipEncoding
        private final Color color;

        private IOModuleStatus(int status, Color color) {
            this.status = status;
            this.color = color;
        }

        public int getStatus() {
            return this.status;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public static IOModuleStatus getStatusByCode(int s) {
            IOModuleStatus[] codes = IOModuleStatus.values();
            IOModuleStatus status = null;
            for (IOModuleStatus ioStatus : codes) {
                if (ioStatus.getStatus() != s) continue;
                status = ioStatus;
            }
            if (status == null) {
                throw new IllegalArgumentException(s + ": this status doesn't exist in IOModuleStatus ENUM");
            }
            return status;
        }
    }

    public static enum FilterClampState implements ColoredObject
    {
        READY_TO_LOCK(Color.blue, "READY TO LOCK"),
        UNLOCKED_ON_FILTER(chocolate, "UNLOCKED ON FILTER"),
        UNLOCKED_EMPTY(royalblue, "UNLOCKED AND EMPTY"),
        LOCKED_ON_FILTER(greenColor, "LOCKED ON FILTER"),
        UNDEFINED(Color.orange, "UNDEFINED"),
        ERROR(Color.red, "IN ERROR"),
        UNLOCKABLE(magenta2, "FILTER UNLOCKABLE");

        @SkipEncoding
        private final String shortDescription;
        @SkipEncoding
        private final Color color;

        private FilterClampState(Color color, String aString) {
            this.shortDescription = aString;
            this.color = color;
        }

        public String toString() {
            return this.shortDescription;
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    public static enum LoaderCarrierLocation {
        STORAGE,
        HANDOFF,
        UNKNOWN,
        ERROR;

    }

    public static enum FilterFamily {
        S("Science Filter"),
        D("Dummy Filter"),
        F("French Dummy Filter"),
        T("Test Filter LNL"),
        O("Open / Non Attributed Filter"),
        U("Unknown Filter"),
        N("No Filter");

        @SkipEncoding
        private final String familyName;

        private FilterFamily(String familyName) {
            this.familyName = familyName;
        }

        public String getFamilyName() {
            return this.familyName;
        }
    }

    public static enum BrakeState {
        CLOSED,
        NO_BRAKE,
        NO_SENSOR;

    }

    public static enum LockStatus implements ColoredObject
    {
        UNLOCKED(Color.blue, "UNLOCKED"),
        LOCKED(greenColor, "LOCKED"),
        UNKNOWN(Color.orange, "UNKNOWN"),
        ERROR(Color.red, "IN ERROR"),
        RELAXED(lightblue, "RELAXED"),
        OPENED(Color.blue, "OPENED"),
        CLOSED(greenColor, "CLOSED"),
        CLAMPED(darkGreen, "CLAMPED"),
        UNCLAMPED(Color.blue, "UNCLAMPED"),
        UNDER_CLAMPED(Color.YELLOW, "UNDER LOAD"),
        OVER_CLAMPED(Color.RED, " OVER LOAD"),
        INTRAVEL(Color.YELLOW, "IN TRAVEL"),
        NOERROR(Color.GREEN, "NO ERROR");

        @SkipEncoding
        private final Color color;
        @SkipEncoding
        private final String text;

        private LockStatus(Color color, String text) {
            this.color = color;
            this.text = text;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public String getText() {
            return this.text;
        }
    }

    public static enum FilterPresenceStatus implements ColoredObject
    {
        NOFILTER(Color.DARK_GRAY),
        ENGAGED(chocolate),
        LOCKABLE(greenColor),
        NOT_LOCKABLE(Color.blue),
        ERROR(Color.red),
        UNKNOWN(Color.YELLOW);

        @SkipEncoding
        private final Color color;

        private FilterPresenceStatus(Color color) {
            this.color = color;
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    @FunctionalInterface
    public static interface ColoredObject {
        public Color getColor();
    }
}

