/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.web;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.HTMLComponentFactory;
import org.freehep.util.images.ImageHandler;
import org.openide.util.Lookup;

public class JasView
extends ComponentView {
    protected URL baseURL;
    protected Studio app;

    public JasView(Element elem, URL baseURL, Studio studio) {
        super(elem);
        this.baseURL = baseURL;
        this.app = studio;
    }

    @Override
    protected Component createComponent() {
        Component comp = null;
        try {
            AttributeSet attrs = this.getElement().getAttributes();
            Enumeration<?> en = attrs.getAttributeNames();
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            map.put("BASEURL", this.baseURL);
            map.put("STUDIO", this.app);
            String classID = (String)attrs.getAttribute(HTML.Attribute.CLASSID);
            String name = (String)attrs.getAttribute(HTML.Attribute.ID);
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                String stringKey = key.toString().toUpperCase();
                String value = attrs.getAttribute(key).toString();
                map.put((String)key, value);
            }
            comp = this.lookupAndCreateComponent(classID, map);
        }
        catch (Throwable t) {
            comp = this.getUnloadableRepresentation(t);
        }
        return comp;
    }

    protected Component getUnloadableRepresentation(final Throwable t) {
        JButton bomb = new JButton("Error...", ImageHandler.getIcon((String)"images/Bomb.gif", JasView.class)){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                JasView.this.app.error("Error loading object", t);
            }
        };
        bomb.setToolTipText("Click on Bomb to see error");
        return bomb;
    }

    protected Component lookupAndCreateComponent(String classID, Map map) throws Exception {
        Lookup.Template template = new Lookup.Template(HTMLComponentFactory.class, classID, null);
        Lookup.Item result = this.app.getLookup().lookupItem(template);
        if (result == null) {
            throw new IllegalArgumentException("Can not find HTMLComponentFactory for: " + classID);
        }
        HTMLComponentFactory factory = (HTMLComponentFactory)result.getInstance();
        return factory.getComponent(classID, map);
    }
}

