/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.ui.FcsCameraProtectionPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class FcsGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String NONE = "NONE";
    private final String title = "FCS OVERVIEW";
    private JPanel autochangerPanel;
    private JPanel carouselPanel;
    private JPanel loaderPanel;
    private final JLabel filterONLINELabel = new JLabel("NONE");
    private final JLabel filterOnTrucksLabel = new JLabel("NONE");
    private final JLabel onlineClampsStateLabel = new JLabel("UNKNOWN");
    private final JLabel latchesStateLabel = new JLabel("UNKNOWN");
    private final JLabel trucksPositionLabel = new JLabel("UNKNOWN");
    private final JLabel trucksPositionNameLabel = new JLabel("UNKNOWN");
    private final JLabel homingLabel = new JLabel();
    private final JLabel actualPositionLabel = new JLabel();
    private final JLabel actualSpeedLabel = new JLabel();
    private final JLabel actualCurrentLabel = new JLabel();
    private final JLabel standbyLabel = new JLabel();
    private final DigitalSwitch standbySwitch = new DigitalSwitch();
    private final JLabel socketAtStandbyLabel = new JLabel();
    private final JLabel slaveModuleStatusLabel = new JLabel();
    private final JLabel filterAtStandbyLabel = new JLabel();
    private final JLabel caClampsStateLabel = new JLabel();
    private final FcsCameraProtectionPanel cameraStatusPanel = new FcsCameraProtectionPanel();

    public FcsGeneralViewPanel() {
        this.initComponents();
    }

    void updateFromStatusData(KeyValueData data) {
        if (data.getValue() instanceof StatusDataPublishedByAutochangerThreeClamps) {
            this.updateClamps((StatusDataPublishedByAutochangerThreeClamps)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerTwoLatches) {
            this.updateLatches((StatusDataPublishedByAutochangerTwoLatches)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutoChangerTrucks) {
            this.updateTrucks((StatusDataPublishedByAutoChangerTrucks)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutoChanger) {
            this.cameraStatusPanel.updateAutochanger((StatusDataPublishedByAutoChanger)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarousel) {
            this.updateCarousel((StatusDataPublishedByCarousel)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarouselSocket) {
            this.updateCarouselSocket((StatusDataPublishedByCarouselSocket)data.getValue());
        }
    }

    void updateCarouselSocket(StatusDataPublishedByCarouselSocket s) {
        SwingUtilities.invokeLater(new UpdateCarouselSocket(s));
    }

    void updateCarousel(StatusDataPublishedByCarousel s) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " updating from carousel data:"));
        SwingUtilities.invokeLater(new UpdateCarousel(s));
        this.cameraStatusPanel.updateCarousel(s);
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        SwingUtilities.invokeLater(new UpdateTrucks(s));
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateOnlineClamps(s));
    }

    private void initComponents() {
        this.autochangerPanel = new JPanel();
        this.autochangerPanel.setBorder(BorderFactory.createTitledBorder("autochanger"));
        this.autochangerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.autochangerPanel.add((Component)new JLabel("Filter ONLINE: "), gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)new JLabel("Filter on trucks: "), gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)new JLabel("ONLINE clamps state: "), gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)new JLabel("Latches state: "), gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)new JLabel("Trucks Position: "), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.autochangerPanel.add((Component)this.filterONLINELabel, gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)this.filterOnTrucksLabel, gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)this.onlineClampsStateLabel, gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)this.latchesStateLabel, gbc1);
        ++gbc1.gridy;
        this.autochangerPanel.add((Component)this.trucksPositionNameLabel, gbc1);
        ++gbc1.gridx;
        this.autochangerPanel.add((Component)this.trucksPositionLabel, gbc1);
        this.carouselPanel = new JPanel();
        this.carouselPanel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        this.carouselPanel.setBorder(BorderFactory.createTitledBorder("carousel"));
        this.carouselPanel.setLayout(new GridBagLayout());
        gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.carouselPanel.add((Component)new JLabel("Homing: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Position: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Speed: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Current: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.standbyLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Socket at STANDBY: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Filter at STANDBY: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Slave Status: "), gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)new JLabel("Clamps Status: "), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.carouselPanel.add((Component)this.homingLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.actualPositionLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.actualSpeedLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.actualCurrentLabel, gbc1);
        ++gbc1.gridy;
        this.standbySwitch.setColor(Color.gray);
        this.carouselPanel.add((Component)this.standbySwitch, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.socketAtStandbyLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.filterAtStandbyLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.slaveModuleStatusLabel, gbc1);
        ++gbc1.gridy;
        this.carouselPanel.add((Component)this.caClampsStateLabel, gbc1);
        this.loaderPanel = new JPanel();
        this.loaderPanel.setBorder(BorderFactory.createTitledBorder("loader"));
        this.setBorder(BorderFactory.createTitledBorder("FCS OVERVIEW"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 512;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.add((Component)this.cameraStatusPanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.carouselPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.autochangerPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.loaderPanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.homingLabel.setText("NOT DONE");
        this.homingLabel.setForeground(Color.RED);
        this.actualPositionLabel.setText("0.0");
        this.actualSpeedLabel.setText("0.0");
        this.actualCurrentLabel.setText("0.0");
        this.standbyLabel.setText("NOT AT STANDBY position");
        this.standbySwitch.setColor(Color.gray);
        this.socketAtStandbyLabel.setText(NONE);
        this.filterAtStandbyLabel.setText("NO FILTER");
        this.caClampsStateLabel.setText("UNKNOWN STATE");
        this.slaveModuleStatusLabel.setText("UNKNOWN STATE");
        this.trucksPositionLabel.setText("0.0");
        this.trucksPositionNameLabel.setText("UNKNOWN STATE");
        this.onlineClampsStateLabel.setText("UNKNOWN STATE");
        this.latchesStateLabel.setText("UNKNOWN STATE");
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "FCS OVERVIEW";
    }

    public static void main(String[] args) {
        FcsGeneralViewPanel d = new FcsGeneralViewPanel();
        JFrame frame = new JFrame("FCS General View Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateOnlineClamps
    implements Runnable {
        private StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateOnlineClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.onlineClampsStateLabel.setText(this.s.getLockStatus().toString());
            FcsGeneralViewPanel.this.onlineClampsStateLabel.setForeground(this.s.getLockStatus().getColor());
        }
    }

    class UpdateLatches
    implements Runnable {
        private StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.latchesStateLabel.setText(this.s.getLockStatus().toString());
            FcsGeneralViewPanel.this.latchesStateLabel.setForeground(this.s.getLockStatus().getColor());
            if (this.s.getFilterPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.ENGAGED)) {
                FcsGeneralViewPanel.this.filterOnTrucksLabel.setText(this.s.getFilterName());
            }
        }
    }

    private class UpdateTrucks
    implements Runnable {
        private StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            FcsGeneralViewPanel.this.trucksPositionLabel.setText(String.valueOf(this.s.getMasterPosition()));
            FcsGeneralViewPanel.this.trucksPositionNameLabel.setForeground(Tools.greenColor);
            if (this.s.isAtHandoff()) {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("HANDOFF");
            } else if (this.s.isAtOnline()) {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("ONLINE");
            } else if (this.s.isAtStandby()) {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("STANDBY");
            } else {
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setText("IN_TRAVEL");
                FcsGeneralViewPanel.this.trucksPositionNameLabel.setForeground(Color.YELLOW);
            }
        }
    }

    public class UpdateCarouselSocket
    implements Runnable {
        private StatusDataPublishedByCarouselSocket s;

        public UpdateCarouselSocket(StatusDataPublishedByCarouselSocket s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isAtStandby()) {
                FcsGeneralViewPanel.this.caClampsStateLabel.setText(this.s.getClampState().toString());
                FcsGeneralViewPanel.this.caClampsStateLabel.setForeground(this.s.getClampState().getColor());
                FcsGeneralViewPanel.this.slaveModuleStatusLabel.setText(this.s.getSlaveStatus().toString());
                FcsGeneralViewPanel.this.slaveModuleStatusLabel.setForeground(this.s.getSlaveStatus().getColor());
            }
        }
    }

    public class UpdateCarousel
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public UpdateCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                FcsGeneralViewPanel.this.homingLabel.setText("DONE");
                FcsGeneralViewPanel.this.homingLabel.setForeground(Tools.greenColor);
            } else {
                FcsGeneralViewPanel.this.homingLabel.setText("TO_BE_DONE");
                FcsGeneralViewPanel.this.homingLabel.setForeground(Color.RED);
            }
            FcsGeneralViewPanel.this.actualPositionLabel.setText(Integer.toString(this.s.getPosition()));
            FcsGeneralViewPanel.this.actualSpeedLabel.setText(Double.toString(this.s.getVelocity()));
            FcsGeneralViewPanel.this.actualCurrentLabel.setText(Double.toString(this.s.getCurrent()));
            if (this.s.isAtStandby()) {
                FcsGeneralViewPanel.this.standbyLabel.setText("AT STANDBY position");
                FcsGeneralViewPanel.this.standbySwitch.setColor(Tools.greenColor);
                FcsGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                FcsGeneralViewPanel.this.socketAtStandbyLabel.setFont(Tools.BIG_FONT);
                FcsGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.getFilterAtStandbyName());
                FcsGeneralViewPanel.this.filterAtStandbyLabel.setFont(Tools.BIG_FONT);
            } else {
                FcsGeneralViewPanel.this.standbyLabel.setText("NOT AT STANDBY position");
                FcsGeneralViewPanel.this.standbySwitch.setColor(Color.orange);
                FcsGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                FcsGeneralViewPanel.this.filterAtStandbyLabel.setText(FcsGeneralViewPanel.NONE);
            }
        }
    }
}

