/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerLatchPanel
extends JPanel {
    private static final long serialVersionUID = -3564360054429278810L;
    private InterfaceAutochangerGUI subs;
    private DigitalSwitch openSensorDS;
    private DigitalSwitch closeSensorDS;
    private DigitalSwitch filterEngagedSensorDS;
    private DigitalSwitch errorDS;
    private String latchName;
    private JLabel latchNameLabel;
    private JLabel openLabel;
    private JLabel closeLabel;
    private JLabel errorLabel;
    private JLabel filterEngagedLabel;
    private JLabel lockStatus;
    private JPanel paramPanel;
    private final JLabel timeoutOpencLabel = new JLabel("timeout to open:");
    private final JLabel timeoutClosecLabel = new JLabel("timeout to close:");
    private final JLabel ctoLabel = new JLabel("current to open:");
    private final JLabel openTimeoutLabel = new JLabel();
    private final JLabel closeTimeoutLabel = new JLabel();
    private final JLabel currentToOpenLabel = new JLabel();
    private JPanel faultPanel;
    private DigitalSwitch faultSwitch;
    private JPanel controlPanel;
    private JButton abortButton;
    private JButton closeButton;
    private JButton openButton;

    public AutochangerLatchPanel(String latchName) {
        this.latchName = latchName;
        this.initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    void setLatchName(String name) {
        this.latchNameLabel.setText(name);
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateLatch(StatusDataPublishedByAutochangerLatch status) {
        SwingUtilities.invokeLater(new UpdateLatch(status));
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.subs.closeLatch(this.latchName);
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        this.subs.openLatch(this.latchName);
    }

    private void abortButtonActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    private void initComponents() {
        this.closeButton = new JButton("Close Latch");
        this.openButton = new JButton("Open Latch");
        this.abortButton = new JButton("Abort");
        this.closeButton.addActionListener(evt -> this.closeButtonActionPerformed(evt));
        this.openButton.addActionListener(evt -> this.openButtonActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortButtonActionPerformed(evt));
        this.openSensorDS = new DigitalSwitch();
        this.closeSensorDS = new DigitalSwitch();
        this.filterEngagedSensorDS = new DigitalSwitch();
        this.errorDS = new DigitalSwitch();
        this.latchNameLabel = new JLabel("myLatch");
        this.openLabel = new JLabel("<html><P align=\"center\">OPEN<br>SENSOR</p></html>");
        this.closeLabel = new JLabel("<html><P align=\"center\">CLOSE<br>SENSOR</p></html>");
        this.errorLabel = new JLabel("ERROR");
        this.filterEngagedLabel = new JLabel("<html><P align=\"center\">FILTER<br>ENGAGED</p></html>");
        this.lockStatus = new JLabel();
        this.faultPanel = new JPanel();
        this.faultSwitch = new DigitalSwitch();
        this.faultSwitch.setSize(50);
        this.faultPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
        this.faultPanel.setLayout(new GridBagLayout());
        this.faultPanel.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = Tools.insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = 10;
        this.faultPanel.add((Component)this.faultSwitch, gbcf);
        this.paramPanel = new JPanel();
        this.paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramPanel.add((Component)this.timeoutOpencLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.timeoutClosecLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.ctoLabel, gbcp);
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramPanel.add((Component)this.openTimeoutLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.closeTimeoutLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.currentToOpenLabel, gbcp);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = 23;
        gbc3.fill = 2;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        this.controlPanel.add((Component)this.closeButton, gbc3);
        ++gbc3.gridy;
        this.controlPanel.add((Component)this.openButton, gbc3);
        ++gbc3.gridy;
        this.controlPanel.add((Component)this.abortButton, gbc3);
        this.setDefaultValues();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.latchNameLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.lockStatus, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.openSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.openLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.add((Component)this.closeSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.closeLabel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.add((Component)this.filterEngagedSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.filterEngagedLabel, gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        this.add((Component)this.errorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.errorLabel, gbc);
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.faultPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        this.add((Component)this.paramPanel, gbc);
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.insets = Tools.insets_std;
        gbc.anchor = 13;
        gbc.gridwidth = 1;
        this.add((Component)this.controlPanel, gbc);
    }

    private void setDefaultValues() {
        this.openSensorDS.setColor(Color.gray);
        this.closeSensorDS.setColor(Color.gray);
        this.filterEngagedSensorDS.setColor(Color.gray);
        this.errorDS.setColor(Color.gray);
        this.faultSwitch.setColor(Color.GRAY);
        this.lockStatus.setText("UNKNOWN STATE");
        this.openTimeoutLabel.setText("0.0");
        this.closeTimeoutLabel.setText("0.0");
        this.currentToOpenLabel.setText("0.0");
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        if (this.latchName == null) {
            return "Latch";
        }
        return this.latchName;
    }

    public static void main(String[] argv) {
        AutochangerLatchPanel d = new AutochangerLatchPanel("myLatch");
        JFrame frame = new JFrame("Autochanger Latch Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateLatch
    implements Runnable {
        private final StatusDataPublishedByAutochangerLatch s;

        public UpdateLatch(StatusDataPublishedByAutochangerLatch status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerLatchPanel.this.openSensorDS.updateColor(this.s.isUnlockSensorsInError(), this.s.getUnlockSensorValue());
            AutochangerLatchPanel.this.closeSensorDS.updateColor(this.s.isLockSensorsInError(), this.s.getLockSensorValue());
            AutochangerLatchPanel.this.filterEngagedSensorDS.updateColor(this.s.isFilterEngagedSensorsInError(), this.s.getFilterPresenceSensorValue());
            boolean inTravel = this.s.getLockStatus().equals((Object)FcsEnumerations.LockStatus.INTRAVEL);
            boolean unknown = this.s.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNKNOWN);
            if (this.s.isInError() || inTravel || unknown) {
                AutochangerLatchPanel.this.errorDS.setColor(this.s.getLockStatus().getColor());
                AutochangerLatchPanel.this.errorLabel.setText(this.s.getLockStatus().getText());
            } else {
                AutochangerLatchPanel.this.errorDS.setColor(FcsEnumerations.LockStatus.NOERROR.getColor());
                AutochangerLatchPanel.this.errorLabel.setText(FcsEnumerations.LockStatus.NOERROR.getText());
            }
            AutochangerLatchPanel.this.lockStatus.setText(this.s.getLockStatus().getText());
            AutochangerLatchPanel.this.lockStatus.setForeground(this.s.getLockStatus().getColor());
            AutochangerLatchPanel.this.faultSwitch.setColor(this.s.isControllerInFault() ? Color.RED : Tools.greenColor);
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForName = this.configInfo.getCurrentValuesFor(AutochangerLatchPanel.this.latchName);
            FCSCst.FCSLOG.fine((Object)(AutochangerLatchPanel.this.latchName + " configForName=" + configForName));
            AutochangerLatchPanel.this.openTimeoutLabel.setText((String)configForName.get("timeoutForOpening"));
            AutochangerLatchPanel.this.closeTimeoutLabel.setText((String)configForName.get("timeoutForClosing"));
            AutochangerLatchPanel.this.currentToOpenLabel.setText((String)configForName.get("currentToOpen"));
        }
    }
}

