
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import static java.awt.image.ImageObserver.WIDTH;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * A panel to display loader status LPS and LRH
 *
 * @author virieux
 */
public class LoaderStatusPanel extends JPanel {

    private static final long serialVersionUID = 1L;

    private static final String title = "loader status";
    private final DigitalSwitch loaderPresenceSwitch = new DigitalSwitch();
    private final DigitalSwitch loader_LPS_Switch = new DigitalSwitch();
    private final DigitalSwitch loader_LRH_Switch = new DigitalSwitch();

    public LoaderStatusPanel() {
        initComponents();
    }

    /**
     * A Runnable to initialize this Panel from status data published on the
     * STATUS bus by the autochanger
     */
    private class UpdateAutochanger implements Runnable {

        private StatusDataPublishedByAutoChanger s;

        public UpdateAutochanger(StatusDataPublishedByAutoChanger status) {
            this.s = status;
        }

        @Override
        public void run() {
            /*Loader_LPS (=1 if loader is at Storage, loader connected) */
            loader_LPS_Switch.updateColor(s.isLoaderConnectedSensorsInError(),
                    s.getLoaderConnectedSensorValue());

            /*Loader_LRH (=1 if loader is holding filter at HANDOFF) */
            loader_LRH_Switch.updateColor(false, s.isLoaderHoldingFilterAtHandoff());

            /* loader presence status */
            loaderPresenceSwitch.updateColor(s.isLoaderPresenceInError(), s.isLoaderPresence());
        }
    }

    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        SwingUtilities.invokeLater(new LoaderStatusPanel.UpdateAutochanger(s));
    }

    // <editor-fold defaultstate="collapsed" desc="Form Description">
    private void initComponents() {
        setBorder(BorderFactory.createLineBorder(Color.MAGENTA, WIDTH + 5));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.insets = insets_std;
        add(new JLabel("loader presence"), gbc);
        gbc.gridy++;
        add(new JLabel("Loader_LPS (loader at Storage)"), gbc);
        gbc.gridy++;
        add(new JLabel("Loader_LRH (loader holds filter)"), gbc);
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.anchor = GridBagConstraints.EAST;
        add(this.loaderPresenceSwitch, gbc);
        gbc.gridy++;
        add(loader_LPS_Switch, gbc);
        gbc.gridy++;
        add(loader_LRH_Switch, gbc);
        setDefaultValues();
    }

    /**
     * set default values for components color and labels.
     */
    private void setDefaultValues() {
        loader_LPS_Switch.setColor(Color.GRAY);
        loader_LRH_Switch.setColor(Color.GRAY);
        loaderPresenceSwitch.setColor(Color.GRAY);
    }

    /**
     * Reset Panels to default values.
     */
    public void resetPanel() {
        setDefaultValues();
    }

    @Override
    public String toString() {
        return title;
    }

    /**
     * This main launches an GUI for the whole subsystem "fcs". It's used only
     * for tests.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        LoaderStatusPanel d = new LoaderStatusPanel();
        JFrame frame = new JFrame("LoaderStatus Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

}
