
package org.lsst.ccs.subsystems.fcs.loader.ui;

import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

/**
 *
 * @author virieux
 */
public interface InterfaceLoaderGUI extends InterfaceGeneralGUI {

    static final String loaderClampName = "clamp";
    static final String loaderCarrierName = "carrier";

    long getLoGoToHandoffTimeout();

    long getLoGoToStorageTimeout();

    long getLoGoToEngagedTimeout();

    long getOpenHooksTimeout();

    long getCloseHooksTimeout();

    long getClampHooksTimeout();

    void setLoGoToHandoffTimeout(int aInt);

    void setLoGoToStorageTimeout(int aInt);
    
    void setLoGoToEngagedTimeout(int toInt);

    void setClampHooksTimeout(long clampHooksTimeout);

    void setCloseHooksTimeout(long closeHooksTimeout);

    void setOpenHooksTimeout(long openHooksTimeout);



    default void loLoadFilter() {
        System.out.println("loadFilterInCamera with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("Loading filter in camera");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("loadFilterInCamera", getLoGoToHandoffTimeout());
    }

    default void loUnloadFilter() {
        System.out.println("unloadFilterFromCamera with timeout=" + getLoGoToHandoffTimeout());
        FCSLOG.info("Loading filter in camera");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("unloadFilterFromCamera", getLoGoToHandoffTimeout());
    }

    default void loGoToHandOff() {
        FCSLOG.info("Carrier going to Handoff Position");
        FCSLOG.info("/timeout=" + getLoGoToHandoffTimeout());
        sendCommand("goToHandOff", getLoGoToHandoffTimeout(), loaderCarrierName);
    }

    default void loGoToEngaged() {
        FCSLOG.info("Carrier going to Engaged Position");
        FCSLOG.info("/timeout=" + getLoGoToEngagedTimeout());
        sendCommand("goToEngaged", getLoGoToEngagedTimeout(), loaderCarrierName);
    }

    default void loGoToStorage() {
        FCSLOG.info("Carrier going to Storage Position");
        FCSLOG.info("/timeout=" + getLoGoToStorageTimeout());
        sendCommand("goToStorage", getLoGoToStorageTimeout(), loaderCarrierName);
    }

    default void loUpdateCarrierPosition() {
        System.out.println("updateCarrierPosition with UPDATE_POSITION_TIMEOUT=" + UPDATE_POSITION_TIMEOUT);
        FCSLOG.info("Updating carrier position");
        FCSLOG.info("/timeout=" + UPDATE_POSITION_TIMEOUT);
        sendCommand("updatePosition", UPDATE_POSITION_TIMEOUT, loaderCarrierName);
    }

    /* clamp commands */
    default void loClampHooks() {
        FCSLOG.info("Clamping Hooks");
        FCSLOG.info("/timeout=" + getClampHooksTimeout());
        sendCommand("clamp", getClampHooksTimeout(), loaderClampName);
    }

    default void loCloseHooks() {
        FCSLOG.info("Closing Hooks");
        System.out.println("/timeout=" + getCloseHooksTimeout());
        sendCommand("close", getCloseHooksTimeout(), loaderClampName);
    }
    
    default void loUnclampHooks() {
        FCSLOG.info("Unclamping Hooks");
        FCSLOG.info("/timeout=" + getClampHooksTimeout());
        sendCommand("unclamp", getClampHooksTimeout(), loaderClampName);
    }

    default void loOpenHooks() {
        FCSLOG.info("Opening Hooks");
        FCSLOG.info("/timeout=" + getOpenHooksTimeout());
        sendCommand("open", getOpenHooksTimeout(), loaderClampName);
    }

    default void loClampHoming() {
        FCSLOG.info("Clamp homing");
        FCSLOG.info("/timeout=" + getOpenHooksTimeout());
        sendCommand("homing", getOpenHooksTimeout(), loaderClampName);
    }

    

    
}
