package org.lsst.ccs.subsystems.fcs.carousel.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;

/**
 * A GUI for the carousel in standalone mode.
 * 
 * @author virieux
 */
public class CarouselGUI extends GeneralGUI implements InterfaceCarouselGUI {
    private static final long serialVersionUID = 3716082311687590505L;
    


    /**
     * A constructor with a name, a destination (subsystem name) and an AgentMessagingLayer.
     * @param name
     * @param role
     * @param aml 
     */
    public CarouselGUI(String name, String role, AgentMessagingLayer aml) {
        super(name, role, aml);
        this.updateStateWithSensorsTimeout = 5000;
        CarouselGatherPanel carouselGatherPanel;
        carouselGatherPanel = new CarouselGatherPanel(this, CHANGER_TCPPROXY_NAME);
        CarouselBottomPanel carouselBottomPanel = new CarouselBottomPanel(carouselGatherPanel, "CAROUSEL");
        this.generalPanel = new GeneralPanel(this, carouselBottomPanel);
        pane = new JScrollPane(generalPanel);
    }
    
    @Override
    public String getName() {
        return "CarouselGUIModule";
    }
    
     /**
     * This main launches an carousel GUI for the subsystem "carousel".
     * It's used only for tests.
     * 
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("CarouselGUI", AgentInfo.AgentType.CONSOLE);
        CarouselGUI t = new CarouselGUI(agent.getName(), "carousel", 
                agent.getMessagingAccess());
        agent.startAgent();

        JFrame frame = new JFrame("Carousel View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }



    
}
