/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.Variable;
import hep.aida.ref.pdf.VariableList;
import java.util.ArrayList;

public class Product
extends Function {
    private Function[] functions;

    public Product(String name, Function f1, Function f2) {
        super(name);
        this.functions = new Function[]{f1, f2};
        this.initializeProduct(this.functions);
    }

    public Product(String name, ArrayList functionsArray) {
        super(name);
        this.initializeProduct(functionsArray);
    }

    private void initializeProduct(ArrayList functionsArray) {
        this.functions = new Function[functionsArray.size()];
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i] = (Function)functionsArray.get(i);
        }
        this.initializeProduct(this.functions);
    }

    private void initializeProduct(Function[] functions) {
        VariableList list = new VariableList();
        for (Function f : functions) {
            int j;
            f.normalize(true);
            for (j = 0; j < f.numberOfDependents(); ++j) {
                Dependent dep = f.getDependent(j);
                if (list.contains(dep)) continue;
                list.add(dep);
            }
            for (j = 0; j < f.numberOfParameters(); ++j) {
                Parameter par = f.getParameter(j);
                if (list.contains(par)) continue;
                list.add(par);
            }
        }
        this.addVariables(list);
    }

    @Override
    public double functionValue() {
        double val = 1.0;
        for (int i = 0; i < this.functions.length; ++i) {
            val *= this.functions[i].functionValue();
        }
        return val;
    }

    @Override
    public boolean hasAnalyticalVariableGradient(Variable var) {
        return true;
    }

    @Override
    public double evaluateAnalyticalVariableGradient(Variable var) {
        double val = 0.0;
        for (int i = 0; i < this.functions.length; ++i) {
            Function g = this.functions[i];
            double term = g.evaluateAnalyticalVariableGradient(var);
            for (int j = 0; j < this.functions.length; ++j) {
                if (j == i) continue;
                Function f = this.functions[i];
                term *= f.functionValue();
            }
            val += term;
        }
        return val;
    }

    @Override
    public boolean hasAnalyticalNormalization(Dependent dep) {
        for (int i = 0; i < this.functions.length; ++i) {
            Function f = this.functions[i];
            if (!f.hasDependent(dep)) continue;
            if (!f.hasAnalyticalNormalization(dep)) {
                return false;
            }
            if (i == this.functions.length - 1) continue;
            for (int j = i + 1; j < this.functions.length; ++j) {
                Function g = this.functions[j];
                if (!g.hasDependent(dep)) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public double evaluateAnalyticalNormalization(Dependent dep) {
        for (int i = 0; i < this.functions.length; ++i) {
            Function f = this.functions[i];
            if (!f.hasDependent(dep)) continue;
            return f.evaluateAnalyticalNormalization(dep);
        }
        return 0.0;
    }

    @Override
    protected void updateNormalization() {
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i].updateNormalization();
        }
        super.updateNormalization();
    }
}

