/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hsqldb.HsqlException;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.JDBCXADataSource;

public class JDBCXAResource
implements XAResource {
    private JDBCConnection connection;
    private boolean originalAutoCommitMode;
    static int XA_STATE_INITIAL = 0;
    static int XA_STATE_STARTED = 1;
    static int XA_STATE_ENDED = 2;
    static int XA_STATE_PREPARED = 3;
    static int XA_STATE_DISPOSED = 4;
    int state = XA_STATE_INITIAL;
    private JDBCXADataSource xaDataSource;
    Xid xid = null;

    public boolean withinGlobalTransaction() {
        return this.state == XA_STATE_STARTED;
    }

    private void validateXid(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException("Null Xid");
        }
        if (this.xid == null) {
            throw new XAException("There is no live transaction for this XAResource");
        }
        if (!xid.equals(this.xid)) {
            throw new XAException("Given Xid is not that associated with this XAResource object");
        }
    }

    public JDBCXAResource(JDBCXADataSource jDBCXADataSource, JDBCConnection jDBCConnection) {
        this.connection = jDBCConnection;
        this.xaDataSource = jDBCXADataSource;
    }

    JDBCXADataSource getXADataSource() {
        return this.xaDataSource;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        JDBCXAResource jDBCXAResource = this.xaDataSource.getResource(xid);
        if (jDBCXAResource == null) {
            throw new XAException("The XADataSource has no such Xid:  " + xid);
        }
        jDBCXAResource.commitThis(bl);
    }

    public void commitThis(boolean bl) throws XAException {
        if (bl && this.state == XA_STATE_PREPARED) {
            throw new XAException("Transaction is in a 2-phase state when 1-phase is requested");
        }
        if (!bl && this.state != XA_STATE_PREPARED) {
            throw new XAException("Attempt to do a 2-phase commit when transaction is not prepared");
        }
        try {
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        this.dispose();
    }

    private void dispose() throws XAException {
        this.state = XA_STATE_DISPOSED;
        this.xaDataSource.removeResource(this.xid);
        this.xid = null;
        try {
            this.connection.setAutoCommit(this.originalAutoCommitMode);
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        this.validateXid(xid);
        if (this.state != XA_STATE_STARTED) {
            throw new XAException("Invalid XAResource state");
        }
        if (n == 0x4000000) {
            // empty if block
        }
        this.state = XA_STATE_ENDED;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.validateXid(xid);
        if (this.state != XA_STATE_PREPARED) {
            throw new XAException("Attempted to forget a XAResource that is not in a heuristically completed state");
        }
        this.dispose();
        this.state = XA_STATE_INITIAL;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        throw new XAException("Transaction timeouts not implemented yet");
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (!(xAResource instanceof JDBCXAResource)) {
            return false;
        }
        return this.xaDataSource == ((JDBCXAResource)xAResource).getXADataSource();
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        JDBCXAResource jDBCXAResource = this.xaDataSource.getResource(xid);
        if (jDBCXAResource == null) {
            throw new XAException("The XADataSource has no such Xid:  " + xid);
        }
        return jDBCXAResource.prepareThis();
    }

    public int prepareThis() throws XAException {
        if (this.state != XA_STATE_ENDED) {
            throw new XAException("Invalid XAResource state");
        }
        try {
            this.connection.getSession().prepareCommit();
        }
        catch (HsqlException hsqlException) {
            this.state = XA_STATE_PREPARED;
            throw new XAException(hsqlException.getMessage());
        }
        this.state = XA_STATE_PREPARED;
        return 0;
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        return this.xaDataSource.getPreparedXids();
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        JDBCXAResource jDBCXAResource = this.xaDataSource.getResource(xid);
        if (jDBCXAResource == null) {
            throw new XAException("The XADataSource has no such Xid in prepared state:  " + xid);
        }
        jDBCXAResource.rollbackThis();
    }

    public void rollbackThis() throws XAException {
        if (this.state != XA_STATE_PREPARED && this.state != XA_STATE_ENDED) {
            throw new XAException("Invalid XAResource state");
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        this.dispose();
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        if (this.state != XA_STATE_INITIAL && this.state != XA_STATE_DISPOSED) {
            throw new XAException("Invalid XAResource state");
        }
        if (this.xaDataSource == null) {
            throw new XAException("JDBCXAResource has not been associated with a XADataSource");
        }
        if (xid == null) {
            throw new XAException("Null Xid");
        }
        try {
            this.originalAutoCommitMode = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new XAException(sQLException.toString());
        }
        this.xid = xid;
        this.state = XA_STATE_STARTED;
        this.xaDataSource.addResource(this.xid, this);
    }

    JDBCConnection getConnection() {
        return this.connection;
    }

    void setConnection(JDBCConnection jDBCConnection) {
        this.connection = jDBCConnection;
    }
}

