/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.lsst.ccs.localdb.configdb.model.BaseDescription;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameterValue;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.utilities.logging.Logger;

@Table(uniqueConstraints={@UniqueConstraint(columnNames={"baseDescriptionId", "category", "configName", "version"})}, indexes={@Index(columnList="hashMD5")})
@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="org.lsst.ccs.localdb.configdb.model.Configuration")
public class Configuration
implements Serializable {
    private static final long serialVersionUID = 672642551238249224L;
    private long id;
    private BaseDescription baseDescription;
    private String category;
    private String configNameForCategory;
    private Map<ParameterPath, ConfigurationParameterValue> parameterConfigurations = new HashMap<ParameterPath, ConfigurationParameterValue>();
    private long tsaved;
    private int version;
    private boolean defaultVersion;
    private boolean latestVersion = true;
    private byte[] hashMD5;

    protected Configuration() {
    }

    public Configuration(BaseDescription subsystemDescription, String category, String configName, long date) {
        this.baseDescription = subsystemDescription;
        this.category = category;
        this.configNameForCategory = configName;
        this.tsaved = date;
    }

    public Configuration(BaseDescription subsystemDescription, String category, String configName, long date, int version) {
        this(subsystemDescription, category, configName, date);
        this.version = version;
    }

    public Configuration(Configuration other, String newName, long date, int version) {
        this(other.getBaseDescription(), other.getCategory(), newName == null ? other.getConfigName() : newName, date, version);
        this.parameterConfigurations.putAll(other.getConfigurationParameterValues());
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    protected void setId(long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    public BaseDescription getBaseDescription() {
        return this.baseDescription;
    }

    public void setBaseDescription(BaseDescription subsystemDesc) {
        this.baseDescription = subsystemDesc;
    }

    @ManyToMany(cascade={CascadeType.ALL, CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @MapKeyJoinColumn(name="configurationParameter_parameterPath")
    public Map<ParameterPath, ConfigurationParameterValue> getConfigurationParameterValues() {
        return this.parameterConfigurations;
    }

    void setConfigurationParameterValues(Map<ParameterPath, ConfigurationParameterValue> parameterConfigurations) {
        this.parameterConfigurations = parameterConfigurations;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getConfigName() {
        return this.configNameForCategory;
    }

    public void setConfigName(String configName) {
        this.configNameForCategory = configName;
    }

    public long getTsaved() {
        return this.tsaved;
    }

    public void setTsaved(long tsaved) {
        this.tsaved = tsaved;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public boolean isLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(boolean latestVersion) {
        this.latestVersion = latestVersion;
    }

    public void setHashMD5(byte[] md5) {
        this.hashMD5 = md5;
    }

    @Column(columnDefinition="varbinary(100)", nullable=false)
    public byte[] getHashMD5() {
        return this.hashMD5;
    }

    public static byte[] computeHashMD5(BaseDescription baseDescription, TreeMap<String, String> parameterValues) {
        StringBuilder sb = new StringBuilder();
        sb.append(Arrays.toString(baseDescription.getHashMD5())).append("*");
        for (Map.Entry<String, String> e : parameterValues.entrySet()) {
            String name = e.getKey();
            String value = e.getValue();
            sb.append(name).append("=").append(value).append(":");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(sb.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Transient
    public String getConfigurationDescriptionString() {
        return this.category + ":" + this.configNameForCategory + "(" + this.version + ")";
    }

    public void addConfigurationParameterValue(ConfigurationParameterValue parameterConfiguration) {
        ConfigurationParameter cp = parameterConfiguration.getConfigurationParameter();
        if (cp.getCategory().equals(this.getCategory())) {
            this.parameterConfigurations.put(parameterConfiguration.getPath(), parameterConfiguration);
        } else {
            Logger.getLogger((String)"org.lsst.ccs.config").warn((Object)("The property " + cp.getPath().getParameterName() + " does not belong to the category specified by the property file name : " + this.getCategory()));
        }
    }

    public String getValue(ParameterPath path) {
        ConfigurationParameterValue cpv = this.parameterConfigurations.get(path);
        if (cpv == null) {
            return null;
        }
        return cpv.getValue();
    }

    public String toString() {
        return "\"" + this.category + "\":\"" + this.configNameForCategory + "\"(" + this.version + ")";
    }
}

