/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AnalogicSensorPanel
extends JPanel {
    private static final long serialVersionUID = -1531790094506697510L;
    private String clampName = "clampName";
    private String sensorName = "sensorName";
    private final int orientation;
    private JLabel nameLabel;
    private JLabel stateLabel;
    private JLabel valueLabel;
    private JProgressBar progressBar;
    private DigitalSwitch sensorSwitch;
    private JPanel paramsPanel;
    private final JLabel valueALabel = new JLabel("0.0");
    private final JLabel valueBLabel = new JLabel("0.0");
    private final JLabel minLockValueLabel = new JLabel("0.0");
    private final JLabel maxLockValueLabel = new JLabel("0.0");

    public AnalogicSensorPanel(String clampName, String sensorName, int orientation) {
        this.clampName = clampName;
        this.sensorName = sensorName;
        this.orientation = orientation;
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        Map config = configInfo.getCurrentValuesFor(this.clampName);
        String[] words = this.sensorName.split("X");
        this.minLockValueLabel.setText((String)config.get(words[0] + "MinValue"));
        this.valueALabel.setText((String)config.get(words[0] + "ValueA"));
        this.valueBLabel.setText((String)config.get(words[0] + "ValueB"));
        this.maxLockValueLabel.setText((String)config.get(words[0] + "MaxValue"));
    }

    protected void update(int value, FcsEnumerations.ColoredObject sensorStatus) {
        this.progressBar.setValue(value);
        this.valueLabel.setText(Integer.toString(value));
        Color lockSensorColor = sensorStatus.getColor();
        this.sensorSwitch.setColor(lockSensorColor);
        this.stateLabel.setText(sensorStatus.toString());
        this.stateLabel.setForeground(lockSensorColor);
    }

    protected void updateValueA(int value) {
        this.valueALabel.setText(Integer.toString(value));
    }

    private void initComponents() {
        this.progressBar = new JProgressBar(this.orientation);
        this.sensorSwitch = new DigitalSwitch();
        this.sensorSwitch.setColor(Color.gray);
        this.stateLabel = new JLabel("UNKNOWN");
        this.nameLabel = new JLabel(this.sensorName);
        this.valueLabel = new JLabel("0.0");
        this.paramsPanel = new JPanel();
        this.paramsPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramsPanel.add((Component)new JLabel("minValue:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("Value A:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("Value B:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("maxValue:"), gbcp);
        ++gbcp.gridx;
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramsPanel.add((Component)this.minLockValueLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.valueALabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.valueBLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.maxLockValueLabel, gbcp);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.valueLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.progressBar, gbc);
        ++gbc.gridy;
        this.add((Component)this.sensorSwitch, gbc);
        ++gbc.gridy;
        this.add((Component)this.stateLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.nameLabel, gbc);
        ++gbc.gridy;
        this.add((Component)this.paramsPanel, gbc);
    }

    public void resetPanel() {
        this.progressBar.setValue(0);
        this.valueLabel.setText("0.0");
        this.sensorSwitch.setColor(Color.gray);
        this.stateLabel.setText("UNKNOWN STATE");
        this.stateLabel.setForeground(Color.gray);
        this.valueALabel.setText("0.0");
        this.valueBLabel.setText("0.0");
        this.maxLockValueLabel.setText("0.0");
        this.minLockValueLabel.setText("0.0");
    }

    public static void main(String[] argv) {
        AnalogicSensorPanel d = new AnalogicSensorPanel("clampToto", "leBoCapteur", 0);
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

