
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import static org.lsst.ccs.subsystems.fcs.FCSCst.CHANGER_TCPPROXY_NAME;
import org.lsst.ccs.subsystems.fcs.ui.commons.BottomPanel;

/**
 * This is the bottom Panel for the carousel standalone subsystem.
 * It extends BottomPanel, so at the left there is a tree of Panels.
 * 
 * @author virieux
 */
public final class CarouselBottomPanel extends BottomPanel {
    private static final long serialVersionUID = 9167878516568633148L;

    /**
     * A constructor with a CarouselGatherPanel and a title.
     * The title is displayed on the border of the Panel.
     * @param gatherPanel
     * @param title 
     */
    public CarouselBottomPanel(CarouselGatherPanel gatherPanel, String title) {
        super(gatherPanel, title);
    }
    
    /**
     * Creates the nodes of the TreePanel.
     * This tree is displayed on the left part of this Panel.
     * @param top 
     */
    @Override
    public void createNodes(DefaultMutableTreeNode top) {

        if (gatherPanel == null) {
            gatherPanel = new CarouselGatherPanel(CHANGER_TCPPROXY_NAME);
        }
        

        
        /** CANopen devices panels*/
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getCanOpenHardwareListPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((CarouselGatherPanel) gatherPanel).getClampXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((CarouselGatherPanel) gatherPanel).getClampXplusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((CarouselGatherPanel) gatherPanel).getCarouselControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((CarouselGatherPanel) gatherPanel).getHyTTCPanel()));
        devicesNode.add(new DefaultMutableTreeNode(((CarouselGatherPanel) gatherPanel).getCancbxAI814Panel()));
        devicesNode.add(new DefaultMutableTreeNode(((CarouselGatherPanel) gatherPanel).getCancbxPT100Panel()));
        top.add(devicesNode);
        
        /** General view */
        top.add(new DefaultMutableTreeNode(((CarouselGatherPanel) gatherPanel).getCaGeneralViewPanel()));
        
        /** Filter List Panel */
        top.add(new DefaultMutableTreeNode(((CarouselGatherPanel) gatherPanel).getFilterListPanel()));

        
        
        /** Carousel socket panel*/
        DefaultMutableTreeNode socketsNode = new DefaultMutableTreeNode("Carousel sockets");
        ((CarouselGatherPanel) gatherPanel).socketPanels.entrySet().stream().forEach((entry) -> {
            socketsNode.add(new DefaultMutableTreeNode(entry.getValue()));
        });
        top.add(socketsNode);

    }
    
}
