/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.plotter.DefaultPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelType;
import org.lsst.ccs.gconsole.jas3.JasPanelManager;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;

public class TrendingPanel
extends DefaultPage {
    private final LsstTrendingPlugin plugin;
    private EnumMap<Panel, Object> prop;
    private volatile long lastRefresh;

    public TrendingPanel(LsstTrendingPlugin plugin, String title) {
        super((Studio)Application.getApplication(), plugin.getPlotFactory(), title);
        this.plugin = plugin;
        this.createRegions(1, 1);
    }

    public TrendingPanel(LsstTrendingPlugin plugin, Map<Panel, ?> properties) {
        this(plugin, properties.get(Panel.TITLE).toString());
        this.prop = new EnumMap(properties);
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }

    public void showPage() {
        if (this.context == null) {
            if (this.prop == null) {
                this.prop = new EnumMap(Panel.class);
            }
            this.prop.put(Panel.TITLE, (Object)this.title());
            this.prop.put(Panel.GROUP, (Object)this.plugin.PANEL_GROUP);
            this.prop.put(Panel.ICON, (Object)histogramIcon);
            this.prop.put(Panel.TYPE, (Object)PanelType.DATA);
            JasPanelManager panMan = (JasPanelManager)this.plugin.getConsole().getPanelManager();
            panMan.open((Component)((Object)this), this.prop);
            this.prop = null;
            this.context = panMan.getContext((Component)((Object)this));
        } else {
            this.plugin.getConsole().getPanelManager().set((Component)((Object)this), Panel.SELECTED, true);
        }
    }

    public boolean close() {
        boolean out = super.close();
        if (out) {
            this.plugin.closePage(this);
        }
        return out;
    }

    Descriptor save() {
        Descriptor desc = new Descriptor();
        desc.setTitle(this.title());
        desc.setRows(this.rows());
        desc.setColumns(this.columns());
        int n = this.numberOfRegions();
        ArrayList<TrendPlotter.Descriptor> plotterDescriptors = new ArrayList<TrendPlotter.Descriptor>(n);
        for (int i = 0; i < n; ++i) {
            TrendPlotter.Descriptor plotterDescriptor;
            Plotter plotter;
            PlotRegion region = this.region(i);
            if (region == null || (plotter = region.currentPlot()) == null || !(plotter instanceof TrendPlotter) || (plotterDescriptor = ((TrendPlotter)plotter).save()) == null) continue;
            plotterDescriptors.add(plotterDescriptor);
        }
        desc.setPlotters(plotterDescriptors.toArray(new TrendPlotter.Descriptor[0]));
        boolean docked = (Boolean)this.plugin.getConsole().getPanelManager().get((Component)((Object)this), Panel.DOCKED);
        if (!docked) {
            desc.setProperties(this.plugin.getConsole().getPanelManager().get((Component)((Object)this), EnumSet.of(Panel.DEVICE, new Panel[]{Panel.DOCKED, Panel.ICONIZED, Panel.LAST_DESELECTED, Panel.LOCATION, Panel.MAXIMIZED, Panel.SELECTED, Panel.SIZE})));
        }
        return desc;
    }

    void restore(Descriptor desc) {
        HashMap<String, Serializable> properties = desc.getProperties();
        if (properties != null) {
            this.prop = new EnumMap(Panel.class);
            this.prop.put(Panel.DOCKED, (Object)false);
            properties.forEach((key, value) -> this.prop.put(Panel.valueOf(key), value));
        }
        int rows = desc.getRows();
        int columns = desc.getColumns();
        if (rows != 1 || columns != 1) {
            this.createRegions(columns, rows);
        }
        int i = 0;
        for (TrendPlotter.Descriptor plotterDescriptor : desc.getPlotters()) {
            TrendPlotter plotter = this.plugin.create();
            LsstTrendingPlugin.showPlotter(plotter, this.region(i++));
            plotter.restore(plotterDescriptor);
        }
    }

    public static class Descriptor
    implements Serializable {
        private String title;
        private int rows;
        private int columns;
        private TrendPlotter.Descriptor[] plotters;
        private HashMap<String, Serializable> properties;

        public TrendPlotter.Descriptor[] getPlotters() {
            return this.plotters;
        }

        public void setPlotters(TrendPlotter.Descriptor[] plotters) {
            this.plotters = plotters;
        }

        public TrendPlotter.Descriptor getPlotters(int index) {
            return this.plotters[index];
        }

        public void setPlotters(int index, TrendPlotter.Descriptor plotters) {
            this.plotters[index] = plotters;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public HashMap<String, Serializable> getProperties() {
            return this.properties;
        }

        public void setProperties(HashMap<String, Serializable> properties) {
            this.properties = properties;
        }
    }
}

