/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandSender;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentHandle;
import org.lsst.ccs.gconsole.plugins.commandbrowser.ArgInputPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.CommandListPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.ComponentDictionary;
import org.lsst.ccs.gconsole.plugins.commandbrowser.DictionaryTreePanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.HTMLTextPane;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.gconsole.services.persist.Savable;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.TreeBranch;

public final class AgentPanel
extends JSplitPane
implements Savable,
ChangeListener {
    private final Logger logger = Logger.getLogger((String)"org.lsst.ccs.plugin.jas3.dictionary");
    private AgentHandle agent;
    private final DictionaryTreePanel dictionaryTree;
    private final CommandListPanel commandListPanel;
    private final ArgInputPanel argInputPanel;
    private final HTMLTextPane resultPane;
    private final CommandSender sender;
    Descriptor descriptor;

    public AgentPanel() {
        super(0);
        this.setContinuousLayout(true);
        this.descriptor = new Descriptor();
        JPanel topPane = new JPanel(new GridLayout(1, 3));
        this.setTopComponent(topPane);
        this.resultPane = new HTMLTextPane();
        this.setBottomComponent(new JScrollPane(this.resultPane));
        this.dictionaryTree = new DictionaryTreePanel(this);
        topPane.add(new JScrollPane(this.dictionaryTree));
        this.commandListPanel = new CommandListPanel(this);
        topPane.add(new JScrollPane(this.commandListPanel));
        this.dictionaryTree.addTreeSelectionListener(this.commandListPanel);
        JPanel topPaneRightPanel = new JPanel(new BorderLayout());
        topPane.add(topPaneRightPanel);
        this.argInputPanel = new ArgInputPanel();
        topPaneRightPanel.add((Component)this.argInputPanel, "Center");
        this.commandListPanel.addListSelectionListener(this.argInputPanel);
        Box buttonPane = Box.createHorizontalBox();
        topPaneRightPanel.add((Component)buttonPane, "South");
        JCheckBox cb = new JCheckBox("Hide locked");
        buttonPane.add(cb);
        cb.setToolTipText("Hide commands unavailable due to agent lock state");
        cb.setSelected(this.descriptor.hideUnavailableCommands);
        cb.addActionListener(e -> {
            this.descriptor.setHideUnavailableCommands(cb.isSelected());
            this.dictionaryTree.updateData(this.agent);
        });
        buttonPane.add(Box.createRigidArea(Const.HDIM));
        buttonPane.add(Box.createHorizontalGlue());
        JButton sendCmdButton = new JButton(new ImageIcon(this.getClass().getResource("ic_send_black_24dp.png")));
        buttonPane.add(sendCmdButton);
        sendCmdButton.setText("Send");
        sendCmdButton.setEnabled(false);
        sendCmdButton.addActionListener(e -> this.sendCommand());
        this.commandListPanel.addListSelectionListener(e -> {
            boolean en = this.commandListPanel.isVisibleCommandSelected();
            sendCmdButton.setEnabled(en);
            this.argInputPanel.setEnabled(en);
        });
        this.sender = Console.getConsole().getSingleton(CommandService.class).getSender();
        this.sender.setCommandHandle(new BrowserCommandHandle());
    }

    void setAgent(AgentHandle agent) {
        if (this.agent != null) {
            this.agent.removeListener(this);
        }
        this.agent = agent;
        if (agent != null) {
            if (agent.getDictionaries().isEmpty()) {
                agent.updateDictionaries();
            }
            agent.addListener(this);
        }
        this.dictionaryTree.updateData(agent);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.agent == null || !this.agent.isAdjusting()) {
            this.dictionaryTree.updateData(this.agent);
        }
    }

    private void sendCommand() {
        TreeBranch destinationNode = (TreeBranch)this.dictionaryTree.getLastSelectedPathComponent();
        ComponentDictionary commandContext = (ComponentDictionary)destinationNode.getContent();
        DictionaryCommand cmd = (DictionaryCommand)this.commandListPanel.getSelectedValue();
        if (cmd != null) {
            String s = this.argInputPanel.getFormattedArgumentValues();
            Object[] args = this.argInputPanel.getFormattedValues();
            String commandName = cmd.getCommandName();
            String path = commandContext.path;
            String command = path + "/" + commandName;
            this.resultPane.insertHTML("<b>> " + path + " " + commandName + " " + s + " ...</b>");
            this.sender.execute(command, args);
        }
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
        } else if (descriptor == null) {
            this.descriptor = new Descriptor();
        }
    }

    @Override
    public Descriptor save() {
        return this.descriptor;
    }

    public static class Descriptor
    implements Serializable {
        private boolean hideUnavailableCommands;

        public boolean isHideUnavailableCommands() {
            return this.hideUnavailableCommands;
        }

        public void setHideUnavailableCommands(boolean hideUnavailableCommands) {
            this.hideUnavailableCommands = hideUnavailableCommands;
        }
    }

    private class BrowserCommandHandle
    implements CommandHandle {
        private BrowserCommandHandle() {
        }

        @Override
        public void onSendingFailure(Throwable t, CommandTask source) {
            StringBuilder sb = new StringBuilder("<font color=\"#FF0000\">");
            if (t == null) {
                sb.append("Cannot send command.");
            } else {
                sb.append(this.shorten(t.getMessage()));
            }
            AgentPanel.this.resultPane.insertHTML(sb.append("</font>").toString());
        }

        @Override
        public void onAck(CommandAck ack, CommandTask source) {
        }

        @Override
        public void onNack(CommandNack nack, CommandTask source) {
            String message;
            StringBuilder sb = new StringBuilder("<font color=\"#FF0000\">");
            sb.append("Command rejected");
            if (nack != null && (message = this.shorten(nack.getReason())) != null && !message.isEmpty()) {
                sb.append(": ").append(message);
            }
            AgentPanel.this.resultPane.insertHTML(sb.append("</font>").toString());
        }

        @Override
        public void onSuccess(Object res, CommandTask source) {
            if (res == null) {
                AgentPanel.this.resultPane.insertHTML("Done.");
            } else {
                if (res.getClass().isArray()) {
                    try {
                        res = Arrays.deepToString((Object[])res);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                AgentPanel.this.resultPane.insertHTML(res.toString().replaceAll("(\\r\\n|\\n)", "<br />"));
            }
        }

        @Override
        public void onExecutionFailure(Throwable t, CommandTask source) {
            StringBuilder sb = new StringBuilder("<font color=\"#FF0000\">");
            if (t == null) {
                sb.append("Failed.");
            } else {
                sb.append(this.shorten(t.getMessage()));
            }
            AgentPanel.this.resultPane.insertHTML(sb.append("</font>").toString());
        }

        @Override
        public void onTimeout(TimeoutException x, CommandTask source) {
            AgentPanel.this.resultPane.insertHTML("<font color=\"#FF0000\">" + this.shorten(x.getMessage()) + "</font>");
        }

        @Override
        public void onCancel(CancellationException exception, CommandTask source) {
            AgentPanel.this.resultPane.insertHTML("Cancelled.");
        }

        @Override
        public void onResult(Object res, CommandTask source) {
            AgentPanel.this.resultPane.insertHTML("Result: " + (res == null ? "" : res));
        }

        private String shorten(String message) {
            if (message != null && message.length() > 200) {
                Matcher m = Pattern.compile("\\s[A-Z]").matcher(message);
                int end = m.find(20) ? m.start() : 150;
                message = message.substring(0, end) + " ...";
            }
            return message;
        }
    }
}

