/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.panel;

import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.lsst.ccs.gconsole.base.panel.PanelType;

public enum Panel implements Serializable
{
    TYPE(PanelType.class),
    GROUP(String.class),
    TITLE(String.class),
    ICON(Icon.class),
    OPEN(Boolean.class),
    SELECTED(Boolean.class),
    ICONIZED(Boolean.class),
    DOCKED(Boolean.class),
    SIZE(Dimension.class),
    LOCATION(Point.class),
    DEVICE(Object.class),
    MAXIMIZED(Boolean.class),
    LAST_DESELECTED(Long.class),
    ON_SAVE_AS(Consumer.class),
    ON_CLOSE(Consumer.class);

    private final Class<?> type;

    private Panel(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public static Panel getKey(Object key) {
        return key instanceof Panel ? (Panel)key : Panel.valueOf(key.toString());
    }

    public boolean isValueValid(Object value) {
        return value == null || this.type.isInstance(value);
    }

    public void checkValue(Object value) {
        if (!this.isValueValid(value)) {
            throw new IllegalArgumentException("Illegal value type " + value.getClass() + " for panel state attribute " + this);
        }
    }

    public static boolean isValueValid(Object key, Object value) {
        if (value == null) {
            return true;
        }
        if (key instanceof Panel) {
            return ((Panel)key).isValueValid(value);
        }
        try {
            return Panel.valueOf(key.toString()).isValueValid(value);
        }
        catch (IllegalArgumentException x) {
            return true;
        }
    }

    public static void checkValue(Object key, Object value) {
        if (!Panel.isValueValid(key, value)) {
            throw new IllegalArgumentException("Illegal value type " + value.getClass() + " for panel state attribute " + key);
        }
    }
}

