/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.filter;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;

public class PageFilter
extends AbstractChannelsFilter {
    private final AgentChannelsFilter filter;
    private final String prefix;

    public PageFilter(AgentChannelsFilter filter, String page) {
        this.filter = filter;
        this.prefix = page == null || page.isEmpty() ? "" : page + "//";
    }

    @Override
    public String getName() {
        String name = this.filter.getName();
        if (name != null) {
            name = name + ":";
            if (!this.prefix.isEmpty()) {
                name = name + this.prefix.substring(0, this.prefix.length() - 2);
            }
        }
        return name;
    }

    @Override
    public List<String> getAgents() {
        return this.filter.getAgents();
    }

    @Override
    public List<String> getOriginChannels() {
        return this.filter.getOriginChannels();
    }

    @Override
    public List<String> getDisplayChannels() {
        List<String> cc = this.filter.getDisplayChannels();
        if (cc == null) {
            return null;
        }
        return this.filterPage(cc);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return this.filter.getOriginPath(this.prefix + displayPath);
    }

    @Override
    public List<String> getDisplayPath(AgentChannel channel) {
        return this.filterPage(this.filter.getDisplayPath(channel));
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        return this.filterPage(this.filter.getDisplayPath(originPath));
    }

    @Override
    public Map<String, Object> getAttributes(String path) {
        return this.filter.getAttributes(this.prefix + path);
    }

    @Override
    public List<String> getFields(boolean compact) {
        return this.filter.getFields(compact);
    }

    @Override
    public void addListener(AgentChannelsFilter.Listener listener) {
        this.filter.addListener(listener);
    }

    @Override
    public void removeListener(AgentChannelsFilter.Listener listener) {
        this.filter.removeListener(listener);
    }

    List<String> filterPage(List<String> in) {
        if (this.prefix.isEmpty()) {
            return in.stream().filter(dp -> !dp.contains("//")).collect(Collectors.toList());
        }
        int i = this.prefix.length();
        return in.stream().filter(dp -> dp.startsWith(this.prefix)).map(dp -> dp.substring(i)).collect(Collectors.toList());
    }
}

