/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.carousel.ui.AnalogicSensorPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselClampPanel
extends JPanel {
    private static final long serialVersionUID = -1273081770223753869L;
    private String clampName;
    private String lockSensorName;
    private String filterPresenceSensorName;
    private JLabel clampStateLabel;
    private final JLabel explainText = new JLabel("<HTML>LOCKED: valueB < v < maxValue <P> UNLOCKED: minValue < v < valueA </HTML>");
    private AnalogicSensorPanel lockSensorPanel;
    private AnalogicSensorPanel filterPresenceSensorPanel;
    private JPanel paramsPanel;
    private final JLabel currentToUnlockLabel = new JLabel("0");
    private final JLabel currentToMaintainUnlockLabel = new JLabel("0");

    public CarouselClampPanel(String clampName) {
        this.clampName = clampName;
        String[] words = clampName.split("X");
        this.lockSensorName = "lockSensorX" + words[1];
        this.filterPresenceSensorName = "filterPresenceX" + words[1];
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        Map config = configInfo.getCurrentValuesFor(this.clampName);
        this.currentToUnlockLabel.setText((String)config.get("currentToUnlock"));
        this.currentToMaintainUnlockLabel.setText((String)config.get("currentToMaintainUnlocked"));
        this.lockSensorPanel.initializeGui(configInfo);
        this.filterPresenceSensorPanel.initializeGui(configInfo);
    }

    protected void updateClamp(StatusDataPublishedByCarouselClamp s) {
        SwingUtilities.invokeLater(new UpdateClamp(s));
    }

    private void initComponents() {
        this.clampStateLabel = new JLabel("UNKNOWN STATE");
        this.clampStateLabel.setFont(Tools.BIG_FONT);
        this.lockSensorPanel = new AnalogicSensorPanel(this.clampName, this.lockSensorName, 0);
        this.filterPresenceSensorPanel = new AnalogicSensorPanel(this.clampName, this.filterPresenceSensorName, 1);
        this.paramsPanel = new JPanel();
        this.paramsPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.paramsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramsPanel.add((Component)new JLabel("Current to lock:"), gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)new JLabel("<HTML>Current to <P>maintain unlock:</HTML>"), gbcp);
        ++gbcp.gridx;
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramsPanel.add((Component)this.currentToUnlockLabel, gbcp);
        ++gbcp.gridy;
        this.paramsPanel.add((Component)this.currentToMaintainUnlockLabel, gbcp);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.nicePink), this.clampName));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.clampStateLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.paramsPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.explainText, gbc);
        ++gbc.gridy;
        this.add((Component)this.lockSensorPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.filterPresenceSensorPanel, gbc);
    }

    public void resetPanel() {
        this.currentToUnlockLabel.setText("0.0");
        this.currentToMaintainUnlockLabel.setText("0.0");
        this.clampStateLabel.setText("UNKNOWN STATE");
        this.lockSensorPanel.resetPanel();
        this.filterPresenceSensorPanel.resetPanel();
    }

    public static void main(String[] argv) {
        CarouselClampPanel d = new CarouselClampPanel("clampXminus");
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateClamp
    implements Runnable {
        private StatusDataPublishedByCarouselClamp s;

        public UpdateClamp(StatusDataPublishedByCarouselClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            CarouselClampPanel.this.clampStateLabel.setText(this.s.getClampState().toString());
            CarouselClampPanel.this.clampStateLabel.setForeground(this.s.getClampState().getColor());
            CarouselClampPanel.this.lockSensorPanel.update(this.s.getLockSensorValue(), this.s.getLockStatus());
            CarouselClampPanel.this.filterPresenceSensorPanel.update(this.s.getFilterPositionSensorValue(), this.s.getFilterPresenceStatus());
        }
    }
}

