/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.io.PrintWriter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLatch;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterExchangeMainPanel;

public class SingleFilterTestGUISubsystem
extends Subsystem {
    private static final String sft_dest = "single-filter-test";
    private PrintWriter out = new PrintWriter(System.out, true);
    private FilterExchangeMainPanel assembly = new FilterExchangeMainPanel(this);
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    private boolean initialized = false;
    String stateCorrelId;

    public void initGui() {
        this.setName("SingleFilterTestGUIModule");
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
    }

    public JComponent getGuiLayout() {
        return this.assembly;
    }

    public void resetGui() {
    }

    public static void main(String[] args) {
        System.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", args.length >= 1 ? args[0] : "localhost");
        System.setProperty("org.omg.CORBA.ORBInitialPort", "3700");
        SingleFilterTestGUISubsystem t = new SingleFilterTestGUISubsystem();
        JFrame frame = new JFrame("Single Filter Test Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        frame.setResizable(false);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void onReply(CommandReply s) {
        if (s.getCorrelId().equals(this.stateCorrelId)) {
            SingleFilterTestConfig config = (SingleFilterTestConfig)s.getReply();
            this.assembly.initializeGui(config);
            this.initialized = true;
        }
    }

    public void onStatus(BusMessage s) {
        if (this.initialized) {
            if (s instanceof StatusDataPublishedByClamp) {
                this.assembly.updateClamp((StatusDataPublishedByClamp)s);
                this.lastHeartBeat = s.getTimeStamp();
            } else if (s instanceof StatusDataPublishedByBasicAutoChanger) {
                this.assembly.updateAutoChanger((StatusDataPublishedByBasicAutoChanger)s);
                this.lastHeartBeat = s.getTimeStamp();
            } else if (s instanceof StatusDataPublishedByLatch) {
                this.assembly.updateLatch((StatusDataPublishedByLatch)s);
                this.lastHeartBeat = s.getTimeStamp();
            } else if (s instanceof StatusDataPublishedByCarousel) {
                this.assembly.updateCarousel((StatusDataPublishedByCarousel)s);
                this.lastHeartBeat = s.getTimeStamp();
            } else if (s instanceof StatusDataPublishedByClampActuator) {
                this.assembly.updateActuator((StatusDataPublishedByClampActuator)s);
                this.lastHeartBeat = s.getTimeStamp();
            }
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState", new Object[0]);
                this.sendCommand(cmd);
                this.stateCorrelId = cmd.getCorrelId();
            }
        }
    }

    private void sendCommand(ModuleInvokerCommand cmd) {
        cmd.setDestination(sft_dest);
        this.updateCurrentSubsystem();
        this.fac.sendCommand((Command)cmd);
    }
}

