package org.lsst.ccs.subsystems.fcs.states;

/**
 * Enumeration that represents our knowledge of the software lock on the telescope mount (TMA) and the rotator
 *
 * This state is used as a precondition for a filter exchange without the risk of having telescope slew during motion
 * The precondition is only enforced on NORMAL commands (= level 0) such as setFilter or loadFilter
 */
public enum TmaRotatorState {
    LOCKED,    /* Telescope is in CameraMotionState.LOCKED = we can safely execute a filter change */
    UNLOCKED,  /* Telescope is in CameraMotionState.UNLOCKED = filter change is prevented on the observatory level */
    PROTOTYPE, /* Working on the FES prototype in Paris, France = no need for software lock */
    UNKNOWN    /* Default state at startup */
}
