package org.lsst.ccs.subsystems.fcs.states;

/**
 * Enumeration that represents the ability for the filter exchange system to execute an action
 *
 * Since almost all FCS commands are synchroneous, when executing one command this state is switched
 * to NOT_READY to state that a second command cannot be executed right now.
 */
public enum FilterReadinessState {
    NOT_READY, /* Cannot execute an action */
    READY      /* Ready to execute an action */
}
