
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * A structure for the data published on the status bus by the ClampModule.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarouselClamp implements Serializable {
    private static final long serialVersionUID = 3238914072953604160L;

    @DataAttributes(description = "Carousel clamp state {READY_TO_LOCK; UNLOCKED_ON_FILTER; "
        + "UNLOCKED_EMPTY; LOCKED_ON_FILTER; UNDEFINED; ERROR; UNLOCKABLE}", units = "unitless")
    private FilterClampState clampState;

    @DataAttributes(description = "Carousel clamp filter presence status {NOFILTER; ENGAGED; "
        + "LOCKABLE; NOT_LOCKABLE; ERROR; UNKNOWN}", units = "unitless")
    private FilterPresenceStatus filterPresenceStatus;

    @DataAttributes(description = "Filter position sensor value in carousel clamp", units = "unitless")
    private int filterPositionSensorValue;

    @DataAttributes(description = "Carousel clamp filter lock status {UNLOCKED; LOCKED; RELAXED; "
        + "OPENED; CLOSED; UNKNOWN; ERROR}", units = "unitless")
    private LockStatus lockStatus;

    @DataAttributes(description = "Carousel clamp filter lock sensor value", units = "unitless")
    private int lockSensorValue;

    @DataAttributes(description = "Offset1 for carousel clamp lock sensor read on hyttc580", units = "unitless")
    private int lockSensorOffset1;

    @SkipEncoding
    @DataAttributes(description = "Lower bound on the filterPresenceSensorValue to consider "
        + "the filter engaged and lockable.", units = "unitless")
    private int filterPresenceMinLimit;

    @DataAttributes(description = "Offset2 for filter presence sensor read on hyttc580: if filter presence sensor "
            + "returns a value between filterPresenceOffset1 and filterPresenceOffset2 then the filter "
            + "is engaged and lockable.", units = "unitless")
    private int filterPresenceOffset2;

    public StatusDataPublishedByCarouselClamp() {
        clampState = FilterClampState.UNDEFINED;
        filterPresenceStatus = FilterPresenceStatus.UNKNOWN;
        filterPositionSensorValue = 0;
        lockStatus = LockStatus.UNKNOWN;
        lockSensorValue = 0;
    }

    public void setFilterPresenceStatus(FilterPresenceStatus filterPositionInClamp) {
        this.filterPresenceStatus = filterPositionInClamp;
    }

    public void setFilterPositionSensorValue(int filterPositionSensorValue) {
        this.filterPositionSensorValue = filterPositionSensorValue;
    }

    public void setLockSensorValue(int lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public int getLockSensorOffset1() {
        return lockSensorOffset1;
    }

    public void setLockSensorOffset1(int lockSensorOffset1) {
        this.lockSensorOffset1 = lockSensorOffset1;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public FilterPresenceStatus getFilterPresenceStatus() {
        return filterPresenceStatus;
    }

    public int getFilterPositionSensorValue() {
        return filterPositionSensorValue;
    }

    public int getLockSensorValue() {
        return lockSensorValue;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public FilterClampState getClampState() {
        return clampState;
    }

    public void setClampState(FilterClampState clampState) {
        this.clampState = clampState;
    }

    public int getFilterPresenceMinLimit() {
        return filterPresenceMinLimit;
    }

    public void setFilterPresenceMinLimit(int value) {
        this.filterPresenceMinLimit = value;
    }

    public int getFilterPresenceOffset2() {
        return filterPresenceOffset2;
    }

    public void setFilterPresenceOffset2(int value) {
        this.filterPresenceOffset2 = value;
    }
}
