package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.data.Alert;

/**
 * An enum to describe all the Alerts than can be raised by FCS.
 */
public enum FcsAlerts {

    UNSYNC_BOOT("A boot message has been received for a device."),
    EMCY("Received an EMERGENCY message from a device."),
    IN_FAULT("Controller in fault."),
    CAN_BUS_TIMEOUT("Timeout expired while waiting to response from CANbus"),
    CAN_BUS_READING_ERROR("Error in reading on CANbus"),
    CAN_BUS_NOT_INITIALIZED("Could not init canInterface. POWER FAILURE ? Is Clean 24V up ? Check power, reboot pc104 and then restart fcs."),
    HARDWARE_MISSING("HARDWARE NOT DETECTED - POWER FAILURE ?"),
    HARDWARE_ERROR("HARDWARE ERROR"),
    CA_LOCKING_ISSUE("CAROUSEL LOCKING ISSUE"),
    CA_LOCKING_RECOVERY_SUCCESS("CAROUSEL LOCKING RECOVERY SUCCESSFUL"),
    CA_LOCKING_RECOVERY_FAILURE("CAROUSEL LOCKING RECOVERY FAILED"),
    CA_UNLOCKING_RECOVERY_SUCCESS("CAROUSEL UNLOCKING RECOVERY SUCCESSFUL"),
    CA_UNLOCKING_RECOVERY_FAILURE("CAROUSEL UNLOCKING RECOVERY FAILED"),
    CA_ROTATION_RECOVERY("CAROUSEL ROTATION RECOVERY NEEDED"),
    CA_ROTATION_RECOVERY_SUCCESS("CAROUSEL ROTATION RECOVERY SUCCESSFUL"),
    CA_ROTATION_RECOVERY_FAILURE("CAROUSEL ROTATION RECOVERY FAILED"),
    AC_ONLINE_CLAMPS_CLOSED_AT_STARTUP("Autochanger Online Clamps CLOSED at startup"),
    AC_ONLINE_CLAMPS_STAY_ENABLED("Autochanger Online Clamps are still ENABLED after locking"),
    BAD_SERIAL_NB("Serial number read in CPU different from serial number in configuration"),
    PARAMETER_ERROR("ERROR in CPU controller for a parameter"),
    SDO_ERROR("Error in a request to a CANopen device"),
    AC_SENSOR_ERROR("Autochanger sensors are in error"),
    CA_SENSOR_ERROR("Carousel sensors are in error"),
    LO_SENSOR_ERROR("Loader sensors are in error"),
    AC_TRUCKS_ERROR("Autochanger trucks ERROR"),
    UPDATE_ERROR("ERROR in updateStateWithSensors");

    private final String longDescription;

    private FcsAlerts(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getLongDescription() {
        return longDescription;
    }

    public Alert getAlert() {
        return getAlert(null);
    }

    public Alert getAlert(String prefix) {
        String alertId = name();
        if ( prefix != null && !prefix.isEmpty() ) {
            alertId = prefix+"/"+alertId;
        }
        return new Alert(alertId, getLongDescription());
    }
}
