
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * A structure for the data published on the status bus by the ClampModule.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarouselClamp implements Serializable {
    private static final long serialVersionUID = 3238914072953604160L;

    private FilterClampState clampState;
    private FilterPresenceStatus filterPresenceStatus;
    private int filterPositionSensorValue;
    private LockStatus lockStatus;
    private int lockSensorValue;
    private double temperature;
    private int lockSensorValueA;
    private int filterPresenceValueA;

    public StatusDataPublishedByCarouselClamp() {
        clampState = FilterClampState.UNDEFINED;
        filterPresenceStatus = FilterPresenceStatus.UNKNOWN;
        filterPositionSensorValue = 0;
        lockStatus = LockStatus.UNKNOWN;
        lockSensorValue = 0;
        temperature = 0;
    }

    public void setFilterPresenceStatus(FilterPresenceStatus filterPositionInClamp) {
        this.filterPresenceStatus = filterPositionInClamp;
    }

    public void setFilterPositionSensorValue(int filterPositionSensorValue) {
        this.filterPositionSensorValue = filterPositionSensorValue;
    }

    public void setLockSensorValue(int lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double getTemperature() {
        return temperature;
    }

    public FilterPresenceStatus getFilterPresenceStatus() {
        return filterPresenceStatus;
    }

    public int getFilterPositionSensorValue() {
        return filterPositionSensorValue;
    }

    public int getLockSensorValue() {
        return lockSensorValue;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public FilterClampState getClampState() {
        return clampState;
    }

    public void setClampState(FilterClampState clampState) {
        this.clampState = clampState;
    }

    public int getLockSensorValueA() {
        return lockSensorValueA;
    }

    public void setLockSensorValueA(int lockSensorValueA) {
        this.lockSensorValueA = lockSensorValueA;
    }

    public int getFilterPresenceValueA() {
        return filterPresenceValueA;
    }

    public void setFilterPresenceValueA(int filterPresenceValueA) {
        this.filterPresenceValueA = filterPresenceValueA;
    }
    
    


}
