/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.text.DefaultCaret;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelEvent;
import org.lsst.ccs.gconsole.base.panel.PanelListener;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.base.panel.PanelType;
import org.lsst.ccs.gconsole.plugins.alert.LsstAlertPlugin;
import org.lsst.ccs.gconsole.util.tree.TreeUtil;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;

public class AlertViewer
implements AlertListener,
PanelListener {
    private final LsstAlertPlugin plugin;
    private final String PANEL_GROUP = "AlertsViewer";
    private Descriptor config;
    private AlertTree tree;
    private JEditorPane infoPanel;
    private JScrollBar infoScrollBar;
    private JPanel rightPanel;
    private JScrollPane leftPanel;
    private Action clearAction;
    private JCheckBox freezeBox;
    private JCheckBox historyBox;
    private JCheckBox muteBox;
    private JCheckBox toFrontBox;
    private JCheckBox selectNewBox;
    private static final int HSPACE = 10;
    private static final int VSPACE = 5;
    private static final EnumMap<AlertState, String> ALCOLOR = new EnumMap(AlertState.class);
    private static final EnumMap<AlertState, Color> COLOR;

    public AlertViewer(LsstAlertPlugin plugin, Descriptor configuration) {
        this.plugin = plugin;
        this.config = configuration;
    }

    private void start() {
        this.clearAction = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertNode node = AlertViewer.this.tree.getSelectedNode();
                if (node == null) {
                    return;
                }
                final HashMap alerts = AlertViewer.this.getAlertMap(node);
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        AlertViewer.this.plugin.clearAlerts(alerts);
                        return null;
                    }
                }.execute();
            }
        };
        this.clearAction.putValue("ShortDescription", "Clear selected alerts.");
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(new JButton(this.clearAction));
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.freezeBox = new JCheckBox("Freeze");
        this.freezeBox.setSelected(false);
        this.freezeBox.addActionListener(e -> {
            if (!this.freezeBox.isSelected()) {
                this.infoPanel.setText(this.tree.getSelectedNode().getInfo());
                this.infoPanel.setCaretPosition(0);
            }
        });
        this.freezeBox.setToolTipText("Freeze information panel content");
        buttonPanel.add(this.freezeBox);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.historyBox = new JCheckBox("History");
        this.historyBox.setSelected((Boolean)this.plugin.getServices().getProperty("history"));
        this.historyBox.addActionListener(e -> {
            this.plugin.getServices().setProperty("history", this.historyBox.isSelected());
            this.infoPanel.setText(this.tree.getSelectedNode().getInfo());
            this.infoPanel.setCaretPosition(0);
        });
        this.historyBox.setToolTipText("Show history of alerts");
        buttonPanel.add(this.historyBox);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.muteBox = new JCheckBox("Mute");
        this.muteBox.setSelected((Boolean)this.plugin.getServices().getProperty("mute"));
        this.muteBox.addActionListener(e -> this.plugin.getServices().setProperty("mute", this.muteBox.isSelected()));
        this.muteBox.setToolTipText("Disable audio alerts");
        buttonPanel.add(this.muteBox);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.selectNewBox = new JCheckBox("Select new alerts");
        this.selectNewBox.setSelected((Boolean)this.plugin.getServices().getProperty("selectLast"));
        this.selectNewBox.addActionListener(e -> this.plugin.getServices().setProperty("selectLast", this.selectNewBox.isSelected()));
        this.selectNewBox.setToolTipText("Automatically select new alerts");
        buttonPanel.add(this.selectNewBox);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.toFrontBox = new JCheckBox("Show viewer on alert");
        this.toFrontBox.setSelected((Boolean)this.plugin.getServices().getProperty("toFront"));
        this.toFrontBox.addActionListener(e -> this.plugin.getServices().setProperty("toFront", this.toFrontBox.isSelected()));
        this.toFrontBox.setToolTipText("Display alert viewer when new alerts are received");
        buttonPanel.add(this.toFrontBox);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree = AlertTree.getInstance();
        this.tree.addTreeSelectionListener(e -> {
            AlertNode node = this.tree.getSelectedNode();
            if (node == null) {
                this.clearAction.setEnabled(false);
                this.historyBox.setEnabled(false);
                if (!this.freezeBox.isSelected()) {
                    this.infoPanel.setText("");
                }
            } else {
                this.clearAction.setEnabled(true);
                this.historyBox.setEnabled(node.isLeaf());
                if (!this.freezeBox.isSelected()) {
                    this.infoPanel.setText(node.getInfo());
                }
            }
        });
        this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AlertViewer.this.freezeBox.isSelected()) {
                    AlertViewer.this.freezeBox.doClick();
                }
            }
        });
        this.infoPanel = new JEditorPane();
        this.infoPanel.setEditable(false);
        this.infoPanel.setContentType("text/html");
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        try {
            DefaultCaret caret = (DefaultCaret)this.infoPanel.getCaret();
            caret.setUpdatePolicy(1);
        }
        catch (ClassCastException caret) {
            // empty catch block
        }
        this.infoPanel.setText("");
        this.rightPanel = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.infoPanel);
        this.infoScrollBar = scroll.getVerticalScrollBar();
        this.rightPanel.add((Component)scroll, "Center");
        this.rightPanel.add((Component)buttonPanel, "South");
        this.leftPanel = new JScrollPane(this.tree);
        PanelManager panMan = this.plugin.getConsole().getPanelManager();
        EnumMap<Panel, Object> state = new EnumMap<Panel, Object>(Panel.class);
        state.put(Panel.TYPE, PanelType.CONTROL);
        state.put(Panel.TITLE, "Alerts");
        state.put(Panel.GROUP, "AlertsViewer");
        panMan.open((Component)this.leftPanel, state);
        state.put(Panel.TYPE, PanelType.DATA);
        if (this.config != null && this.config.isUndocked()) {
            state.put(Panel.DOCKED, Boolean.valueOf(false));
            state.put(Panel.ICONIZED, Boolean.valueOf(this.config.isIconized()));
            state.put(Panel.SIZE, this.config.getSize());
            state.put(Panel.LOCATION, this.config.getLocation());
            state.put(Panel.DEVICE, this.config.getDevice());
            state.put(Panel.MAXIMIZED, Boolean.valueOf(this.config.isMaximized()));
        }
        panMan.open((Component)this.rightPanel, state);
        panMan.addListener(this, this.leftPanel);
        panMan.addListener(this, this.rightPanel);
    }

    void stop() {
        if (this.tree == null) {
            return;
        }
        this.config = this.save();
        PanelManager panMan = this.plugin.getConsole().getPanelManager();
        panMan.removeListener(this);
        panMan.close(Collections.singletonMap(Panel.GROUP, "AlertsViewer"));
        this.clearAction = null;
        this.historyBox = null;
        this.muteBox = null;
        this.toFrontBox = null;
        this.tree = null;
        this.infoPanel = null;
        this.rightPanel = null;
        this.leftPanel = null;
    }

    public void onAlert(AlertEvent event) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.update(event);
        } else {
            SwingUtilities.invokeLater(() -> this.update(event));
        }
    }

    private void update(AlertEvent event) {
        IDNode idNode;
        String id;
        String source = event.getSource();
        RaisedAlertSummary summary = event.getSummary();
        if (summary == null) {
            AlertNode sourceNode;
            if (this.tree != null && (sourceNode = this.getSourceNode(source)) != null) {
                sourceNode.removeFromParent();
                this.tree.getModel().reload();
                this.tree.clearSelection();
            }
            return;
        }
        Set currentAlerts = summary.getAllRaisedAlertHistories();
        if (this.tree == null) {
            if (currentAlerts.isEmpty()) {
                return;
            }
            this.start();
        }
        TreePath selPath = this.tree.getSelectionPath();
        AlertNode sourceNode = this.getSourceNode(source);
        if (sourceNode == null) {
            if (currentAlerts.isEmpty()) {
                return;
            }
            sourceNode = new AlertNode(source);
            for (Object h2 : currentAlerts) {
                this.updateAlert(sourceNode, (RaisedAlertHistory)h2);
            }
            this.tree.getRoot().add(sourceNode);
        } else {
            HashMap id2history = new HashMap(currentAlerts.size() * 2);
            currentAlerts.forEach(h -> id2history.put(h.getLatestAlert().getAlertId(), h));
            for (IDNode idNode2 : sourceNode.getLeaves()) {
                id = idNode2.getID();
                RaisedAlertHistory history = (RaisedAlertHistory)id2history.remove(id);
                if (history == null) {
                    this.removeAlert(idNode2);
                    continue;
                }
                if (history.getLatestAlertCCSTimeStamp().getUTCInstant().compareTo(idNode2.getTimeStamp()) <= 0) continue;
                this.updateAlert(sourceNode, history);
            }
            for (RaisedAlertHistory h3 : id2history.values()) {
                this.updateAlert(sourceNode, h3);
            }
        }
        ArrayList<TreePath> state = TreeUtil.saveExpansionState(this.tree);
        this.tree.getModel().reload();
        TreeUtil.restoreExpansionState(this.tree, state);
        Alert alert = event.getAlert();
        TreePath path = alert == null ? new TreePath(new Object[]{this.tree.getRoot(), sourceNode}) : ((idNode = this.tree.findID(sourceNode, id = alert.getAlertId())) == null ? new TreePath(new Object[]{this.tree.getRoot(), sourceNode}) : new TreePath(idNode.getPath()));
        if (!this.selectNewBox.isSelected()) {
            path = selPath;
        }
        if (this.isValidPath(path)) {
            this.tree.setSelectionPath(path);
            this.tree.expandPath(path);
        } else {
            this.tree.clearSelection();
        }
        if (!this.muteBox.isSelected()) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.toFrontBox.isSelected()) {
            PanelManager panMan = this.plugin.getConsole().getPanelManager();
            panMan.set(this.leftPanel, Panel.SELECTED, true);
            panMan.set(this.rightPanel, Panel.SELECTED, true);
        }
    }

    @Override
    public void process(PanelEvent event) {
        if (event.hasKey(Panel.OPEN) && !((Boolean)event.getNewValue()).booleanValue()) {
            this.stop();
        }
    }

    private AlertNode getSourceNode(String source) {
        AlertNode root = this.tree.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            AlertNode node = root.getChildAt(i);
            if (!node.getUserObject().equals(source)) continue;
            return node;
        }
        return null;
    }

    private HashMap<String, String[]> getAlertMap(AlertNode node) {
        HashMap<String, String[]> alerts = new HashMap<String, String[]>();
        if (node instanceof IDNode) {
            IDNode idNode = (IDNode)node;
            alerts.put(node.getSource(), new String[]{idNode.getID()});
        } else if (node.isRoot()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                AlertNode sourceNode = (AlertNode)e.nextElement();
                alerts.put(sourceNode.getSource(), null);
            }
        } else if (node.getLevel() == 1) {
            alerts.put(node.getSource(), null);
        } else {
            String source = node.getSource();
            ArrayList<String> ids = new ArrayList<String>();
            Enumeration<TreeNode> e = node.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode o = e.nextElement();
                if (!(o instanceof IDNode)) continue;
                IDNode idNode = (IDNode)o;
                ids.add(idNode.getID());
            }
            alerts.put(source, ids.toArray(new String[0]));
        }
        return alerts;
    }

    public static String formatTimeStamp(Instant instant) {
        return Const.DEFAULT_DT_FORMAT.format(instant);
    }

    private static String toColoredString(String text, AlertState level) {
        if (text == null) {
            text = level.toString();
        }
        String color = ALCOLOR.get(level);
        return "<font color=" + color + ">" + text + "</font>";
    }

    private void updateAlert(AlertNode sourceNode, RaisedAlertHistory history) {
        String id = history.getLatestAlert().getAlertId();
        String[] ss = id.split("/");
        ArrayList<String> tokens = new ArrayList<String>(ss.length);
        for (String s : ss) {
            if ((s = s.trim()).isEmpty()) continue;
            tokens.add(s);
        }
        if (tokens.isEmpty()) {
            return;
        }
        for (int i = 0; i < tokens.size() - 1; ++i) {
            String s = (String)tokens.get(i);
            AlertNode tokenNode = null;
            Enumeration<TreeNode> e = sourceNode.children();
            while (e.hasMoreElements()) {
                AlertNode node = (AlertNode)e.nextElement();
                if (node.isLeaf() || !node.getUserObject().equals(s)) continue;
                tokenNode = node;
                break;
            }
            if (tokenNode == null) {
                tokenNode = new AlertNode(s);
                sourceNode.add(tokenNode);
            }
            sourceNode = tokenNode;
        }
        IDNode idNode = null;
        Enumeration<TreeNode> e = sourceNode.children();
        while (e.hasMoreElements()) {
            IDNode node;
            TreeNode o = e.nextElement();
            if (!(o instanceof IDNode) || !(node = (IDNode)o).getID().equals(id)) continue;
            idNode = node;
            break;
        }
        if (idNode == null) {
            idNode = new IDNode(history);
            sourceNode.add(idNode);
        } else {
            idNode.setHistory(history);
        }
    }

    private void removeAlert(IDNode idNode) {
        AlertNode node = idNode;
        AlertNode parent;
        while ((parent = node.getParent()) != null) {
            if (parent.isRoot() || parent.getChildCount() > 1) {
                node.removeFromParent();
                return;
            }
            node = parent;
        }
        return;
    }

    private boolean isValidPath(TreePath path) {
        if (path == null) {
            return false;
        }
        int n = path.getPathCount();
        if (n == 0) {
            return false;
        }
        AlertNode child = (AlertNode)path.getLastPathComponent();
        for (int i = n - 2; i >= 0; --i) {
            AlertNode parentFromPath = (AlertNode)path.getPathComponent(i);
            AlertNode parentFromChild = child.getParent();
            if (parentFromPath == null || parentFromChild == null || !parentFromPath.equals(parentFromChild)) {
                return false;
            }
            child = parentFromPath;
        }
        return child.equals(this.tree.getRoot());
    }

    Descriptor save() {
        if (this.rightPanel == null) {
            return this.config;
        }
        PanelManager panMan = this.plugin.getConsole().getPanelManager();
        Descriptor config = new Descriptor();
        config.setUndocked((Boolean)panMan.get((Component)this.rightPanel, Panel.DOCKED) == false);
        if (config.isUndocked()) {
            config.setIconized((Boolean)panMan.get((Component)this.rightPanel, Panel.ICONIZED));
            config.setSize((Dimension)panMan.get((Component)this.rightPanel, Panel.SIZE));
            config.setLocation((Point)panMan.get((Component)this.rightPanel, Panel.LOCATION));
            Object device = panMan.get((Component)this.rightPanel, Panel.DEVICE);
            if (device != null) {
                config.setDevice(device.toString());
            }
            config.setMaximized((Boolean)panMan.get((Component)this.rightPanel, Panel.MAXIMIZED));
        }
        return config;
    }

    static {
        ALCOLOR.put(AlertState.NOMINAL, "#00AA00");
        ALCOLOR.put(AlertState.WARNING, "#0000AA");
        ALCOLOR.put(AlertState.ALARM, "#AA0000");
        COLOR = new EnumMap(AlertState.class);
        COLOR.put(AlertState.NOMINAL, new Color(0, 170, 0));
        COLOR.put(AlertState.WARNING, new Color(0, 0, 170));
        COLOR.put(AlertState.ALARM, new Color(170, 0, 0));
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private boolean iconized;
        private boolean undocked;
        private Dimension size;
        private Point location;
        private String device;
        private boolean maximized;

        public boolean isIconized() {
            return this.iconized;
        }

        public void setIconized(boolean iconized) {
            this.iconized = iconized;
        }

        public boolean isUndocked() {
            return this.undocked;
        }

        public void setUndocked(boolean undocked) {
            this.undocked = undocked;
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension size) {
            this.size = size;
        }

        public Point getLocation() {
            return this.location;
        }

        public void setLocation(Point location) {
            this.location = location;
        }

        public String getDevice() {
            return this.device;
        }

        public void setDevice(String device) {
            this.device = device;
        }

        public boolean isMaximized() {
            return this.maximized;
        }

        public void setMaximized(boolean maximized) {
            this.maximized = maximized;
        }
    }

    private static class AlertTreeRenderer
    extends DefaultTreeCellRenderer {
        private AlertTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            try {
                AlertNode node = (AlertNode)value;
                AlertState state = node.getAlertLevel();
                if (!sel) {
                    this.setForeground((Color)COLOR.get(state));
                }
                if (leaf) {
                    this.setToolTipText(((IDNode)node).getHistory().getLatestAlert().getDescription());
                } else {
                    this.setToolTipText(null);
                }
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
            return this;
        }
    }

    final class IDNode
    extends AlertNode {
        private RaisedAlertHistory history;

        IDNode(RaisedAlertHistory history) {
            super(history.getLatestAlert().getAlertId());
            this.setHistory(history);
        }

        void setHistory(RaisedAlertHistory history) {
            this.history = history;
        }

        RaisedAlertHistory getHistory() {
            return this.history;
        }

        String getID() {
            return this.getUserObject();
        }

        @Override
        public String toString() {
            return this.getLastIdComponent();
        }

        String getLastIdComponent() {
            String[] ss = this.getID().split("/");
            int i = ss.length;
            while (i > 0) {
                String s;
                if ((s = ss[--i].trim()).isEmpty()) continue;
                return s;
            }
            return this.getID();
        }

        @Override
        String getInfo() {
            Alert alert = this.history.getLatestAlert();
            StringBuilder sb = new StringBuilder();
            sb.append("<html>Source: <b>").append(this.getSource()).append("</b><br>");
            sb.append("ID: <b>").append(alert.getAlertId()).append("</b><br>");
            sb.append("Description: <b>").append(alert.getDescription()).append("</b><br>");
            sb.append("Highest level: <b>").append(AlertViewer.toColoredString(null, this.history.getHighestAlertState())).append("</b><p>");
            ArrayList alerts = this.history.getRaisedAlertInstancesList();
            if (AlertViewer.this.historyBox.isSelected()) {
                sb.append("<b>History:</b><p>");
                int n = alerts.size();
                int nShow = Math.min(n, 50);
                for (int i = 0; i < nShow; ++i) {
                    RaisedAlertInstance ra = (RaisedAlertInstance)alerts.get(n - 1 - i);
                    sb.append(AlertViewer.toColoredString(AlertViewer.formatTimeStamp(ra.getCCSTimeStamp().getUTCInstant()) + " " + ra.getAlertState(), ra.getAlertState())).append(":<br>");
                    sb.append(ra.getCause()).append("<p>");
                }
                if (nShow < n) {
                    if (nShow < n - 1) {
                        sb.append("<p>...<p>").append(n - nShow - 1).append(" more").append("<p>...<p>");
                    }
                    RaisedAlertInstance ra = (RaisedAlertInstance)alerts.get(0);
                    sb.append(AlertViewer.toColoredString(AlertViewer.formatTimeStamp(ra.getCCSTimeStamp().getUTCInstant()) + " " + ra.getAlertState(), ra.getAlertState())).append(":<br>");
                    sb.append(ra.getCause()).append("<p>");
                }
            } else {
                int n = alerts.size();
                if (n > 1) {
                    sb.append("<b>Current level: ").append(AlertViewer.formatTimeStamp(this.history.getLatestAlertCCSTimeStamp().getUTCInstant())).append(" : ").append(AlertViewer.toColoredString(null, this.history.getLatestAlertState())).append("</b><br>");
                    sb.append(((RaisedAlertInstance)alerts.get(n - 1)).getCause()).append("<p>");
                    RaisedAlertInstance first = (RaisedAlertInstance)alerts.get(0);
                    sb.append("<b>First raised: ").append(AlertViewer.formatTimeStamp(first.getCCSTimeStamp().getUTCInstant())).append(" : ").append(AlertViewer.toColoredString(null, first.getAlertState())).append("</b><br>");
                    sb.append(first.getCause());
                } else if (n > 0) {
                    sb.append("<b>Raised: ").append(AlertViewer.formatTimeStamp(this.history.getLatestAlertCCSTimeStamp().getUTCInstant())).append(" : ").append(AlertViewer.toColoredString(null, this.history.getLatestAlertState())).append("</b><br>");
                    sb.append(((RaisedAlertInstance)alerts.get(0)).getCause());
                }
            }
            return sb.append("</html>").toString();
        }

        @Override
        Instant getTimeStamp() {
            return this.history.getLatestAlertCCSTimeStamp().getUTCInstant();
        }

        @Override
        AlertState getAlertLevel() {
            return this.history.getHighestAlertState();
        }
    }

    static class AlertNode
    extends DefaultMutableTreeNode
    implements Comparable<AlertNode> {
        private boolean mute;
        private boolean ignore;

        AlertNode(String userObject) {
            super(userObject);
        }

        @Override
        public String getUserObject() {
            return (String)super.getUserObject();
        }

        @Override
        public int compareTo(AlertNode other) {
            return this.getUserObject().compareTo(other.getUserObject());
        }

        @Override
        public void add(MutableTreeNode newChildNode) {
            AlertNode newChild = (AlertNode)newChildNode;
            Enumeration<TreeNode> e = this.children();
            int i = 0;
            boolean replace = false;
            while (e.hasMoreElements()) {
                AlertNode child = (AlertNode)e.nextElement();
                int c = newChild.compareTo(child);
                if (c > 0) {
                    ++i;
                    continue;
                }
                if (c != 0) break;
                replace = true;
                break;
            }
            if (replace) {
                this.remove(i);
            }
            this.insert(newChild, i);
        }

        @Override
        public AlertNode getParent() {
            return (AlertNode)super.getParent();
        }

        @Override
        public AlertNode getChildAt(int index) {
            return (AlertNode)super.getChildAt(index);
        }

        public ArrayList<IDNode> getLeaves() {
            ArrayList<IDNode> out = new ArrayList<IDNode>(this.getLeafCount());
            Enumeration<TreeNode> e = this.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                if (!(node instanceof IDNode)) continue;
                out.add((IDNode)node);
            }
            return out;
        }

        String getInfo() {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>Source: <b>").append(this.getSource()).append("</b><br>");
            sb.append("Alerts selected: <b>").append(this.getLeafCount()).append("</b><br>");
            sb.append("Highest alert level: <b>").append(AlertViewer.toColoredString(null, this.getAlertLevel())).append("</b><br>");
            sb.append("Last changed at <b>").append(Const.DEFAULT_DT_FORMAT.format(this.getTimeStamp())).append("</b></html>");
            return sb.toString();
        }

        String getSource() {
            int level = this.getLevel();
            if (level > 1) {
                return this.getParent().getSource();
            }
            return this.getUserObject();
        }

        Instant getTimeStamp() {
            Instant out = Instant.EPOCH;
            if (this.children != null) {
                for (Object child : this.children) {
                    Instant time = ((AlertNode)child).getTimeStamp();
                    if (time.compareTo(out) <= 0) continue;
                    out = time;
                }
            }
            return out;
        }

        AlertState getAlertLevel() {
            AlertState childState;
            AlertState alertState = AlertState.NOMINAL;
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements() && ((childState = ((AlertNode)e.nextElement()).getAlertLevel()).compareTo((Enum)alertState) <= 0 || !(alertState = childState).equals((Object)AlertState.ALARM))) {
            }
            return alertState;
        }

        WatchState getWatchState() {
            WatchState thisState;
            WatchState watchState = this.isIgnore() ? WatchState.IGNORE : (thisState = this.isMute() ? WatchState.MUTE : WatchState.ACTIVE);
            if (thisState == WatchState.IGNORE) {
                return WatchState.IGNORE;
            }
            WatchState parentState = this.getParent().getWatchState();
            return thisState.compareTo(parentState) == -1 ? parentState : thisState;
        }

        boolean isMute() {
            return this.mute;
        }

        void setMute(boolean isMute) {
            this.mute = isMute;
        }

        boolean isIgnore() {
            return this.ignore;
        }

        void setIgnore(boolean isIgnored) {
            this.ignore = isIgnored;
        }
    }

    private static class AlertTreeModel
    extends DefaultTreeModel {
        AlertTreeModel() {
            super(new AlertNode("CCS Alerts"){

                @Override
                WatchState getWatchState() {
                    return this.isIgnore() ? WatchState.IGNORE : (this.isMute() ? WatchState.MUTE : WatchState.ACTIVE);
                }

                @Override
                String getInfo() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>CCS Control System</b><p>");
                    int activeAlerts = 0;
                    if (this.children != null) {
                        for (Object child : this.children) {
                            if (((AlertNode)child).getAlertLevel() == AlertState.NOMINAL) continue;
                            ++activeAlerts;
                        }
                    }
                    sb.append("Subsystems with active alerts: <b>").append(activeAlerts).append("</b><br>");
                    sb.append("Overall alert level: <b>").append(this.getAlertLevel()).append("</b><br>");
                    sb.append("Last changed at <b>").append(Const.DEFAULT_DT_FORMAT.format(this.getTimeStamp())).append("</b></html>");
                    return sb.toString();
                }

                @Override
                String getSource() {
                    throw new UnsupportedOperationException("Trying to look up source subsystem for the root node.");
                }
            });
        }

        @Override
        public AlertNode getRoot() {
            return (AlertNode)super.getRoot();
        }
    }

    private static class AlertTree
    extends JTree {
        private AlertTree() {
        }

        static AlertTree getInstance() {
            AlertTree t = new AlertTree();
            t.setModel(new AlertTreeModel());
            t.getSelectionModel().setSelectionMode(1);
            t.setCellRenderer(new AlertTreeRenderer());
            ToolTipManager.sharedInstance().registerComponent(t);
            return t;
        }

        public AlertNode getSelectedNode() {
            return (AlertNode)this.getLastSelectedPathComponent();
        }

        @Override
        public AlertTreeModel getModel() {
            return (AlertTreeModel)super.getModel();
        }

        AlertNode getRoot() {
            return this.getModel().getRoot();
        }

        IDNode findID(AlertNode sourceNode, String id) {
            if (sourceNode == null) {
                return null;
            }
            Enumeration<TreeNode> e = sourceNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                if (!(node instanceof IDNode) || !((IDNode)node).getID().equals(id)) continue;
                return (IDNode)node;
            }
            return null;
        }
    }

    private static enum WatchState {
        ACTIVE,
        MUTE,
        IGNORE;

    }
}

