package org.lsst.ccs.subsystem.demo.main.device;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.demo.DemoDriver;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.common.service.DataAccumulationService;


/**
 * Monitoring Device. It publishes a metadata called 'devicemetadata' at its
 * level, that will therefore be associated to all its channels.
 *
 * @author turri
 */
public class IonPumps extends Device {
    
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dataProviderDictionaryService;

    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataAccumulationService dataAccumulationService;

    private DemoDriver driver;
    private final String id;
    private final Random r = new Random();
    private int meta;
    
    @LookupPath
    private String path;

    public IonPumps(String id) {
        this.id = id;
        DataAccumulationService.isNeeded();
    }

    public String getId() {
        return id;
    }
    
    @Override
    protected int[] checkChannel(Channel ch) throws Exception {
        if (ch.getHwChan() == 20 ) {
            dataAccumulationService.registerAccumulatedDataPath(ch.getPath());
        }
        return super.checkChannel(ch);
    }

    
    
    
    @Override
    protected void initialize() {
        if (driver == null) {
            try {
                driver = new DemoDriver();
            } catch (DriverException ex) {
                Logger.getLogger(IonPumps.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        setOnline(true);
    }

    @Override
    protected void close() {
        if (driver != null) {
            try {
                driver.close();
                driver = null;
            } catch (DriverException ex) {
                Logger.getLogger(IonPumps.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    protected double readChannel(Channel ch) {
        int chan = ch.getHwChan();
        if (chan < 10) {
            return r.nextGaussian()*.5 + chan;
        } else {
            if ( chan == 20 ) {
                return dataAccumulationService.accumulateData(ch.getPath(), r.nextDouble());
            }
            return r.nextGaussian()*10 + (chan%10)*1000;
        }
    }
    
}
