/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.ExtendedStatistics;
import jas.hist.HasDataSource;
import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.JASHistUtil;
import jas.hist.OneDOverlay;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;
import jas.hist.XMLPrintWriter;
import jas.hist.XYDataSource;
import jas.plot.Overlay;
import jas.util.ColorConverter;
import jas.util.xml.HasXMLRepresentation;
import java.io.Serializable;
import java.util.Observable;

class JASHist1DHistogramData
extends JASHistData {
    private DataSource dataSource;
    JASHist1DHistogramStyle style;
    private boolean hurry;
    private boolean isBinned = false;
    private boolean yLimitsValid = false;
    private boolean xLimitsValid = false;
    private double[] data;
    private double[] dataX;
    private double[] plusError;
    private double[] minusError;
    private int xBins;
    private double xMin;
    private double xMax;
    private double xLow;
    private double xHigh;
    private double yLow;
    private double yHigh;
    private double xNearLow;
    private double xNearHigh;
    private double yNearLow;
    private double yNearHigh;
    private static final HistogramUpdate hu = new HistogramUpdate(2, true);
    static final long serialVersionUID = -3529869583896718619L;
    private FittableDataSource fittableDataSource = new FittableDataSource();

    JASHist1DHistogramData(DataManager dm, DataSource ds) {
        super(dm);
        this.dataSource = ds;
        this.initTransientData();
        JASHistStyle s = null;
        if (ds instanceof HasStyle) {
            s = ((HasStyle)((Object)ds)).getStyle();
        }
        if (s == null) {
            s = new JASHist1DHistogramStyle();
        }
        this.setStyle(s);
        String property = System.getProperty("hurry", "false");
        this.hurry = property != null && property.equalsIgnoreCase("true");
    }

    private void initTransientData() {
        this.yLimitsValid = false;
        this.isBinned = false;
    }

    @Override
    public void setStyle(JASHistStyle style) {
        if (!(style instanceof JASHist1DHistogramStyle)) {
            throw new IllegalArgumentException("Style is not subclass of JASHist1DHistogramStyle");
        }
        if (this.style != null) {
            this.style.deleteObserver(this);
        }
        this.style = (JASHist1DHistogramStyle)style;
        this.style.addObserver(this);
    }

    @Override
    public String getTitle() {
        return this.dataSource.getTitle();
    }

    String[] getAxisLabels() {
        return this.dataSource instanceof Rebinnable1DHistogramData ? ((Rebinnable1DHistogramData)this.dataSource).getAxisLabels() : null;
    }

    @Override
    Overlay createOverlay() {
        return new OneDOverlay(this);
    }

    @Override
    void writeAsXML(XMLPrintWriter pw, boolean snapshot) {
        pw.setAttribute("axis", "y" + this.getYAxis());
        pw.openTag("data1d");
        String theAxisType = XMLPrintWriter.convertAxisTypeToString(this.getAxisType());
        if (snapshot) {
            Statistics stats;
            if (this.dataSource instanceof Rebinnable1DHistogramData) {
                pw.setAttribute("title", this.getTitle());
                pw.openTag("bins1d");
                for (int i = 0; i < this.data.length; ++i) {
                    pw.print(this.data[i]);
                    pw.print(",");
                    pw.print(this.plusError[i]);
                    pw.print(",");
                    pw.print(this.minusError[i]);
                    pw.println();
                }
                pw.closeTag();
                pw.printBinnedDataAxisAttributes("x", "" + this.xLow, "" + this.xHigh, "" + this.xBins, theAxisType);
                if (theAxisType.equals("string")) {
                    pw.setAttribute("type", "x0");
                    pw.openTag("axisLabels");
                    String[] labels = this.getAxisLabels();
                    for (int i = 0; i < labels.length; ++i) {
                        pw.setAttribute("value", labels[i]);
                        pw.printTag("axisLabel");
                    }
                    pw.closeTag();
                }
            } else {
                pw.setAttribute("title", this.getTitle());
                pw.openTag("points");
                for (int i = 0; i < this.data.length; ++i) {
                    pw.print(this.dataX[i]);
                    pw.print(44.0);
                    pw.print(this.data[i]);
                    pw.print(44.0);
                    pw.print(this.plusError[i]);
                    pw.print(44.0);
                    pw.print(this.minusError[i]);
                    pw.println();
                }
                pw.closeTag();
                pw.setAttribute("axis", "x");
                pw.setAttribute("type", theAxisType);
                pw.printTag("pointDataAxisAttributes");
            }
            if (this.dataSource instanceof HasStatistics && (stats = ((HasStatistics)((Object)this.dataSource)).getStatistics()) != null) {
                pw.openTag("statistics");
                String[] names = stats.getStatisticNames();
                for (int i = 0; i < names.length; ++i) {
                    Object value;
                    String name = names[i];
                    pw.setAttribute("name", name);
                    String valueString = null;
                    if (stats instanceof ExtendedStatistics && (value = ((ExtendedStatistics)stats).getExtendedStatistic(name)) != null) {
                        valueString = value.toString();
                    }
                    if (valueString == null) {
                        valueString = String.valueOf(stats.getStatistic(name));
                    }
                    pw.setAttribute("value", valueString);
                    pw.printTag("statistic");
                }
                pw.closeTag();
            }
        } else if (this.dataSource instanceof HasXMLRepresentation) {
            ((HasXMLRepresentation)((Object)this.dataSource)).writeAsXML(pw);
        } else {
            if (this.dataSource instanceof HasDataSource) {
                pw.setAttribute("name", this.dataSource.getClass().getName());
            } else {
                pw.setAttribute("name", "???");
            }
            pw.setAttribute("param", "???");
            pw.printTag("class");
        }
        pw.setAttribute("histogramBarsFilled", this.style.getHistogramFill());
        pw.setAttribute("histogramBarColor", ColorConverter.colorToString(this.style.getHistogramBarColor()));
        pw.setAttribute("errorBarColor", ColorConverter.colorToString(this.style.getErrorBarColor()));
        pw.setAttribute("dataPointColor", ColorConverter.colorToString(this.style.getDataPointColor()));
        pw.setAttribute("dataPointStyle", XMLPrintWriter.convertStyleToString(this.style.getDataPointStyle()));
        pw.setAttribute("dataPointSize", this.style.getDataPointSize());
        pw.setAttribute("lineColor", ColorConverter.colorToString(this.style.getLineColor()));
        pw.setAttribute("showHistogramBars", this.style.getShowHistogramBars());
        pw.setAttribute("showErrorBars", this.style.getShowErrorBars());
        pw.setAttribute("showDataPoints", this.style.getShowDataPoints());
        pw.setAttribute("showLinesBetweenPoints", this.style.getShowLinesBetweenPoints());
        pw.printTag("style1d");
        pw.closeTag();
    }

    boolean isRebinnable() {
        return this.dataSource instanceof Rebinnable1DHistogramData ? ((Rebinnable1DHistogramData)this.dataSource).isRebinnable() : false;
    }

    double getXMin() {
        if (this.dataSource instanceof Rebinnable1DHistogramData) {
            return ((Rebinnable1DHistogramData)this.dataSource).getMin();
        }
        if (!this.xLimitsValid) {
            this.calcXLimits();
        }
        return this.xMin;
    }

    double getXMax() {
        if (this.dataSource instanceof Rebinnable1DHistogramData) {
            return ((Rebinnable1DHistogramData)this.dataSource).getMax();
        }
        if (!this.xLimitsValid) {
            this.calcXLimits();
        }
        return this.xMax;
    }

    void setXRange(int xBins, double xLow, double xHigh) {
        if (this.isRebinnable()) {
            if (xBins != this.xBins || xLow != this.xLow || xHigh != this.xHigh) {
                this.xBins = xBins;
                this.isBinned = false;
            }
        } else if (this.dataSource instanceof Rebinnable1DHistogramData) {
            this.xBins = ((Rebinnable1DHistogramData)this.dataSource).getBins();
        }
        this.yLimitsValid = false;
        this.xLow = xLow;
        this.xHigh = xHigh;
    }

    private void doXYBin() {
        this.isBinned = true;
        XYDataSource xy = (XYDataSource)this.dataSource;
        int n = xy.getNPoints();
        this.dataX = new double[n];
        this.data = new double[n];
        this.plusError = new double[n];
        this.minusError = new double[n];
        for (int i = 0; i < n; ++i) {
            this.dataX[i] = xy.getX(i);
            this.data[i] = xy.getY(i);
            this.plusError[i] = xy.getPlusError(i);
            this.minusError[i] = xy.getMinusError(i);
        }
        if (this.normalization != null) {
            double factor = 1.0 / this.normalization.getNormalizationFactor();
            double[] normalizedData = new double[n];
            double[] normalizedPlusError = new double[n];
            double[] normalizedMinusError = new double[n];
            for (int i = 0; i < n; ++i) {
                normalizedData[i] = this.data[i] * factor;
                normalizedPlusError[i] = this.plusError[i] * factor;
                normalizedMinusError[i] = this.minusError[i] * factor;
            }
            if (this.overlay instanceof OneDOverlay) {
                ((OneDOverlay)this.overlay).setData(this.dataX, normalizedData, normalizedPlusError, normalizedMinusError);
            }
        } else if (this.overlay instanceof OneDOverlay) {
            ((OneDOverlay)this.overlay).setData(this.dataX, this.data, this.plusError, this.minusError);
        }
    }

    private void doBin() {
        if (this.dataSource instanceof XYDataSource) {
            this.doXYBin();
        } else {
            double xh;
            double xl;
            int type = this.getAxisType();
            String[] labels = null;
            if (type == 2) {
                labels = this.getAxisLabels();
                this.xBins = labels.length;
                xl = 0.0;
                xh = labels.length;
            } else if (this.isRebinnable()) {
                xl = this.xLow;
                xh = this.xHigh;
            } else {
                xl = ((Rebinnable1DHistogramData)this.dataSource).getMin();
                xh = ((Rebinnable1DHistogramData)this.dataSource).getMax();
            }
            this.isBinned = true;
            double[][] result = ((Rebinnable1DHistogramData)this.dataSource).rebin(this.xBins, xl, xh, true, this.hurry);
            if (result == null) {
                result = new double[1][this.xBins];
            }
            this.data = result[0];
            if (this.data.length != this.xBins) {
                System.err.println("Warning xbins=" + this.xBins + " data.length=" + this.data.length);
            }
            if (result.length > 1) {
                this.plusError = result[1];
                this.minusError = result.length > 2 ? result[2] : this.plusError;
            } else {
                this.plusError = new double[this.xBins];
                for (int i = 0; i < this.xBins; ++i) {
                    this.plusError[i] = Math.sqrt(Math.abs(this.data[i]));
                }
                this.minusError = this.plusError;
            }
            if (this.plusError.length != this.xBins) {
                System.err.println("Warning xbins=" + this.xBins + " plusError.length=" + this.plusError.length);
            }
            if (this.minusError.length != this.xBins) {
                System.err.println("Warning xbins=" + this.xBins + " minusError.length=" + this.minusError.length);
            }
            if (this.normalization != null) {
                double factor = 1.0 / this.normalization.getNormalizationFactor();
                double[] normalizedData = new double[this.xBins];
                double[] normalizedPlusError = new double[this.xBins];
                double[] normalizedMinusError = new double[this.xBins];
                for (int i = 0; i < this.data.length; ++i) {
                    normalizedData[i] = this.data[i] * factor;
                    normalizedPlusError[i] = this.plusError[i] * factor;
                    normalizedMinusError[i] = this.minusError[i] * factor;
                }
                if (this.overlay instanceof OneDOverlay) {
                    if (type == 2) {
                        ((OneDOverlay)this.overlay).setData(normalizedData, normalizedPlusError, normalizedMinusError, labels);
                    } else {
                        ((OneDOverlay)this.overlay).setData(normalizedData, normalizedPlusError, normalizedMinusError, xl, xh);
                    }
                }
            } else if (this.overlay instanceof OneDOverlay) {
                if (type == 2) {
                    ((OneDOverlay)this.overlay).setData(this.data, this.plusError, this.minusError, labels);
                } else {
                    ((OneDOverlay)this.overlay).setData(this.data, this.plusError, this.minusError, xl, xh);
                }
            }
        }
    }

    private void calcXLimits() {
        this.xLimitsValid = true;
        XYDataSource xy = (XYDataSource)this.dataSource;
        int n = xy.getNPoints();
        if (n == 0) {
            this.xMin = Double.NaN;
            this.xMax = Double.NaN;
        } else {
            this.xMin = Double.MAX_VALUE;
            this.xMax = -1.7976931348623157E308;
            for (int i = 0; i < n; ++i) {
                double x = xy.getX(i);
                if (x < this.xMin) {
                    this.xMin = x;
                }
                if (!(x > this.xMax)) continue;
                this.xMax = x;
            }
            if (this.xMin > this.xMax) {
                this.xMin = 0.0;
                this.xMax = 1.0;
            } else {
                double delta = (this.xMax - this.xMin) / 25.0;
                this.xMin -= delta;
                this.xMax += delta;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void calcYLimits() {
        if (!this.isBinned) {
            if (this.dataSource instanceof XYDataSource) {
                this.doXYBin();
            } else {
                this.doBin();
            }
            this.fittableDataSource.binningChanged();
        }
        this.yLimitsValid = true;
        nGoodPoints = 0;
        this.yLow = 1.7976931348623157E308;
        this.yHigh = -1.7976931348623157E308;
        this.yNearLow = 1.7976931348623157E308;
        this.yNearHigh = -1.7976931348623157E308;
        this.xNearLow = -1.7976931348623157E308;
        this.xNearHigh = 1.7976931348623157E308;
        iNearLow = -1;
        iNearHigh = -1;
        ndp = -1;
        dm = 0.0;
        dp = 0.0;
        eb = this.style.getShowErrorBars();
        if (this.isRebinnable()) ** GOTO lbl-1000
        if (this.getAxisType() != 2) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = fixed = false;
        }
        if (this.dataSource instanceof Rebinnable1DHistogramData) {
            x = this.getXMin();
            bw = (this.getXMax() - this.getXMin()) / (double)this.xBins;
            ndp = this.xBins;
            for (i = 0; i < this.xBins; ++i) {
                if (fixed) {
                    xBinMin = x;
                    xBinMax = x += bw;
                    if (xBinMax < this.xLow) {
                        if (!(x > this.xNearLow)) continue;
                        this.xNearLow = x;
                        iNearLow = i;
                        continue;
                    }
                    if (xBinMin > this.xHigh) {
                        if (!(x < this.xNearHigh)) continue;
                        this.xNearHigh = x;
                        iNearHigh = i;
                        continue;
                    }
                }
                if (Double.isNaN(d = this.data[i])) continue;
                ++nGoodPoints;
                this.yLow = Math.min(this.yLow, d - (eb != false ? this.minusError[i] : 0.0));
                this.yHigh = Math.max(this.yHigh, d + (eb != false ? this.plusError[i] : 0.0));
            }
        } else {
            ndp = this.dataX.length;
            for (i = 0; i < this.dataX.length; ++i) {
                x = this.dataX[i];
                d = this.data[i];
                if (Double.isNaN(d)) continue;
                if (x < this.xLow) {
                    if (!(x > this.xNearLow)) continue;
                    this.xNearLow = x;
                    iNearLow = i;
                    continue;
                }
                if (x > this.xHigh) {
                    if (!(x < this.xNearHigh)) continue;
                    this.xNearHigh = x;
                    iNearHigh = i;
                    continue;
                }
                ++nGoodPoints;
                this.yLow = Math.min(this.yLow, d - (eb != false ? this.minusError[i] : 0.0));
                this.yHigh = Math.max(this.yHigh, d + (eb != false ? this.plusError[i] : 0.0));
            }
            delta = (this.yHigh - this.yLow) / 25.0;
            if (delta == 0.0) {
                delta = 1.0;
            }
            this.yLow -= delta;
            this.yHigh += delta;
        }
        if (iNearHigh < 0 && iNearLow < 0 && nGoodPoints == 0) {
            this.yLow = 0.0;
            this.yHigh = 1.0;
        } else if (nGoodPoints == 0) {
            if (iNearLow >= 0) {
                d = this.data[iNearLow];
                dm = d - (eb != false ? this.minusError[iNearLow] : 0.0);
                dp = d + (eb != false ? this.minusError[iNearLow] : 0.0);
                if (dm < this.yNearLow) {
                    this.yNearLow = dm;
                }
                if (dp > this.yNearHigh) {
                    this.yNearHigh = dp;
                }
            }
            if (iNearHigh >= 0) {
                d = this.data[iNearHigh];
                dm = d - (eb != false ? this.minusError[iNearHigh] : 0.0);
                dp = d + (eb != false ? this.minusError[iNearHigh] : 0.0);
                if (dm < this.yNearLow) {
                    this.yNearLow = dm;
                }
                if (dp > this.yNearHigh) {
                    this.yNearHigh = dp;
                }
            }
            this.yLow = this.yNearLow;
            this.yHigh = this.yNearHigh;
        }
        if (iNearHigh < 0 && iNearLow < 0 && nGoodPoints == 0) {
            this.yLow = 0.0;
            this.yHigh = 1.0;
        } else if (nGoodPoints == 0) {
            if (iNearLow >= 0) {
                d = this.data[iNearLow];
                dm = d - (eb != false ? this.minusError[iNearLow] : 0.0);
                dp = d + (eb != false ? this.minusError[iNearLow] : 0.0);
                if (dm < this.yNearLow) {
                    this.yNearLow = dm;
                }
                if (dp > this.yNearHigh) {
                    this.yNearHigh = dp;
                }
            }
            if (iNearHigh >= 0) {
                d = this.data[iNearHigh];
                dm = d - (eb != false ? this.minusError[iNearHigh] : 0.0);
                dp = d + (eb != false ? this.minusError[iNearHigh] : 0.0);
                if (dm < this.yNearLow) {
                    this.yNearLow = dm;
                }
                if (dp > this.yNearHigh) {
                    this.yNearHigh = dp;
                }
            }
            this.yLow = this.yNearLow;
            this.yHigh = this.yNearHigh;
        } else if (this.normalization != null) {
            factor = 1.0 / this.normalization.getNormalizationFactor();
            this.yLow *= factor;
            this.yHigh *= factor;
        }
        this.yLow = JASHistUtil.roundDown(this.yLow, 2);
        this.yHigh = JASHistUtil.roundUp(this.yHigh, 2);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.dataSource) {
            HistogramUpdate hu = (HistogramUpdate)arg;
            this.isBinned = false;
            this.yLimitsValid = false;
            this.xLimitsValid = false;
            this.parent.update(hu, this);
        } else if (o == this.style) {
            this.yLimitsValid = false;
            this.parent.styleUpdate(this);
        } else if (o == this.normalization) {
            this.normalizationChanged(false);
        }
    }

    @Override
    void normalizationChanged(boolean now) {
        HistogramUpdate hu = new HistogramUpdate(2, now);
        if (!this.isBinned || this.countObservers() == 0) {
            this.fittableDataSource.update(hu);
        }
        this.isBinned = false;
        this.yLimitsValid = false;
        this.parent.update(hu, this);
    }

    @Override
    public boolean hasChanged() {
        return !this.isBinned;
    }

    double getYMin() {
        if (!this.yLimitsValid) {
            this.calcYLimits();
        }
        return this.yLow;
    }

    double getYMax() {
        if (!this.yLimitsValid) {
            this.calcYLimits();
        }
        return this.yHigh;
    }

    void validate() {
        if (!this.isBinned) {
            this.doBin();
        }
    }

    @Override
    void axisChanged() {
        this.parent.axisChanged(this);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public DataSource getFittableDataSource() {
        return this.fittableDataSource;
    }

    public boolean getBinnable() {
        return true;
    }

    public int getBins() {
        return this.dataSource instanceof Rebinnable1DHistogramData ? ((Rebinnable1DHistogramData)this.dataSource).getBins() : ((XYDataSource)this.dataSource).getNPoints();
    }

    int getAxisType() {
        if (this.dataSource instanceof Rebinnable1DHistogramData) {
            return ((Rebinnable1DHistogramData)this.dataSource).getAxisType();
        }
        return ((XYDataSource)this.dataSource).getAxisType();
    }

    @Override
    public JASHistStyle getStyle() {
        return this.style;
    }

    void destroy() {
        if (this.dataSource instanceof Observable) {
            ((Observable)((Object)this.dataSource)).deleteObserver(this);
        }
        this.style.deleteObserver(this);
        super.deleteNormalizationObserver();
    }

    class FittableDataSource
    extends Observable
    implements XYDataSource,
    Serializable {
        FittableDataSource() {
        }

        @Override
        public int getAxisType() {
            return 1;
        }

        @Override
        public String getTitle() {
            return JASHist1DHistogramData.this.dataSource.getTitle();
        }

        void update(Object obj) {
            this.setChanged();
            this.notifyObservers(obj);
        }

        void binningChanged() {
            this.setChanged();
            this.notifyObservers(hu);
        }

        JASHist1DHistogramData parent() {
            return JASHist1DHistogramData.this;
        }

        @Override
        public double getMinusError(int index) {
            return JASHist1DHistogramData.this.minusError[index];
        }

        @Override
        public double getPlusError(int index) {
            return JASHist1DHistogramData.this.plusError[index];
        }

        @Override
        public double getX(int index) {
            if (JASHist1DHistogramData.this.dataX != null) {
                return JASHist1DHistogramData.this.dataX[index];
            }
            double bw = (JASHist1DHistogramData.this.xHigh - JASHist1DHistogramData.this.xLow) / (double)JASHist1DHistogramData.this.xBins;
            return JASHist1DHistogramData.this.xLow + bw * (double)index + bw / 2.0;
        }

        @Override
        public double getY(int index) {
            return JASHist1DHistogramData.this.data[index];
        }

        @Override
        public int getNPoints() {
            if (JASHist1DHistogramData.this.data == null) {
                return 0;
            }
            return JASHist1DHistogramData.this.data.length;
        }

        public String toString() {
            return this.getTitle();
        }
    }
}

