/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.security.InvalidParameterException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.data.MonitorTask;

public class MonitorTaskControl
implements HasLifecycle {
    private static final String MON_UPDATE_TASK = "monitor-update";
    private static final String MON_CHECK_TASK = "monitor-check";
    private static final String MON_PUBLISH_TASK = "monitor-publish";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Monitor monitor;
    private final Map<String, MonitorTask> specialTaskMap = new TreeMap<String, MonitorTask>();
    private final Map<String, MonitorTask> deviceTaskMap = new HashMap<String, MonitorTask>();
    private String publishTaskPath;
    private String updateTaskPath;
    private boolean periodChanged = false;
    private boolean fastActive = false;
    private final Set<MonitorUpdateTask> updateTasks = new HashSet<MonitorUpdateTask>();
    private long endTime = 0L;
    private String tasksRoot;

    public static MonitorTaskControl createNode(Subsystem subsys, String name) {
        ComponentLookup lookupService = subsys.getComponentLookup();
        ComponentNode topNode = lookupService.getComponentNodeForObject((Object)subsys);
        MonitorTaskControl control = new MonitorTaskControl();
        ComponentNode controlNode = new ComponentNode(name, (Object)control);
        lookupService.addComponentNodeToLookup(topNode, controlNode);
        return control;
    }

    public void postInit() {
        List allTasks = this.periodicTaskService.getAgentPeriodicTaskNames();
        HashSet<String> checkTasks = new HashSet<String>();
        for (String taskPath : allTasks) {
            if (!taskPath.startsWith("monitor-check/")) continue;
            checkTasks.add(taskPath.substring(taskPath.indexOf(47) + 1));
        }
        int index = 0;
        for (String taskPath : allTasks) {
            if (!taskPath.startsWith("monitor-update/")) continue;
            String taskName = taskPath.substring(taskPath.indexOf(47) + 1);
            if (!checkTasks.contains(taskName)) {
                this.specialTaskMap.put(taskName, new MonitorTask(taskName, index++, this.getTaskUpdatePeriod(taskName)));
                continue;
            }
            this.deviceTaskMap.put(taskName, new MonitorTask(taskName, index++, this.getTaskUpdatePeriod(taskName)));
        }
        this.publishTaskPath = MON_PUBLISH_TASK + (String)(this.deviceTaskMap.isEmpty() ? "" : "/" + this.deviceTaskMap.keySet().iterator().next());
        this.updateTaskPath = MON_UPDATE_TASK + (String)(this.deviceTaskMap.isEmpty() ? "" : "/" + this.deviceTaskMap.keySet().iterator().next());
        this.tasksRoot = this.periodicTaskService.getAgentServiceName();
        for (String devcName : this.monitor.getDeviceNames()) {
            for (MonitorUpdateTask task : this.monitor.getMonitorUpdateTasksForDevice(this.monitor.getDevice(devcName))) {
                this.updateTasks.add(task);
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the monitor fast publish period")
    public synchronized void setFastPeriod(@Argument(description="The fast publish period (ms)") int period) {
        long fastPeriod = Math.max(0, period);
        this.endTime = System.currentTimeMillis() + fastPeriod;
        for (MonitorUpdateTask task : this.updateTasks) {
            task.forceDataPublicationForDuration(Duration.ofMillis(fastPeriod));
        }
        this.fastActive = fastPeriod > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the monitor publish period")
    public synchronized void setPublishPeriod(@Argument(description="The publish period (ms)") int period) {
        if (this.deviceTaskMap.isEmpty()) {
            this.configurationService.submitChange(this.tasksRoot + "/monitor-publish", "taskPeriodMillis", (Object)Duration.ofMillis(period).toMillis());
        } else {
            for (MonitorTask task : this.deviceTaskMap.values()) {
                this.configurationService.submitChange(this.tasksRoot + "/monitor-publish/" + task.getName(), "taskPeriodMillis", (Object)Duration.ofMillis(period).toMillis());
            }
        }
        Iterator<MonitorTask> iterator = this.specialTaskMap.values().iterator();
        while (iterator.hasNext()) {
            MonitorTask task;
            MonitorTask monitorTask = task = iterator.next();
            synchronized (monitorTask) {
                if (!task.isActive()) {
                    this.configurationService.submitChange(this.tasksRoot + "/monitor-publish/" + task.getName(), "taskPeriodMillis", (Object)Duration.ofMillis(period).toMillis());
                }
            }
        }
        this.configurationService.commitBulkChange();
        this.periodChanged = true;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the special monitor task names")
    public List<String> getTaskNames() {
        ArrayList<String> monTasks = new ArrayList<String>();
        monTasks.addAll(this.specialTaskMap.keySet());
        return monTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the period for a special monitor task")
    public void setTaskPeriod(@Argument(description="The task name") String taskName, @Argument(description="The task period (ms)") int period) {
        MonitorTask task;
        MonitorTask monitorTask = task = this.getTask(taskName);
        synchronized (monitorTask) {
            task.setPeriod(period);
            if (task.isActive()) {
                this.setTaskUpdatePeriod(taskName, period);
                this.setTaskPublishPeriod(taskName, period);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the active state for a special monitor task")
    public void setTaskActive(@Argument(description="The task name") String taskName, @Argument(description="Whether to make active") boolean active) {
        MonitorTask task;
        MonitorTask monitorTask = task = this.getTask(taskName);
        synchronized (monitorTask) {
            task.setActive(active);
            if (active) {
                int period = task.getPeriod();
                this.setTaskUpdatePeriod(taskName, period);
                this.setTaskPublishPeriod(taskName, period);
            } else {
                this.setTaskUpdatePeriod(taskName, this.getUpdatePeriod());
                this.setTaskPublishPeriod(taskName, this.getPublishPeriod());
            }
        }
    }

    public synchronized boolean hasPeriodChanged() {
        boolean changed = this.periodChanged || this.fastActive;
        this.periodChanged = false;
        this.fastActive = this.getFastPeriod() > 0;
        return changed;
    }

    public Map<String, MonitorTask> getMonitorTaskMap() {
        return this.specialTaskMap;
    }

    public int getPublishPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod(this.publishTaskPath).toMillis();
    }

    private int getUpdatePeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod(this.updateTaskPath).toMillis();
    }

    private int getTaskUpdatePeriod(String taskName) {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-update/" + taskName).toMillis();
    }

    private void setTaskUpdatePeriod(String taskName, int period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-update/" + taskName, Duration.ofMillis(period));
    }

    private void setTaskPublishPeriod(String taskName, int period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish/" + taskName, Duration.ofMillis(period));
    }

    private MonitorTask getTask(String taskName) {
        MonitorTask task = this.specialTaskMap.get(taskName);
        if (task == null) {
            throw new InvalidParameterException("Unknown monitor task name: " + taskName);
        }
        return task;
    }

    public int getFastPeriod() {
        return this.endTime == 0L ? 0 : Math.max(0, (int)(this.endTime - System.currentTimeMillis()));
    }
}

