/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.Properties;
import org.lsst.ccs.bus.annotations.DataAttributes;
import org.lsst.ccs.bus.annotations.DoNotTrend;
import org.lsst.ccs.bus.annotations.SkipEncoding;

public final class DistributionInfo
implements Serializable {
    private static final long serialVersionUID = 3563213329104789L;
    @SkipEncoding
    private final String project;
    @DoNotTrend
    @DataAttributes(description="The Version", units="unitless")
    private final String version;
    @SkipEncoding
    private final String buildNumber;
    @SkipEncoding
    private final String buildId;
    @SkipEncoding
    private final String buildUrl;
    @SkipEncoding
    private final String buildJdk;
    @SkipEncoding
    private final String sourceCodeUrl;
    @SkipEncoding
    private final String sourceCodeRevision;

    public DistributionInfo() {
        this(System.getProperties());
    }

    public DistributionInfo(Properties props) {
        this.project = props.getProperty("org.lsst.ccs.project", "");
        this.version = props.getProperty("org.lsst.ccs.project.version", "");
        this.buildNumber = props.getProperty("org.lsst.ccs.jenkins.build.number", "");
        this.buildId = props.getProperty("org.lsst.ccs.jenkins.build.id", "");
        this.buildUrl = props.getProperty("org.lsst.ccs.jenkins.build.url", "");
        this.buildJdk = props.getProperty("org.lsst.ccs.jenkins.build.jdk", "");
        this.sourceCodeUrl = props.getProperty("org.lsst.ccs.source.code.url", "");
        this.sourceCodeRevision = props.getProperty("org.lsst.ccs.source.code.revision", "");
    }

    public String getProject() {
        return this.project;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getBuildJdk() {
        return this.buildJdk;
    }

    public String getSourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public String getSourceCodeRevision() {
        return this.sourceCodeRevision;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tProject        : ").append(this.project).append("\n");
        sb.append("\tProject Version: ").append(this.version).append("\n");
        sb.append("\tBuild Number   : ").append(this.buildNumber).append("\n");
        sb.append("\tBuild Id       : ").append(this.buildId).append("\n");
        sb.append("\tBuild Url      : ").append(this.buildUrl).append("\n");
        sb.append("\tBuild Jdk      : ").append(this.buildJdk).append("\n");
        sb.append("\tSource Code Rev: ").append(this.sourceCodeRevision).append("\n");
        sb.append("\tSource Code Url: ").append(this.sourceCodeUrl).append("\n");
        return sb.toString();
    }
}

