/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.constraints;

import org.apache.commons.beanutils.MethodUtils;

public class Constraints {
    private Constraints() {
    }

    public static void check(Object value, String constraints) {
        if ("".equals(constraints = constraints.trim())) {
            return;
        }
        String[] split = constraints.split("\\.\\.");
        if (split.length != 2) {
            throw new IllegalArgumentException("Could not process constraint " + constraints);
        }
        Constraints.checkRange(value.getClass(), value, split[0], split[1]);
    }

    private static Object checkRange(Class thatClass, Object realValue, String lower, String upper) {
        try {
            Object realUpper = MethodUtils.invokeStaticMethod((Class)thatClass, (String)"valueOf", (Object)upper);
            Object realLower = MethodUtils.invokeStaticMethod((Class)thatClass, (String)"valueOf", (Object)lower);
            Comparable compValue = (Comparable)realValue;
            if (compValue.compareTo(realLower) >= 0 && compValue.compareTo(realUpper) <= 0) {
                return realValue;
            }
            throw new IllegalArgumentException(realValue + "not in range [" + realLower + ".." + realUpper + "]");
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("range " + lower + ".." + upper + " and value :" + realValue + " raises :" + exc);
        }
    }
}

