/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;

public class RemoteFileServer {
    private static final Logger LOG = Logger.getLogger(RemoteFileServer.class.getName());
    private static final Map<String, FileSystem> fileSystems = new ConcurrentHashMap<String, FileSystem>();
    private final String cacheName;

    public RemoteFileServer(String cacheName) {
        this.cacheName = cacheName;
        this.getFileSystem();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream(Path path, OpenOption ... options) throws IOException {
        try (InputStream in = Files.newInputStream(path, options);){
            LOG.log(Level.FINE, "Loading input stream {0} with options {1}", new Object[]{path, Arrays.asList(options)});
            InputStream inputStream = in;
            return inputStream;
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, "Did not find {0} with options {1}", new Object[]{path, Arrays.asList(options)});
            throw new IOException(x);
        }
    }

    public BufferedWriter getBufferedWriter(Path path, OpenOption ... options) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        LOG.log(Level.FINE, "Getting buffered writer {0} with options {1}", new Object[]{path, Arrays.asList(options)});
        return Files.newBufferedWriter(path, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getFileSystem(String cacheName) throws ConfigurationServiceException {
        Map<String, FileSystem> map = fileSystems;
        synchronized (map) {
            return fileSystems.computeIfAbsent(cacheName, k -> RemoteFileServer.createFileSystem(k));
        }
    }

    private static synchronized FileSystem createFileSystem(String cacheName) throws ConfigurationServiceException {
        try {
            LOG.log(Level.INFO, "Creating RemoteFileServer with cacheName {0}", cacheName);
            Properties bootstrapSystemProperties = BootstrapResourceUtils.getBootstrapSystemProperties();
            String uri = bootstrapSystemProperties.getProperty("org.lsst.ccs.config.remote.uri", "ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/");
            boolean cacheOnly = "true".equalsIgnoreCase(bootstrapSystemProperties.getProperty("org.lsst.ccs.config.remote.cacheOnly", "false"));
            URI restRootURI = new URI(uri);
            Path cacheDir = Paths.get(System.getProperty("user.home") + "/ccs/cache/" + cacheName, new String[0]);
            Files.createDirectories(cacheDir, new FileAttribute[0]);
            Map<String, Object> env = RestFileSystemOptions.builder().cacheLocation(cacheDir.toFile()).set(RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK).ignoreLockedCache(true).set(cacheOnly ? RestFileSystemOptions.CacheFallback.ALWAYS : RestFileSystemOptions.CacheFallback.OFFLINE).set(uri.contains("//lsst-camera-dev.slac.stanford.edu") ? RestFileSystemOptions.SSLOptions.TRUE : RestFileSystemOptions.SSLOptions.AUTO).build();
            return FileSystems.newFileSystem(restRootURI, env);
        }
        catch (IOException | URISyntaxException x) {
            throw new ConfigurationServiceException("Unable to create RestFileServerRemoteDAO", x);
        }
    }

    public FileSystem getFileSystem() {
        return RemoteFileServer.getFileSystem(this.cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<String, FileSystem> map = fileSystems;
        synchronized (map) {
            try {
                FileSystem fs = fileSystems.get(this.cacheName);
                if (fs != null && fs.isOpen()) {
                    fs.close();
                    fileSystems.remove(this.cacheName);
                }
            }
            catch (IOException x) {
                LOG.log(Level.WARNING, "Error while closing rest file system", x);
            }
        }
    }
}

