/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.config.CategoryDataChain;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationParameterTaggedValue;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.config.SingleCategoryTag;

public class ConfigurationLoadedData {
    public final Map<String, CategoryDataChain> categoryDataChainMap = new ConcurrentHashMap<String, CategoryDataChain>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCategoryDataChain(CategoryDataChain categoryDataChain) {
        String category = categoryDataChain.getCategory();
        Map<String, CategoryDataChain> map = this.categoryDataChainMap;
        synchronized (map) {
            this.categoryDataChainMap.put(category, categoryDataChain);
        }
    }

    public void putConfigurationLoadedData(ConfigurationLoadedData loadedData) {
        this.categoryDataChainMap.putAll(loadedData.categoryDataChainMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationDescription getConfigurationDescription() {
        Map<String, CategoryDataChain> map = this.categoryDataChainMap;
        synchronized (map) {
            ConfigurationDescription confDescription = new ConfigurationDescription(this.categoryDataChainMap.keySet());
            for (CategoryDataChain catDataChain : this.categoryDataChainMap.values()) {
                for (SingleCategoryTag tag : catDataChain.getSingleCategoryTagList()) {
                    confDescription.putSingleTagForCategory(catDataChain.getCategory(), tag, tag.getVersion());
                }
            }
            return confDescription;
        }
    }

    public final Set<String> getCategories() {
        return this.categoryDataChainMap.keySet();
    }

    public CategoryDataChain getLoadedDataForCategory(String category) {
        return this.categoryDataChainMap.get(category);
    }

    public ConfigurationView getConfigurationView() {
        ConfigurationView view = new ConfigurationView(this.getConfigurationDescription());
        for (CategoryDataChain catDataChain : this.categoryDataChainMap.values()) {
            Map<String, ConfigurationParameterTaggedValue> data = catDataChain.getConfigurationParameterTaggedValues();
            for (ConfigurationParameterTaggedValue taggedValue : data.values()) {
                view.putParameterValue(taggedValue.getParameterPath(), taggedValue.getParameterValue());
            }
        }
        return view;
    }
}

