/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida;

import hep.aida.IPlotter;
import hep.aida.IPlotterRegion;
import hep.aida.ref.plotter.DummyPlotter;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freehep.jas.extension.aida.AIDARegion;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;

public class AIDAPlotter
extends DummyPlotter
implements Runnable {
    private PlotFactory factory;
    private PlotPage page;
    private boolean show = false;
    private boolean isShowing = false;

    public AIDAPlotter(PlotFactory factory, PlotPage page) {
        this.factory = factory;
        this.page = page;
        this.destroyRegions();
        this.createRegion();
    }

    public void show() {
        this.show = true;
        AIDAPlotter.invokeOnSwingThread((Runnable)this);
    }

    public void hide() {
        this.show = false;
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        if (this.show != this.isShowing) {
            if (this.show) {
                this.page.showPage();
            } else {
                this.page.hidePage();
            }
            this.isShowing = this.show;
        } else if (this.show) {
            this.page.showPage();
        }
    }

    protected IPlotterRegion justCreateRegion(double x, double y, double width, double height) {
        CreateRegion cr = new CreateRegion(x, y, width, height, (IPlotter)this);
        AIDAPlotter.invokeOnSwingThread((Runnable)cr);
        return cr.getRegion();
    }

    public void destroyRegions() {
        AIDAPlotter.invokeOnSwingThread((Runnable)new DestroyRegions());
        super.destroyRegions();
    }

    public void writeToFile(String file, String type) throws IOException {
        this.writeToFile(file, type, System.getProperties());
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public JPanel panel() {
        return (JPanel)this.page;
    }

    private class DestroyRegions
    implements Runnable {
        private DestroyRegions() {
        }

        @Override
        public void run() {
            AIDAPlotter.this.page.clearRegions();
        }
    }

    private class CreateRegion
    implements Runnable {
        private double x;
        private double y;
        private double width;
        private double height;
        private IPlotterRegion region;
        private IPlotter plotter;

        CreateRegion(double x, double y, double width, double height, IPlotter plotter) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.plotter = plotter;
        }

        @Override
        public void run() {
            PlotRegion pg = AIDAPlotter.this.page.createRegion(this.x, this.y, this.width, this.height);
            this.region = new AIDARegion(AIDAPlotter.this.factory, pg, this.plotter);
        }

        IPlotterRegion getRegion() {
            return this.region;
        }
    }
}

