/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui.plugins;

import java.awt.Component;
import java.time.Duration;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.demo.gui.DemoConfigurableSubsystemParameterGenericGUI;
import org.lsst.ccs.utilities.logging.Logger;

@Plugin(name="Demo Configurable plugin", description="A Demo Configurable plugin")
public class DemoConfigurableSubsystemPlugin
extends ConsolePlugin
implements AgentPresenceListener,
StatusMessageListener {
    private DemoConfigurableSubsystemParameterGenericGUI page;
    private ConcurrentMessagingUtils cmu;

    public void initialize() {
        this.cmu = new ConcurrentMessagingUtils(this.getConsole().getMessagingAccess());
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.getName().equals("demo-configurable-subsystem")) continue;
            this.startConfiguration(agent.getName());
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.getName().equals("demo-configurable-subsystem")) continue;
            this.stopConfiguration();
        }
    }

    private void startConfiguration(String dest) {
        this.page = new DemoConfigurableSubsystemParameterGenericGUI(this.cmu, dest);
        SwingUtilities.invokeLater(() -> {
            try {
                ConfigurationInfo ci = (ConfigurationInfo)this.cmu.sendSynchronousCommand(new CommandRequest(dest, "getConfigurationInfo"), Duration.ofSeconds(5L));
                this.page.initializeWithConfigInfo(ci);
                PanelManager pm = this.getConsole().getPanelManager();
                pm.open((Component)this.page, "Demo Configurable Subsystem GUI");
                pm.addListener(e -> {
                    if (e.hasKey((Object)Panel.OPEN) && !((Boolean)e.getNewValue()).booleanValue()) {
                        this.stopConfiguration();
                    }
                });
                this.getConsole().getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageOrigin((String)dest).and(BusMessageFilterFactory.embeddedObjectClass(ConfigurationInfo.class)));
            }
            catch (Exception ex) {
                Logger.getLogger((String)"org.lsst.ccs.subsystem.demo.gui.plugins").error((Object)ex);
            }
        });
    }

    private void stopConfiguration() {
        this.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        this.getConsole().getPanelManager().close((Component)this.page);
        this.page = null;
    }

    public void onStatusMessage(StatusMessage msg) {
        this.page.updateWithConfigInfo(((StatusConfigurationInfo)msg).getConfigurationInfo().getLatestChanges());
    }
}

