/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import hep.aida.ref.plotter.style.editor.StyleEditorPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.freehep.swing.JSpinBox;

public class ConfigurePreviewPanel
extends JPanel {
    protected Logger styleLogger = Logger.getLogger("hep.aida.ref.plotter.style.editor");
    int previewWidth = 300;
    int previewHeight = 200;
    boolean previewFitRegion = true;
    int nEvents1D = 1000;
    int nx1D = 50;
    double xMin1D = 1.0;
    double xMax1D = 101.0;
    int nEvents2D = 1000;
    int nx2D = 50;
    double xMin2D = 1.0;
    double xMax2D = 101.0;
    int ny2D = 50;
    double yMin2D = 1.0;
    double yMax2D = 101.0;
    int nEventsDps2D = 20;
    double xMinDps2D = 1.0;
    double xMaxDps2D = 21.0;
    double yMinDps2D = 10.0;
    double yMaxDps2D = 50.0;
    private JButton advancedButton;
    private JTextField previewWidthField;
    private JTextField previewHeightField;
    private JCheckBox previewFitRegionBox;
    private JPanel previewPanel;
    private JPanel advancedPanel;
    private JPanel hist1DPanel;
    private JPanel hist2DPanel;
    private JPanel dps2DPanel;
    private JSpinBox nEvents1DBox;
    private JSpinBox nx1DBox;
    private JTextField xMin1DField;
    private JTextField xMax1DField;
    private JSpinBox nEvents2DBox;
    private JSpinBox nx2DBox;
    private JSpinBox ny2DBox;
    private JTextField xMin2DField;
    private JTextField xMax2DField;
    private JTextField yMin2DField;
    private JTextField yMax2DField;
    private JSpinBox nEventsDps2DBox;
    private JTextField xMinDps2DField;
    private JTextField xMaxDps2DField;
    private JTextField yMinDps2DField;
    private JTextField yMaxDps2DField;

    public ConfigurePreviewPanel() {
        this((StyleEditorPanel)null);
    }

    public ConfigurePreviewPanel(StyleEditorPanel editorPanel) {
        this.init(editorPanel);
    }

    public void init(StyleEditorPanel editorPanel) {
        if (this.advancedPanel == null) {
            this.makePanel();
        }
        this.resetPanel();
    }

    public void validateInput() throws NumberFormatException {
        int i = Integer.parseInt(this.previewWidthField.getText());
        i = Integer.parseInt(this.previewHeightField.getText());
        double d = Double.parseDouble(this.xMin1DField.getText());
        d = Double.parseDouble(this.xMax1DField.getText());
        d = Double.parseDouble(this.xMin2DField.getText());
        d = Double.parseDouble(this.xMax2DField.getText());
        d = Double.parseDouble(this.yMin2DField.getText());
        d = Double.parseDouble(this.yMax2DField.getText());
        d = Double.parseDouble(this.xMinDps2DField.getText());
        d = Double.parseDouble(this.xMaxDps2DField.getText());
        d = Double.parseDouble(this.yMinDps2DField.getText());
        d = Double.parseDouble(this.yMaxDps2DField.getText());
    }

    public void readInput() throws NumberFormatException {
        this.previewWidth = Integer.parseInt(this.previewWidthField.getText());
        this.previewHeight = Integer.parseInt(this.previewHeightField.getText());
        this.previewFitRegion = this.previewFitRegionBox.isSelected();
        this.nEvents1D = this.nEvents1DBox.getValue();
        this.nx1D = this.nx1DBox.getValue();
        this.xMin1D = Double.parseDouble(this.xMin1DField.getText());
        this.xMax1D = Double.parseDouble(this.xMax1DField.getText());
        this.nEvents2D = this.nEvents2DBox.getValue();
        this.nx2D = this.nx2DBox.getValue();
        this.ny2D = this.ny2DBox.getValue();
        this.xMin2D = Double.parseDouble(this.xMin2DField.getText());
        this.xMax2D = Double.parseDouble(this.xMax2DField.getText());
        this.yMin2D = Double.parseDouble(this.yMin2DField.getText());
        this.yMax2D = Double.parseDouble(this.yMax2DField.getText());
        this.nEventsDps2D = this.nEventsDps2DBox.getValue();
        this.xMinDps2D = Double.parseDouble(this.xMinDps2DField.getText());
        this.xMaxDps2D = Double.parseDouble(this.xMaxDps2DField.getText());
        this.yMinDps2D = Double.parseDouble(this.yMinDps2DField.getText());
        this.yMaxDps2D = Double.parseDouble(this.yMaxDps2DField.getText());
    }

    public void resetPanel() {
        this.previewWidthField.setText(String.valueOf(this.previewWidth));
        this.previewHeightField.setText(String.valueOf(this.previewHeight));
        this.previewFitRegionBox.setSelected(this.previewFitRegion);
        this.previewWidthField.setEnabled(!this.previewFitRegion);
        this.previewHeightField.setEnabled(!this.previewFitRegion);
        this.nEvents1DBox.setValue(this.nEvents1D);
        this.nx1DBox.setValue(this.nx1D);
        this.xMin1DField.setText(String.valueOf(this.xMin1D));
        this.xMax1DField.setText(String.valueOf(this.xMax1D));
        this.nEvents2DBox.setValue(this.nEvents2D);
        this.nx2DBox.setValue(this.nx2D);
        this.ny2DBox.setValue(this.ny2D);
        this.xMin2DField.setText(String.valueOf(this.xMin2D));
        this.xMax2DField.setText(String.valueOf(this.xMax2D));
        this.yMin2DField.setText(String.valueOf(this.yMin2D));
        this.yMax2DField.setText(String.valueOf(this.yMax2D));
        this.nEventsDps2DBox.setValue(this.nEventsDps2D);
        this.xMinDps2DField.setText(String.valueOf(this.xMinDps2D));
        this.xMaxDps2DField.setText(String.valueOf(this.xMaxDps2D));
        this.yMinDps2DField.setText(String.valueOf(this.yMinDps2D));
        this.yMaxDps2DField.setText(String.valueOf(this.yMaxDps2D));
    }

    void previewFitRegionAction() {
        boolean fit = this.previewFitRegionBox.isSelected();
        this.previewWidthField.setEnabled(!fit);
        this.previewHeightField.setEnabled(!fit);
    }

    private void makePanel() {
        this.advancedButton = new JButton("Advanced");
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, ConfigurePreviewPanel.this.advancedButton);
                String title = "Advanced Preview Settings";
                boolean wrong = true;
                while (wrong) {
                    int reply = JOptionPane.showOptionDialog(frame, ConfigurePreviewPanel.this.advancedPanel, title, 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel");
                    if (reply == 0) {
                        try {
                            ConfigurePreviewPanel.this.validateInput();
                            wrong = false;
                        }
                        catch (Exception ex) {
                            String message = "Wrong input! Please correct: ";
                            message = message + "\n" + ex.getMessage();
                            JOptionPane.showMessageDialog(frame, message);
                        }
                        continue;
                    }
                    ConfigurePreviewPanel.this.resetPanel();
                    wrong = false;
                }
            }
        });
        this.previewWidthField = new JTextField(4);
        this.previewHeightField = new JTextField(4);
        this.previewFitRegionBox = new JCheckBox("Fit the Preview Region");
        this.previewFitRegionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurePreviewPanel.this.previewFitRegionAction();
            }
        });
        this.nEvents1DBox = new JSpinBox(this.nEvents1D, 0, 1000000);
        this.nx1DBox = new JSpinBox(this.nx1D, 0, 1000);
        this.xMin1DField = new JTextField(4);
        this.xMax1DField = new JTextField(4);
        this.nEvents2DBox = new JSpinBox(this.nEvents2D, 0, 1000000);
        this.nx2DBox = new JSpinBox(this.nx2D, 0, 1000);
        this.ny2DBox = new JSpinBox(this.ny2D, 0, 1000);
        this.xMin2DField = new JTextField(4);
        this.xMax2DField = new JTextField(4);
        this.yMin2DField = new JTextField(4);
        this.yMax2DField = new JTextField(4);
        this.nEventsDps2DBox = new JSpinBox(this.nEventsDps2D, 0, 1000000);
        this.xMinDps2DField = new JTextField(4);
        this.xMaxDps2DField = new JTextField(4);
        this.yMinDps2DField = new JTextField(4);
        this.yMaxDps2DField = new JTextField(4);
        this.packPanel();
    }

    private void packPanel() {
        this.advancedPanel = new JPanel();
        this.advancedPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.advancedPanel.setLayout(new BoxLayout(this.advancedPanel, 1));
        this.hist1DPanel = new JPanel();
        this.hist1DPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "IHistogram1D"));
        this.hist1DPanel.setLayout(new GridBagLayout());
        this.hist2DPanel = new JPanel();
        this.hist2DPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "IHistogram2D"));
        this.hist2DPanel.setLayout(new GridBagLayout());
        this.dps2DPanel = new JPanel();
        this.dps2DPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "IDataPointSet"));
        this.dps2DPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.hist1DPanel.add((Component)new JLabel("N Events"), gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.hist1DPanel.add((Component)this.nEvents1DBox, gbc);
        gbc.anchor = 17;
        gbc.gridy = 1;
        gbc.gridx = 0;
        this.hist1DPanel.add((Component)new JLabel("N Bins: "), gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.hist1DPanel.add((Component)this.nx1DBox, gbc);
        gbc.gridx = 2;
        gbc.anchor = 10;
        this.hist1DPanel.add((Component)new JLabel("X Min:"), gbc);
        gbc.gridx = 3;
        this.hist1DPanel.add((Component)this.xMin1DField, gbc);
        gbc.gridx = 4;
        this.hist1DPanel.add((Component)new JLabel("X Max:"), gbc);
        gbc.gridx = 5;
        this.hist1DPanel.add((Component)this.xMax1DField, gbc);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.hist2DPanel.add((Component)new JLabel("N Events"), gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.hist2DPanel.add((Component)this.nEvents2DBox, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.hist2DPanel.add((Component)new JLabel("X:  N Bins: "), gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.hist2DPanel.add((Component)this.nx2DBox, gbc);
        gbc.gridx = 2;
        gbc.anchor = 10;
        this.hist2DPanel.add((Component)new JLabel("X Min:"), gbc);
        gbc.gridx = 3;
        this.hist2DPanel.add((Component)this.xMin2DField, gbc);
        gbc.gridx = 4;
        this.hist2DPanel.add((Component)new JLabel("X Max:"), gbc);
        gbc.gridx = 5;
        this.hist2DPanel.add((Component)this.xMax2DField, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.hist2DPanel.add((Component)new JLabel("Y:  N Bins: "), gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.hist2DPanel.add((Component)this.ny2DBox, gbc);
        gbc.gridx = 2;
        gbc.anchor = 10;
        this.hist2DPanel.add((Component)new JLabel("Y Min:"), gbc);
        gbc.gridx = 3;
        this.hist2DPanel.add((Component)this.yMin2DField, gbc);
        gbc.gridx = 4;
        this.hist2DPanel.add((Component)new JLabel("Y Max:"), gbc);
        gbc.gridx = 5;
        this.hist2DPanel.add((Component)this.yMax2DField, gbc);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.dps2DPanel.add((Component)new JLabel("N Events"), gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.dps2DPanel.add((Component)this.nEventsDps2DBox, gbc);
        gbc.anchor = 10;
        gbc.gridy = 1;
        gbc.gridx = 2;
        this.dps2DPanel.add((Component)new JLabel("X Min:"), gbc);
        gbc.gridx = 3;
        this.dps2DPanel.add((Component)this.xMinDps2DField, gbc);
        gbc.gridx = 4;
        this.dps2DPanel.add((Component)new JLabel("X Max:"), gbc);
        gbc.gridx = 5;
        this.dps2DPanel.add((Component)this.xMaxDps2DField, gbc);
        gbc.gridy = 7;
        gbc.gridx = 2;
        this.dps2DPanel.add((Component)new JLabel("Y Min:"), gbc);
        gbc.gridx = 3;
        this.dps2DPanel.add((Component)this.yMinDps2DField, gbc);
        gbc.gridx = 4;
        this.dps2DPanel.add((Component)new JLabel("Y Max:"), gbc);
        gbc.gridx = 5;
        this.dps2DPanel.add((Component)this.yMaxDps2DField, gbc);
        this.advancedPanel.add(this.hist1DPanel);
        this.advancedPanel.add(this.hist2DPanel);
        this.advancedPanel.add(this.dps2DPanel);
        JPanel panel5 = new JPanel();
        panel5.setBorder(BorderFactory.createEtchedBorder(1));
        panel5.setLayout(new FlowLayout(2));
        panel5.add(this.advancedButton);
        this.previewPanel = new JPanel();
        this.previewPanel.setLayout(new GridBagLayout());
        this.previewPanel.setBorder(BorderFactory.createEtchedBorder(1));
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.previewPanel.add(this.previewFitRegionBox);
        gbc.gridy = 1;
        gbc.gridx = 0;
        this.previewPanel.add((Component)new JLabel("Preview Width: "), gbc);
        gbc.gridx = 1;
        this.previewPanel.add((Component)this.previewWidthField, gbc);
        gbc.gridx = 2;
        this.previewPanel.add((Component)new JLabel(" pixels"), gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        this.previewPanel.add((Component)new JLabel("Preview Height: "), gbc);
        gbc.gridx = 1;
        this.previewPanel.add((Component)this.previewHeightField, gbc);
        gbc.gridx = 2;
        this.previewPanel.add((Component)new JLabel(" pixels"), gbc);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.previewPanel);
        this.add(panel5);
    }
}

