/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.demo.gui.plugins;

import java.awt.event.ActionEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

@Plugin(name="Session Saver Demo Plugin", id="session-save-demo", description="Demo for saving and restoring sessions.", loadAtStart=false)
public class SessionSaverDemoPlugin
extends ConsolePlugin {
    private volatile int state;
    private PeriodicTask stateChanger;

    public void initialize() {
        this.getServices().addProperty("restoreOnStartup", (Object)false);
        this.getServices().addPreference(new String[]{"LSST", "Demo", "Config"}, null, "${restoreOnStartup} Restore on startup.");
        AbstractAction act = new AbstractAction("Keep changing state"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SessionSaverDemoPlugin.this.stateChanger == null) {
                    SessionSaverDemoPlugin.this.stateChanger = SessionSaverDemoPlugin.this.getConsole().getScheduler().scheduleAtFixedRate(() -> System.out.println("State changed to " + ++SessionSaverDemoPlugin.this.state), 5L, 5L, TimeUnit.SECONDS);
                } else {
                    SessionSaverDemoPlugin.this.stateChanger.cancel(true);
                    SessionSaverDemoPlugin.this.stateChanger = null;
                }
            }
        };
        act.putValue("SwingSelectedKey", false);
        this.getServices().addMenu((Action)act, new String[]{"Demo", "Configuration"});
    }

    public void start() {
        this.state = 0;
        if (((Boolean)this.getServices().getProperty("restoreOnStartup")).booleanValue()) {
            this.restore(this.getServices().getDescriptor().getConfiguration(), true);
        }
    }

    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        Descriptor config = (Descriptor)storageBean;
        this.state = config.getConfigParameter();
        return true;
    }

    public ComponentDescriptor save() {
        Descriptor configBean = new Descriptor(this.getServices().getDescriptor());
        configBean.setConfigParameter(this.state);
        return configBean;
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private int configParameter;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public int getConfigParameter() {
            return this.configParameter;
        }

        public void setConfigParameter(int configParameter) {
            this.configParameter = configParameter;
        }
    }
}

