/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.config.WriterProvider;

public class LocalConfigurationDAO
implements ConfigurationDAO {
    private static final Logger LOG = Logger.getLogger(LocalConfigurationDAO.class.getName());
    private final WriterProvider wp = WriterProvider.getInstance();

    public LocalConfigurationDAO() {
        LOG.log(Level.FINEST, "Created LocalConfigurationDAO wtih WriterProvider {0}", this.wp.getClass().getCanonicalName());
    }

    public SingleCategoryTagData loadCategoryTag(SingleCategoryTag singleCategoryTag) throws ConfigurationServiceException {
        LOG.log(Level.FINEST, "local loadconfig desc tags {0}", singleCategoryTag);
        try {
            String fileName = LocalConfigurationDAO.toPropertiesFileName(singleCategoryTag);
            InputStream is = this.wp.getInputStream(fileName);
            if (is == null) {
                throw new IOException("Could not find file " + fileName);
            }
            LOG.log(Level.INFO, "Loaded file {0}", this.wp.locateFile(fileName));
            SingleCategoryTag loadedTag = this.generateSingleCategoryTagWithVersion(singleCategoryTag, false);
            SingleCategoryTagData data = new SingleCategoryTagData(loadedTag);
            data.load(is);
            return data;
        }
        catch (IOException ioe) {
            throw new ConfigurationServiceException("Exception while loading " + singleCategoryTag, (Throwable)ioe);
        }
    }

    private SingleCategoryTag generateSingleCategoryTagWithVersion(SingleCategoryTag inputTag, boolean isSave) {
        return new SingleCategoryTag(inputTag);
    }

    public SingleCategoryTag saveCategoryTagData(SingleCategoryTagData data) throws ConfigurationServiceException {
        SingleCategoryTag singleCategoryTag = data.getSingleCategoryTag();
        try (PrintWriter writer = this.wp.getPrintWriter(LocalConfigurationDAO.toPropertiesFileName(data.getSingleCategoryTag()));){
            String dataStr = data.fullDataString();
            writer.println(dataStr);
            writer.flush();
        }
        catch (IOException ex) {
            throw new ConfigurationServiceException("could not open file", (Throwable)ex);
        }
        return this.generateSingleCategoryTagWithVersion(singleCategoryTag, true);
    }

    public static String toPropertiesFileName(SingleCategoryTag singleCategoryTag) {
        String category;
        StringBuilder sb = new StringBuilder();
        sb = sb.append(singleCategoryTag.getSource());
        String tag = singleCategoryTag.getTag();
        if (!tag.isEmpty()) {
            sb = sb.append("_").append(tag);
        }
        if (!(category = singleCategoryTag.getCategory()).isEmpty()) {
            if (!sb.toString().contains("_")) {
                sb = sb.append("_");
            }
            sb = sb.append("_").append(category);
        }
        return sb.append(".properties").toString();
    }
}

