package org.lsst.ccs.subsystem.demo.gui.configurationview;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.messaging.AgentMessagingLayer;

/**
 *
 * @author The LSST CCS Team
 */
public class SubsystemConfigurationViewTopPanel extends JPanel {
    private static final long serialVersionUID = 1249803483389190647L;
    
    private final AgentMessagingLayer aml;
    private final JComboBox<String> subsystemList = new JComboBox<>();
    private final JButton refresh = new JButton("refresh");
    private final JTabbedPane tabbedPane = new JTabbedPane();
    
    public SubsystemConfigurationViewTopPanel(AgentMessagingLayer aml){
        super(new BorderLayout());
        this.aml = aml;
        subsystemList.addActionListener(ae -> openConfigurationPane((String)subsystemList.getSelectedItem()));
        updateSubsystemList();
        refresh.addActionListener(ae -> updateSubsystemList());
        JPanel head = new JPanel(new FlowLayout());
        head.add(subsystemList);
        head.add(refresh);
        add(head, BorderLayout.NORTH);
        add(tabbedPane, BorderLayout.CENTER);
    }
    
    private void updateSubsystemList() {
        subsystemList.removeAllItems();
        subsystemList.addItem(null);
        List<AgentInfo> l = aml.getAgentPresenceManager().listConnectedAgents();
        for (AgentInfo ai : l) {
            if (ai.getType() == AgentInfo.AgentType.WORKER) {
                subsystemList.addItem(ai.getName());
            }
        }
    }
    
    private void openConfigurationPane(String name) {
        if (name == null) return;
        Integer index = tabbedPane.indexOfTab(name);
        if (index < 0) {
            SubsystemConfigurationViewPanel comp = new SubsystemConfigurationViewPanel(aml, name);
            tabbedPane.add(name, comp);
            index = tabbedPane.indexOfComponent(comp);
            ButtonTabComponent btc = new ButtonTabComponent(tabbedPane);
            
            tabbedPane.setTabComponentAt(index, new ButtonTabComponent(tabbedPane));
            comp.initGui();
        }
        tabbedPane.setSelectedIndex(index);
    }
}
