/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Point;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.alerts.InfrastructureAlert;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.InfluxDbClientService;
import org.lsst.ccs.services.PeriodicTaskComponent;
import org.lsst.ccs.services.SchedulerNode;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.PeriodicTaskExceptionHandler;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public final class AgentPeriodicTaskService
implements ServiceLifecycle,
HasLifecycle,
ClearAlertHandler,
AgentService {
    private static final Logger LOG_INFLUX = Logger.getLogger(AgentPeriodicTaskService.class.getName() + ".influx");
    private final ConcurrentHashMap<String, PeriodicTaskComponent> tasksMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicInteger> consecutiveFailuresCountMap = new ConcurrentHashMap();
    private final Object taskLock = new Object();
    private boolean hasBeenInitialized = false;
    private ComponentLookup lookupService;
    private ComponentNode agentPeriodicTaskNode;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private InfluxDbClientService influxDbClientService;
    private InfluxDB influxDB = null;
    private static final Object dataProcessingLock = new Object();
    private Map<String, String> influxTag = new HashMap<String, String>();
    private static final String DEFAULT_SCHEDULER_NAME = "default";
    private boolean useFullPaths = false;
    private final Map<String, SchedulerNode> schedulers = new HashMap<String, SchedulerNode>();
    private final Set<String> tasksBehind = new ConcurrentSkipListSet<String>();
    private final Set<String> tasksWithFaiuresWarning = new ConcurrentSkipListSet<String>();
    private final Set<String> tasksWithFaiuresAlarm = new ConcurrentSkipListSet<String>();
    private final Set<String> tasksSkipped = new ConcurrentSkipListSet<String>();
    private final Map<String, Integer> exceptionCounterMap = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> finalExceptionCounterMap = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> skippedExecutionsCounterMap = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> longExecutionsCounterMap = new ConcurrentHashMap<String, Integer>();
    private final Map<String, DataAccumulator> timingAccumMap = new ConcurrentHashMap<String, DataAccumulator>();

    @Override
    public String getAgentServiceName() {
        return "periodicTasks";
    }

    @Override
    public void preBuild() {
        this.lookupService = this.agent.getComponentLookup();
        this.agentPeriodicTaskNode = this.lookupService.getComponentNodeForObject((Object)this);
        this.createScheduler(DEFAULT_SCHEDULER_NAME, 8);
    }

    @Override
    public void build() {
        if (this.influxDbClientService != null) {
            this.influxDB = this.influxDbClientService.getInfluxDbClient();
        }
        if (this.influxDB != null) {
            AgentPeriodicTask periodicTaskDataProcessor = new AgentPeriodicTask("periodicTaskDataAccumulation", () -> this.processTaskData()).withPeriod(Duration.ofSeconds(60L));
            this.scheduleAgentPeriodicTask(periodicTaskDataProcessor);
            this.influxTag.put("type", this.agent.getAgentInfo().getType().name());
            this.influxTag.put("name", this.agent.getAgentInfo().getName());
            this.influxTag.put("host", this.agent.getAgentInfo().getAgentProperty("org.lsst.ccs.agent.hostname", ""));
            this.influxTag.put("user", this.agent.getAgentInfo().getAgentProperty("org.lsst.ccs.agent.username", ""));
        }
    }

    @Override
    public void preInit() {
        this.useFullPaths = "true".equals(this.agent.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
        this.hasBeenInitialized = true;
    }

    public Scheduler createScheduler(String name, int nThreads) {
        if (this.hasBeenInitialized) {
            throw new RuntimeException("Too late to schedule an AgentPeriodicTask. Tasks must be scheduled in the build phase of HasLifecycle.");
        }
        SchedulerNode schedulerNode = new SchedulerNode(name, nThreads);
        ComponentNode schedulerComponentNode = new ComponentNode("schedulers/" + name, (Object)schedulerNode);
        this.lookupService.addComponentNodeToLookup(this.agentPeriodicTaskNode, schedulerComponentNode);
        this.schedulers.put(name, schedulerNode);
        return schedulerNode.getScheduler();
    }

    SchedulerNode getScheduler(String name) {
        return this.schedulers.get(name);
    }

    public void scheduleAgentPeriodicTask(AgentPeriodicTask task) {
        this.scheduleAgentPeriodicTask(task, DEFAULT_SCHEDULER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAgentPeriodicTask(AgentPeriodicTask task, String schedulerName) {
        if (this.hasBeenInitialized) {
            throw new RuntimeException("Too late to schedule an AgentPeriodicTask. Tasks must be scheduled in the build phase of HasLifecycle.");
        }
        Object object = this.taskLock;
        synchronized (object) {
            if (this.tasksMap.containsKey(task.getTaskName())) {
                throw new RuntimeException("Task with name " + task.getTaskName() + " has already been scheduled. Tasks must be unique.");
            }
            SchedulerNode schedulerNode = this.getScheduler(schedulerName);
            if (schedulerNode == null) {
                throw new RuntimeException("Could not find scheduler " + schedulerName);
            }
            schedulerNode.addTask(task.getTaskName());
            PeriodicTaskComponent periodicTaskComponent = new PeriodicTaskComponent(task, schedulerNode.getScheduler(), new AgentPeriodicTaskExecutionHandler());
            this.tasksMap.put(task.getTaskName(), periodicTaskComponent);
            this.consecutiveFailuresCountMap.put(task.getTaskName(), new AtomicInteger(0));
            ComponentNode taskNode = new ComponentNode(task.getTaskName(), (Object)periodicTaskComponent);
            this.lookupService.addComponentNodeToLookup(this.agentPeriodicTaskNode, taskNode);
        }
    }

    public Duration getPeriodicTaskPeriod(String taskName) {
        PeriodicTaskComponent periodicTask = this.tasksMap.get(taskName);
        if (periodicTask == null) {
            throw new RuntimeException("PeriodicTask with name \"" + taskName + "\" does not exist.");
        }
        return Duration.ofMillis(periodicTask.getTaskPeriodMillis());
    }

    public void setPeriodicTaskPeriod(String taskName, Duration period) {
        PeriodicTaskComponent periodicTask = this.tasksMap.get(taskName);
        if (periodicTask == null) {
            throw new RuntimeException("PeriodicTask with name \"" + taskName + "\" does not exist.");
        }
        if (this.agent instanceof Subsystem && this.configurationService != null && this.stateService.getState().getState(ConfigurationState.class) != null) {
            this.configurationService.change(this.useFullPaths ? this.lookupService.getComponentNodeForObject((Object)periodicTask).getPath() : taskName, "taskPeriodMillis", period.toMillis());
            return;
        }
        periodicTask.setTaskPeriodMillis(period.toMillis());
    }

    @Command(name="getAgentPeriodicTaskNames", description="Get the list of the names of the scheduled tasks", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public List<String> getAgentPeriodicTaskNames() {
        return Collections.list(this.tasksMap.keys());
    }

    private List<PeriodicTaskComponent.PeriodicTaskWithScheduler> getPeriodicTasks() {
        ArrayList<PeriodicTaskComponent.PeriodicTaskWithScheduler> tasks = new ArrayList<PeriodicTaskComponent.PeriodicTaskWithScheduler>();
        for (PeriodicTaskComponent taskComponent : this.tasksMap.values()) {
            tasks.add(taskComponent.getTask());
        }
        return tasks;
    }

    private boolean isPeriodicTaskBehind(PeriodicTaskComponent.PeriodicTaskWithScheduler task) {
        String taskName = task.getPeriodicTask().getTaskName();
        this.tasksBehind.remove(taskName);
        return false;
    }

    private boolean isPeriodicTaskFailing(PeriodicTaskComponent.PeriodicTaskWithScheduler task) {
        int taskFailures = task.getPeriodicTask().getFailures();
        if (taskFailures > 0) {
            return true;
        }
        this.tasksWithFaiuresWarning.remove(task.getPeriodicTask().getTaskName());
        this.tasksWithFaiuresAlarm.remove(task.getPeriodicTask().getTaskName());
        return false;
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
        String alertId = alert.getAlertId();
        if (alertId.equals(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlertId())) {
            for (PeriodicTaskComponent.PeriodicTaskWithScheduler task : this.getPeriodicTasks()) {
                if (!this.isPeriodicTaskFailing(task)) continue;
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        if (alertId.equals(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlertId())) {
            for (PeriodicTaskComponent.PeriodicTaskWithScheduler task : this.getPeriodicTasks()) {
                boolean canClear = true;
                if (this.isPeriodicTaskBehind(task)) {
                    canClear = false;
                }
                if (canClear) continue;
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        if (alertId.equals(InfrastructureAlert.PERIODIC_TASK_SKIPPED.getAlertId())) {
            this.tasksSkipped.clear();
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTaskData() {
        HashMap<String, DataAccumulator> oldTimingAccumMap;
        HashMap<String, Integer> oldLongExecutionsCounterMap;
        HashMap<String, Integer> oldSkippedExecutionsCounterMap;
        HashMap<String, Integer> oldFinalExceptionCounterMap;
        HashMap<String, Integer> oldExceptionCounterMap;
        Iterator iterator = dataProcessingLock;
        synchronized (iterator) {
            oldExceptionCounterMap = new HashMap<String, Integer>(this.exceptionCounterMap);
            oldFinalExceptionCounterMap = new HashMap<String, Integer>(this.finalExceptionCounterMap);
            oldSkippedExecutionsCounterMap = new HashMap<String, Integer>(this.skippedExecutionsCounterMap);
            oldLongExecutionsCounterMap = new HashMap<String, Integer>(this.longExecutionsCounterMap);
            oldTimingAccumMap = new HashMap<String, DataAccumulator>(this.timingAccumMap);
            this.exceptionCounterMap.clear();
            this.finalExceptionCounterMap.clear();
            this.skippedExecutionsCounterMap.clear();
            this.longExecutionsCounterMap.clear();
            this.timingAccumMap.clear();
        }
        for (String taskName : this.tasksMap.keySet()) {
            DataAccumulator timing;
            Integer longExecutions;
            Integer skippedExecutions;
            Integer finalExceptions;
            long time = System.currentTimeMillis();
            Point.Builder pointBuilder = Point.measurement((String)"periodic_tasks_metrics").time(time, TimeUnit.MILLISECONDS);
            Integer exceptions = oldExceptionCounterMap.getOrDefault(taskName, 0);
            if (exceptions > 0) {
                pointBuilder = pointBuilder.addField("exceptions", (Number)exceptions);
            }
            if ((finalExceptions = oldFinalExceptionCounterMap.getOrDefault(taskName, 0)) > 0) {
                pointBuilder = pointBuilder.addField("final", (Number)finalExceptions);
            }
            if ((skippedExecutions = oldSkippedExecutionsCounterMap.getOrDefault(taskName, 0)) > 0) {
                pointBuilder = pointBuilder.addField("skipped", (Number)skippedExecutions);
            }
            if ((longExecutions = oldLongExecutionsCounterMap.getOrDefault(taskName, 0)) > 0) {
                pointBuilder = pointBuilder.addField("long", (Number)longExecutions);
            }
            if ((timing = (DataAccumulator)oldTimingAccumMap.get(taskName)) != null) {
                long period = this.tasksMap.get(taskName).getTaskPeriodMillis();
                pointBuilder = pointBuilder.addField("time_avg", timing.getAverageValue()).addField("time_max", timing.getMaxValue()).addField("percent_avg", 100.0 * timing.getAverageValue() / (double)period).addField("percent_max", 100.0 * timing.getMaxValue() / (double)period);
            }
            if (!pointBuilder.hasFields()) continue;
            Point point = pointBuilder.tag(this.influxTag).tag("task", taskName).tag(this.influxDbClientService.getGlobalTags()).build();
            LOG_INFLUX.log(Level.FINE, "Writing to influxDb {0}", point);
            this.influxDB.write(point);
        }
    }

    private void incrementCounter(String taskName, EventType type, int val) {
        if (this.influxDB == null) {
            return;
        }
        Map<String, Integer> map = null;
        switch (type) {
            case EXCEPTION: {
                map = this.exceptionCounterMap;
                break;
            }
            case SKIPPED: {
                map = this.skippedExecutionsCounterMap;
                break;
            }
            case FINAL_EXCEPTION: {
                map = this.finalExceptionCounterMap;
                break;
            }
            case LONG: {
                map = this.longExecutionsCounterMap;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot process event type: " + (Object)((Object)type));
            }
        }
        Integer counter = map.computeIfAbsent(taskName, n -> 0);
        counter = counter + val;
        map.put(taskName, counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementTiming(String taskName, double value, long period) {
        if (this.influxDB == null) {
            return;
        }
        Object object = dataProcessingLock;
        synchronized (object) {
            DataAccumulator timing = this.timingAccumMap.computeIfAbsent(taskName, n -> new DataAccumulator());
            timing.accumulate(value);
        }
    }

    private class DataAccumulator {
        private volatile double accum = 0.0;
        private volatile double max = -1.7976931348623157E308;
        private volatile int counter = 0;

        private DataAccumulator() {
        }

        public synchronized void accumulate(double value) {
            this.accum += value;
            ++this.counter;
            if (value > this.max) {
                this.max = value;
            }
        }

        public double getAverageValue() {
            return this.counter > 0 ? this.accum / (double)this.counter : Double.NaN;
        }

        public double getMaxValue() {
            return this.counter > 0 ? this.max : Double.NaN;
        }

        public double getTotalValue() {
            return this.accum;
        }

        public int getCounts() {
            return this.counter;
        }
    }

    private static enum EventType {
        EXCEPTION,
        FINAL_EXCEPTION,
        SKIPPED,
        LONG,
        SUCCESS;

    }

    public class AgentPeriodicTaskExecutionHandler
    extends PeriodicTaskExceptionHandler {
        AgentPeriodicTaskExecutionHandler() {
            this.setDetectLongExecutions(true);
            this.setSkipOverdueExecutions(true);
            this.setResetFailureCountOnSuccess(true);
        }

        public void onSkippedExecutions(PeriodicTask task, int nSkipped) {
            super.onSkippedExecutions(task, nSkipped);
            String taskName = task.getTaskName();
            if (AgentPeriodicTaskService.this.tasksSkipped.add(taskName)) {
                AgentPeriodicTaskService.this.alertService.raiseAlert(InfrastructureAlert.PERIODIC_TASK_SKIPPED.getAlert(), AlertState.WARNING, "Task " + taskName + " has skipped " + nSkipped + " executions. (" + AgentPeriodicTaskService.this.tasksSkipped + ")");
            }
            AgentPeriodicTaskService.this.incrementCounter(taskName, EventType.SKIPPED, nSkipped);
        }

        public void onFinalException(PeriodicTask task, Throwable exception) {
            super.onFinalException(task, exception);
            int taskFailures = task.getFailures();
            String taskName = task.getTaskName();
            int taskMaxFailures = task.getMaxFailures();
            AgentPeriodicTaskService.this.tasksWithFaiuresAlarm.add(taskName);
            AgentPeriodicTaskService.this.alertService.raiseAlert(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlert(), AlertState.ALARM, "Task " + taskName + " has experenced the maximum allowed number of exceptions: " + taskFailures + " (max:" + taskMaxFailures + "). It has stopped executing. (" + AgentPeriodicTaskService.this.tasksWithFaiuresAlarm + ").\nThe last exception was: " + exception.getMessage());
            AgentPeriodicTaskService.this.incrementCounter(taskName, EventType.FINAL_EXCEPTION, 1);
        }

        public void onException(PeriodicTask task, Throwable exception) {
            super.onException(task, exception);
            int taskFailures = task.getFailures();
            String taskName = task.getTaskName();
            if (taskFailures > 0) {
                int taskMaxFailures = task.getMaxFailures();
                if (!AgentPeriodicTaskService.this.tasksWithFaiuresWarning.add(taskName)) {
                    AgentPeriodicTaskService.this.alertService.raiseAlert(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlert(), AlertState.WARNING, "Task " + taskName + " has experienced " + taskFailures + " exceptions. The maximum allowed exceptions is " + taskMaxFailures + " (" + AgentPeriodicTaskService.this.tasksWithFaiuresWarning + ").\nThe last exception was: " + exception.getMessage());
                }
            }
            AgentPeriodicTaskService.this.incrementCounter(taskName, EventType.EXCEPTION, 1);
        }

        public void onLongExecution(PeriodicTask task) {
            super.onLongExecution(task);
            String taskName = task.getTaskName();
            if (AgentPeriodicTaskService.this.tasksBehind.add(taskName)) {
                AgentPeriodicTaskService.this.alertService.raiseAlert(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlert(), AlertState.WARNING, "The following tasks are falling behind: " + AgentPeriodicTaskService.this.tasksBehind + ". ");
            }
            AgentPeriodicTaskService.this.incrementCounter(taskName, EventType.LONG, 1);
        }

        public void onSuccessfulExecution(AgentPeriodicTask task, long time) {
            String taskName = task.getTaskName();
            long period = task.getPeriod().toMillis();
            AgentPeriodicTaskService.this.incrementTiming(taskName, time, period);
        }
    }
}

