/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class StringTokenizer {
    StringTokenizer() {
    }

    public static List<Token> tokenize(String input) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (input == null) {
            return result;
        }
        State state = State.WHITESPACE;
        int tokenIndex = -1;
        StringBuilder token = new StringBuilder("");
        int nBrackets = 0;
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (state) {
                case WHITESPACE: {
                    if (Character.isWhitespace(ch)) continue block8;
                    if (Character.isLetterOrDigit(ch) || ch == '_') {
                        state = State.WORD;
                        tokenIndex = i;
                        token.append(ch);
                        continue block8;
                    }
                    if (ch == '\"') {
                        state = State.STRINGDQ;
                        tokenIndex = i;
                        continue block8;
                    }
                    if (ch == '\'') {
                        state = State.STRINGSQ;
                        tokenIndex = i;
                        continue block8;
                    }
                    if (ch == '#') {
                        state = State.COMMENT;
                        continue block8;
                    }
                    if (ch == '[') {
                        state = State.SQUARE_BRAKET;
                        ++nBrackets;
                        token.append(ch);
                        tokenIndex = i;
                        continue block8;
                    }
                    state = State.WORD;
                    tokenIndex = i;
                    token.append(ch);
                    continue block8;
                }
                case WORD: {
                    if (Character.isWhitespace(ch)) {
                        result.add(new Token(tokenIndex, token.toString()));
                        token.setLength(0);
                        state = State.WHITESPACE;
                        continue block8;
                    }
                    if (ch == '#') {
                        result.add(new Token(tokenIndex, token.toString()));
                        token.setLength(0);
                        state = State.COMMENT;
                        continue block8;
                    }
                    token.append(ch);
                    continue block8;
                }
                case STRINGDQ: {
                    if (ch == '\"') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\"') {
                            token.append('\"');
                            ++i;
                            continue block8;
                        }
                        state = State.WORD;
                        continue block8;
                    }
                    token.append(ch);
                    continue block8;
                }
                case STRINGSQ: {
                    if (ch == '\'') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\'') {
                            token.append('\'');
                            ++i;
                            continue block8;
                        }
                        state = State.WORD;
                        continue block8;
                    }
                    token.append(ch);
                    continue block8;
                }
                case SQUARE_BRAKET: {
                    if (ch == '[') {
                        ++nBrackets;
                    } else if (ch == ']') {
                        --nBrackets;
                    }
                    token.append(ch);
                    if (nBrackets != 0) continue block8;
                    result.add(new Token(tokenIndex, token.toString()));
                    token.setLength(0);
                    state = State.WHITESPACE;
                    continue block8;
                }
                case COMMENT: {
                    continue block8;
                }
                default: {
                    assert (false) : "Unknown state in StringTokenizer state machine";
                    continue block8;
                }
            }
        }
        if (state == State.WORD || state == State.STRINGDQ || state == State.STRINGSQ) {
            result.add(new Token(tokenIndex, token.toString()));
        }
        return result;
    }

    private static enum State {
        WHITESPACE,
        WORD,
        STRINGDQ,
        STRINGSQ,
        COMMENT,
        SQUARE_BRAKET;

    }

    static class Token
    implements Serializable {
        private static final long serialVersionUID = 999886576830939492L;
        private int location;
        private String string;

        Token(int location, String string) {
            this.location = location;
            this.string = string;
        }

        int getLocation() {
            return this.location;
        }

        String getString() {
            return this.string;
        }
    }
}

