/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentStatus;
import org.lsst.ccs.gconsole.plugins.commandbrowser.Browser;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;

public class BrowserOneSubsystem
implements Browser {
    private Descriptor descriptor;
    private JPanel browserPanel;
    private AgentPanel agentPanel;
    private JLabel lockLabel;
    private JLabel levelLabel;
    private JLabel stateLabel;
    private JFormattedTextField levelField;
    private AgentStatus agent;
    private AgentStatusListener statusListener;
    private final AgentStatusAggregator statusAggregator = Console.getConsole().getStatusAggregator();

    @Override
    public JComponent getPanel() {
        if (this.browserPanel == null) {
            this.browserPanel = new JPanel(new BorderLayout());
            this.agentPanel = new AgentPanel();
            this.browserPanel.add((Component)this.agentPanel, "Center");
            Box lockPanel = Box.createHorizontalBox();
            this.browserPanel.add((Component)lockPanel, "North");
            lockPanel.add(Box.createRigidArea(Const.HDIM));
            this.lockLabel = new JLabel();
            lockPanel.add(this.lockLabel);
            this.lockLabel.setMinimumSize(new Dimension(ICON_UNLOCKED.getIconWidth(), ICON_UNLOCKED.getIconHeight()));
            this.lockLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        AgentLock lock = BrowserOneSubsystem.this.agent.getLock();
                        if (lock == null) {
                            BrowserOneSubsystem.this.agent.setLock(true);
                        } else if (lock.getOwnerAgentName().equals(Console.getConsole().getAgentInfo().getName())) {
                            BrowserOneSubsystem.this.agent.setLock(false);
                        }
                    }
                }
            });
            lockPanel.add(Box.createRigidArea(Const.HDIM));
            this.levelLabel = new JLabel("Level:");
            lockPanel.add(this.levelLabel);
            lockPanel.add(Box.createRigidArea(Const.HDIM));
            this.levelField = new JFormattedTextField((Object)0);
            lockPanel.add(this.levelField);
            this.levelField.setColumns(3);
            this.levelField.setMaximumSize(new Dimension(this.levelField.getPreferredSize().width, Integer.MAX_VALUE));
            this.levelField.addActionListener(e -> {
                try {
                    int level = (Integer)this.levelField.getValue();
                    if (this.agent != null) {
                        this.agent.setLevel(level);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            lockPanel.add(Box.createRigidArea(Const.HDIM));
            this.stateLabel = new JLabel("OFFLINE");
            lockPanel.add(this.stateLabel);
            lockPanel.add(Box.createHorizontalGlue());
            this.statusListener = new AgentStatusListener(){

                @Override
                public void connect(AgentStatusEvent event) {
                    SwingUtilities.invokeLater(() -> BrowserOneSubsystem.this.updateStateDisplay());
                }

                @Override
                public void disconnect(AgentStatusEvent event) {
                    SwingUtilities.invokeLater(() -> BrowserOneSubsystem.this.updateStateDisplay());
                }

                @Override
                public void statusChanged(AgentStatusEvent event) {
                    SwingUtilities.invokeLater(() -> BrowserOneSubsystem.this.updateStateDisplay());
                }
            };
            this.agent = new AgentStatus(this.descriptor.getAgent());
            this.agent.init();
            this.agent.addListener(e -> this.updateLockDisplay());
            this.updateLockDisplay();
            this.agentPanel.setAgent(this.agent);
            List<String> channels = Arrays.asList("/state/PhaseState", "/state/OperationalState", "/state/ConfigurationState", "/state/AlertState", "/state/CommandState");
            this.statusAggregator.addListener(this.statusListener, Collections.singleton(this.descriptor.getAgent()), channels);
        }
        return this.browserPanel;
    }

    @Override
    public void shutdown() {
        if (this.agent != null) {
            this.agent.shutdown();
        }
        this.statusAggregator.removeListener(this.statusListener);
        this.browserPanel = null;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    private void updateLockDisplay() {
        if (this.agent == null) {
            this.stateLabel.setText("OFFLINE");
        } else {
            AgentLock agentLock = this.agent.getLock();
            if (agentLock == null) {
                this.lockLabel.setIcon(ICON_UNLOCKED);
                this.lockLabel.setToolTipText("double-click to lock");
            } else if (agentLock.getOwnerAgentName().equals(Console.getConsole().getAgentInfo().getName())) {
                this.lockLabel.setIcon(ICON_LOCKED);
                this.lockLabel.setToolTipText("double-click to unlock");
            } else {
                this.lockLabel.setIcon(ICON_UNAVAILABLE);
                this.lockLabel.setToolTipText("locked by: " + agentLock.getAgentName());
            }
        }
        this.levelField.setValue(this.agent.getLevel());
    }

    private void updateStateDisplay() {
        CommandState com;
        AlertState als;
        ConfigurationState con;
        OperationalState ops;
        StateBundle state = this.statusAggregator.getAgentState(this.agent.getName());
        if (state == null) {
            this.stateLabel.setText("OFFLINE");
            return;
        }
        StringBuilder sb = new StringBuilder("<html>");
        PhaseState phase = (PhaseState)state.getState(PhaseState.class);
        if (phase != null) {
            sb.append(phase).append(" - ");
        }
        if ((ops = (OperationalState)state.getState(OperationalState.class)) != null) {
            switch (ops) {
                case NORMAL: {
                    sb.append("<font color=\"#008800\">NORMAL</font>");
                    break;
                }
                case ENGINEERING_FAULT: {
                    sb.append("<font color=\"#DD0000\">ENGINEERING_FAULT</font>");
                    break;
                }
                default: {
                    sb.append(ops);
                }
            }
            sb.append(" - ");
        }
        if ((con = (ConfigurationState)state.getState(ConfigurationState.class)) != null) {
            switch (con) {
                case DIRTY: {
                    sb.append("<font color=\"#0000DD\">MODIFIED CONFIGURATION</font>");
                    break;
                }
                default: {
                    sb.append(con);
                }
            }
            sb.append(" - ");
        }
        if ((als = (AlertState)state.getState(AlertState.class)) != null && !als.equals((Object)AlertState.NOMINAL)) {
            switch (als) {
                case WARNING: {
                    sb.append("<font color=\"#0000DD\">WARNING</font>");
                    break;
                }
                case ALARM: {
                    sb.append("<font color=\"#DD0000\">ALARM</font>");
                }
            }
            sb.append(" - ");
        }
        if ((com = (CommandState)state.getState(CommandState.class)) != null) {
            switch (com) {
                case READY: {
                    sb.append("<font color=\"#008800\">READY</font>");
                    break;
                }
                case ACTIVE: {
                    sb.append("<font color=\"#DD0000\">ACTIVE</font>");
                }
            }
        }
        this.stateLabel.setText(sb.toString());
    }

    @Override
    public Descriptor save() {
        if (this.agentPanel == null) {
            this.descriptor.setAgentPanel(null);
        } else {
            this.descriptor.setAgentPanel(this.agentPanel.save());
        }
        if (this.browserPanel != null) {
            this.descriptor.setPage(DataPanelDescriptor.get(this.browserPanel));
        }
        return this.descriptor;
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            AgentPanel.Descriptor apDesc;
            this.descriptor = (Descriptor)descriptor;
            if (this.agentPanel != null && (apDesc = this.descriptor.getAgentPanel()) != null) {
                this.agentPanel.restore(apDesc);
            }
        }
    }

    public static class Descriptor
    extends Browser.Descriptor {
    }
}

