/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.lang.management.ManagementFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.lsst.ccs.messaging.util.TimedExecutorMBean;
import org.lsst.ccs.utilities.logging.Logger;

public class TimedExecutor
extends ThreadPoolExecutor
implements TimedExecutorMBean {
    private final Logger logger;
    private final String name;
    private volatile int millisWaiting;
    private volatile int millisExecuting;

    private TimedExecutor(String threadName, final Logger logger) {
        super(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.name = threadName;
        this.logger = logger;
        super.setThreadFactory(new ThreadFactory(){
            private final ThreadFactory delegate = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.delegate.newThread(r);
                thread.setDaemon(true);
                thread.setName(TimedExecutor.this.name);
                thread.setUncaughtExceptionHandler((t, x) -> logger.warn((Object)(TimedExecutor.this.name + ": uncaught exception thrown by " + TimedExecutor.this.name), x));
                return thread;
            }
        });
    }

    public static TimedExecutor newInstance(String name, Logger logger) {
        TimedExecutor exec = new TimedExecutor(name, logger);
        try {
            ObjectName mbeanName = new ObjectName(name + ":type=TimedExecutor");
            ManagementFactory.getPlatformMBeanServer().registerMBean(exec, mbeanName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException x) {
            logger.error((Object)"Unable to register TimedExecutorMBean", (Throwable)x);
        }
        return exec;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }

    @Override
    public int getMillisWaiting() {
        return this.millisWaiting;
    }

    @Override
    public int getMillisExecuting() {
        return this.millisExecuting;
    }

    @Override
    public void execute(Runnable r) {
        Task task = new Task(r);
        super.execute(task);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        Task task = (Task)r;
        long currentTime = System.currentTimeMillis();
        this.millisWaiting = (int)(currentTime - task.getTime());
        task.setTime(currentTime);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Task task = (Task)r;
        this.millisExecuting = (int)(System.currentTimeMillis() - task.getTime());
    }

    @Override
    protected void terminated() {
        try {
            ObjectName mbeanName = new ObjectName(this.name + ":type=TimedExecutor");
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(mbeanName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException x) {
            this.logger.error((Object)"Unable to register TimedExecutorMBean", (Throwable)x);
        }
        super.terminated();
    }

    private static class Task
    implements Runnable {
        private final Runnable realRunnable;
        private long time = System.currentTimeMillis();

        Task(Runnable runnable) {
            this.realRunnable = runnable;
        }

        @Override
        public void run() {
            this.realRunnable.run();
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

